---
generated_at: 2026-02-02 10:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：68-ユーザー名前空間管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **AllocationBitmapの内部実装詳細**：別パッケージの実装

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/kubelet/userns/userns_manager.go` - User Namespace管理実装
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | userNsUnitLengthは65536 | E-01 (49行目) | ○ |
| C-02 | mapReInitializeThresholdは1000 | E-01 (46行目) | ○ |
| C-03 | UsernsManagerはAllocationBitmapとusedByマップを保持 | E-01 (52-65行目) | ○ |
| C-04 | userNamespace構造体はUID/GIDマッピングをJSON形式で保持 | E-01 (68-83行目) | ○ |
| C-05 | マッピングファイル名は"userns" | E-01 (86行目) | ○ |
| C-06 | kubeletMappingIDはuserNsLength以上が必須 | E-01 (154-157行目) | ○ |
| C-07 | kubeletMappingLen/userNsLength >= maxPodsが必須 | E-01 (161-163行目) | ○ |
| C-08 | 初期化時にディスクから既存マッピングを復元 | E-01 (177-190行目) | ○ |
| C-09 | allocateOneはビットマップからAllocateNextで割り当て | E-01 (225-237行目) | ○ |
| C-10 | UIDとGIDマッピングは同一内容が必須 | E-01 (334-342行目) | ○ |
| C-11 | ContainerID=0が必須 | E-01 (346-353行目) | ○ |
| C-12 | hostUsers=nil/trueの場合はNamespaceMode_NODEを返す | E-01 (401-419行目) | ○ |
| C-13 | ランタイム非対応時にエラーを返す | E-01 (424-433行目) | ○ |
| C-14 | releaseWithLockでマップ再初期化が行われる | E-01 (312-318行目) | ○ |
| C-15 | CleanupOrphanedでPod一覧とusedByを比較 | E-01 (484-532行目) | ○ |
| C-16 | FileStoreによるアトミック書き込み | E-01 (98-104行目) | ○ |
| C-17 | fsyncで永続化を保証 | E-01 (108-119行目) | ○ |
| C-18 | AllocationBitmapのO(1)操作 | **根拠なし** (allocator内部実装) | △ |

## 4) 不足情報（Unknown / Missing）
- AllocationBitmapのAllocateNext/Has/Release操作の計算量の正確な確認
  - 候補: `pkg/registry/core/service/allocator/bitmap.go`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - User Namespace管理の全体ロジックは確認済み
- 0: 低リスク - セキュリティ上重要なUID=0マッピング禁止ルールは確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] kubeletMappingIDがhostのUID 0マッピングを確実に防止しているか確認
- [ ] マッピングファイルのfsyncが全プラットフォームで信頼できるか確認
- [ ] 孤児クリーンアップの周期が適切か確認
- [ ] idsPerPodのデフォルト値が適切か確認
