---
generated_at: 2026-02-02 10:30:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：7-Deploymentコントローラー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **maxSurge/maxUnavailableのデフォルト値**：25%というデフォルト値の確認

## 2) 参照した情報（Evidence一覧）

- E-01: `pkg/controller/deployment/deployment_controller.go` 53-100行目 - maxRetries定数、DeploymentController構造体
- E-02: `pkg/controller/deployment/deployment_controller.go` 104-168行目 - NewDeploymentController関数
- E-03: `pkg/controller/deployment/deployment_controller.go` 171-199行目 - Run関数
- E-04: `pkg/controller/deployment/sync.go` 45-77行目 - syncStatusOnly, sync関数
- E-05: `pkg/controller/deployment/rolling.go` 31-66行目 - rolloutRolling関数
- E-06: `pkg/controller/deployment/recreate.go` 29-60行目 - rolloutRecreate関数
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.7の定義
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能No.7に関連する画面
- E-09: `pkg/controller/deployment/deployment_controller.go` 57-59行目 - maxRetries=15のコメント（バックオフ間隔の説明）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Deploymentリソースの宣言的更新を管理 | E-07 | ○ |
| C-02 | DeploymentController構造体がrsControl, client, syncHandler等を保持 | E-01 | ○ |
| C-03 | maxRetries = 15 | E-01, E-09 | ○ |
| C-04 | バックオフ間隔: 5ms*2^(n-1) | E-09 | ○ |
| C-05 | NewDeploymentControllerでInformerイベントハンドラを登録 | E-02 | ○ |
| C-06 | Deployment, ReplicaSet, PodのInformerを使用 | E-02 | ○ |
| C-07 | syncHandlerにsyncDeploymentが設定される（152行目） | E-02 | ○ |
| C-08 | Run関数でキャッシュ同期後ワーカー起動 | E-03 | ○ |
| C-09 | syncStatusOnlyで一時停止中のステータスのみ更新 | E-04 | ○ |
| C-10 | sync関数でスケーリングとクリーンアップ | E-04 | ○ |
| C-11 | rolloutRollingでローリングアップデート実行 | E-05 | ○ |
| C-12 | reconcileNewReplicaSetでスケールアップ | E-05 | ○ |
| C-13 | reconcileOldReplicaSetsでスケールダウン | E-05 | ○ |
| C-14 | rolloutRecreateで旧RS停止→新RS起動 | E-06 | ○ |
| C-15 | kubectl rolloutがAPI連携として関連 | E-08 | ○ |
| C-16 | kubectl scaleがAPI連携として関連 | E-08 | ○ |
| C-17 | controllerKind = apps.SchemeGroupVersion.WithKind("Deployment") | E-01 | ○ |
| C-18 | Pod削除イベントでDeploymentをエンキュー | E-02 | ○ |
| C-19 | orphan ReplicaSetのadoption処理 | E-02 | ○ |
| C-20 | deploymentCompleteチェック後にクリーンアップ | E-05 | ○ |
| C-21 | パス中のPaused条件チェック | E-04 | ○ |
| C-22 | maxSurge/maxUnavailableのデフォルト値25% | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- maxSurge/maxUnavailableのデフォルト値はAPI定義またはデフォルト値設定コードから確認すべき
  - 候補：`staging/src/k8s.io/api/apps/v1/types.go` のDeploymentStrategy定義、またはdefaulting関数

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードの行番号と処理内容は確認済み
- 0: 低リスク - 処理フローはソースコードの構造と一致
- 0: 低リスク - 画面マッピングはCSVデータと一致

## 6) レビュアーチェックリスト（最小）
- [ ] maxSurge/maxUnavailableのデフォルト値が25%であることをAPI定義で確認
- [ ] コードリーディングガイドの行番号が最新のソースコードと一致しているか確認
- [ ] プロポーショナルスケーリングのロジック詳細を確認
