---
generated_at: 2026-02-02 10:05:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：72-QoS管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし。全主張にソースコード根拠あり。

## 2) 参照した情報（Evidence一覧）
- E-01: `pkg/kubelet/qos/policy.go` - OOMスコア調整のメインロジック
- E-02: `pkg/kubelet/qos/helpers.go` - 補助計算関数
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | KubeletOOMScoreAdjは-999 | E-01 (30行目) | ○ |
| C-02 | guaranteedOOMScoreAdjは-997 | E-01 (33行目) | ○ |
| C-03 | besteffortOOMScoreAdjは1000 | E-01 (34行目) | ○ |
| C-04 | ノードクリティカルPodは-997が返される | E-01 (46-49行目) | ○ |
| C-05 | GuaranteedクラスPodは-997が返される | E-01 (52-54行目) | ○ |
| C-06 | BestEffortクラスPodは1000が返される | E-01 (55-56行目) | ○ |
| C-07 | Burstableの基本計算式 | E-01 (84行目) | ○ |
| C-08 | PodLevelResources有効時の計算式 | E-01 (77-82行目) | ○ |
| C-09 | サイドカーコンテナの判定条件 | E-01 (126-135行目) | ○ |
| C-10 | サイドカーのOOMスコア調整ロジック | E-01 (89-108行目) | ○ |
| C-11 | Burstable最小値の保証（3以上） | E-01 (112-113行目) | ○ |
| C-12 | BestEffort値と同一の場合の-1調整 | E-01 (116-117行目) | ○ |
| C-13 | minRegularContainerMemoryの算出 | E-02 (36-44行目) | ○ |
| C-14 | remainingPodMemReqPerContainerの算出 | E-02 (56-71行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードから直接確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] PodLevelResources有効時の計算が期待通りか確認
- [ ] サイドカーコンテナのOOMスコアが通常コンテナより優先保護されることを確認
