---
generated_at: 2026-02-02 10:15:00
metrics:
  claims_total: 15
  claims_with_evidence: 13
  claims_without_evidence: 2
confidence_derived: 0.87
---

# 根拠レポート：74-Serviceプロキシ（iptables）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.87**
  - 根拠あり：13 / 15、根拠なし：2
- 優先レビュー（高）
  1. **syncProxyRulesの詳細ロジック**：ファイル全体を読み込んでいないため詳細確認が必要
  2. **SessionAffinity実装の詳細**：具体的なiptablesルール生成箇所の確認が必要

## 2) 参照した情報（Evidence一覧）
- E-01: `pkg/proxy/iptables/proxier.go` - Proxier実装（先頭150行）
- E-02: `pkg/proxy/conntrack/cleanup.go` - conntrackクリーンアップ
- E-03: `pkg/proxy/topology.go` - トポロジー対応ルーティング
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | KUBE-SERVICESチェーン名定義 | E-01 (55行目) | ○ |
| C-02 | largeClusterEndpointsThreshold=1000 | E-01 (86行目) | ○ |
| C-03 | DualStack対応でMetaProxierを使用 | E-01 (93-130行目) | ○ |
| C-04 | Proxier構造体のフィールド定義 | E-01 (132-150行目) | ○ |
| C-05 | iptablesチェーン定数が8種類定義 | E-01 (53-87行目) | ○ |
| C-06 | sysctlRouteLocalnet設定 | E-01 (89行目) | ○ |
| C-07 | sysctlNFConntrackTCPBeLiberal設定 | E-01 (90行目) | ○ |
| C-08 | Linux専用ビルドタグ | E-01 (1行目) | ○ |
| C-09 | conntrackクリーンアップの実行 | E-02 | ○ |
| C-10 | トポロジー対応ルーティングの統合 | E-03 | ○ |
| C-11 | NewProxierでChangeTrackerが初期化される | E-01 (import) | ○ |
| C-12 | healthcheckサーバーとの連携 | E-01 (import, 107行目) | ○ |
| C-13 | BoundedFrequencyRunnerによる同期制御 | E-01 (import) | ○ |
| C-14 | syncProxyRulesの詳細なルール生成ロジック | **根拠なし** | △ |
| C-15 | SessionAffinityの具体的な実装 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-14: syncProxyRulesの全体（数百行に及ぶ）を読み込んでいないため、ルール生成の詳細が未確認
  - 候補：`pkg/proxy/iptables/proxier.go`の後半部分
- C-15: SessionAffinity用のiptablesルール（recent module等）の具体的な実装が未確認
  - 候補：syncProxyRules内のSessionAffinity処理部分

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - syncProxyRulesの完全な読解が行われていない
- 0: 低リスク - アーキテクチャ・構造レベルの記述は正確

## 6) レビュアーチェックリスト（最小）
- [ ] syncProxyRulesの完全なルール生成ロジックを確認
- [ ] SessionAffinity実装の詳細を確認
- [ ] LoadBalancerSourceRangesのファイアウォールルール生成を確認
