---
generated_at: 2026-02-02 10:20:00
metrics:
  claims_total: 14
  claims_with_evidence: 12
  claims_without_evidence: 2
confidence_derived: 0.86
---

# 根拠レポート：75-Serviceプロキシ（IPVS）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.86**
  - 根拠あり：12 / 14、根拠なし：2
- 優先レビュー（高）
  1. **syncProxyRulesの完全なロジック**：ファイル全体を読み込んでいない
  2. **Graceful Terminationの詳細実装**：graceful_termination.goの内容未確認

## 2) 参照した情報（Evidence一覧）
- E-01: `pkg/proxy/ipvs/proxier.go` - IPVS Proxier実装（先頭150行）
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | defaultScheduler = "rr" | E-01 (91行目) | ○ |
| C-02 | defaultDummyDevice = "kube-ipvs0" | E-01 (94行目) | ○ |
| C-03 | IPVS固有チェーン定数の定義 | E-01 (57-95行目) | ○ |
| C-04 | sysctl定数の定義 | E-01 (98-106行目) | ○ |
| C-05 | DualStack対応でMetaProxierを使用 | E-01 (108-150行目) | ○ |
| C-06 | Linux専用ビルドタグ | E-01 (1行目) | ○ |
| C-07 | conntrackパッケージのインポート | E-01 (44行目) | ○ |
| C-08 | healthcheckパッケージのインポート | E-01 (45行目) | ○ |
| C-09 | ipset/ipvsパッケージの使用 | E-01 (46-47行目) | ○ |
| C-10 | iptablesパッケージとの併用 | E-01 (52行目) | ○ |
| C-11 | BoundedFrequencyRunnerの使用 | E-01 (51行目 runner import) | ○ |
| C-12 | filterCIDRsによるexcludeCIDRsのフィルタリング | E-01 (135行目) | ○ |
| C-13 | syncProxyRulesの完全な処理フロー | **根拠なし** | △ |
| C-14 | Graceful Terminationの詳細な動作 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-13: proxier.goの後半部分（syncProxyRules）が未読のため詳細未確認
  - 候補：`pkg/proxy/ipvs/proxier.go` の後半
- C-14: graceful_termination.goが未読
  - 候補：`pkg/proxy/ipvs/graceful_termination.go`

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - IPVSモードは複数コンポーネントの組み合わせのため、全体像の確認が重要

## 6) レビュアーチェックリスト（最小）
- [ ] syncProxyRulesの完全なIPVS仮想/リアルサーバー管理ロジックを確認
- [ ] Graceful Terminationの動作を確認
- [ ] ipsetエントリの管理ロジックを確認
