---
generated_at: 2026-02-02 10:25:00
metrics:
  claims_total: 13
  claims_with_evidence: 11
  claims_without_evidence: 2
confidence_derived: 0.85
---

# 根拠レポート：76-Serviceプロキシ（nftables）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.85**
  - 根拠あり：11 / 13、根拠なし：2
- 優先レビュー（高）
  1. **syncProxyRulesの完全なトランザクション構築ロジック**
  2. **各nftablesマップ/セットの具体的な使用方法**

## 2) 参照した情報（Evidence一覧）
- E-01: `pkg/proxy/nftables/proxier.go` - nftables Proxier実装（先頭150行）
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | kubeProxyTable = "kube-proxy" | E-01 (58行目) | ○ |
| C-02 | ベースチェーン8種類の定義 | E-01 (61-68行目) | ○ |
| C-03 | service dispatch用チェーン/マップ定義 | E-01 (71-73行目) | ○ |
| C-04 | エンドポイントなし処理用チェーン/マップ定義 | E-01 (82-86行目) | ○ |
| C-05 | firewall用マップ/チェーン定義 | E-01 (92-93行目) | ○ |
| C-06 | masqueradingチェーン定義 | E-01 (96行目) | ○ |
| C-07 | DualStack対応でMetaProxierを使用 | E-01 (99-134行目) | ○ |
| C-08 | Proxier構造体にendpointsChanges/serviceChanges | E-01 (145-146行目) | ○ |
| C-09 | knftablesライブラリの使用 | E-01 (52行目 import) | ○ |
| C-10 | rate.Limiterの使用 | E-01 (34行目 import) | ○ |
| C-11 | Linux専用ビルドタグ | E-01 (1行目) | ○ |
| C-12 | syncProxyRulesの完全なトランザクション構築 | **根拠なし** | △ |
| C-13 | アトミックトランザクションの保証 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-12: syncProxyRulesの全体が未読のため、トランザクション構築の詳細が未確認
  - 候補：`pkg/proxy/nftables/proxier.go` の後半
- C-13: knftablesのトランザクション保証はライブラリの仕様に依存
  - 候補：`sigs.k8s.io/knftables` ライブラリのドキュメント

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - nftablesモードは比較的新しい実装のため、注意深いレビューが必要

## 6) レビュアーチェックリスト（最小）
- [ ] syncProxyRulesのnftablesトランザクション構築の完全なフローを確認
- [ ] knftablesライブラリのトランザクション保証レベルを確認
- [ ] iptablesモードとの機能的な差異を確認
