---
generated_at: 2026-02-02 10:35:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：78-Conntrack管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし。全主張にソースコード根拠あり。

## 2) 参照した情報（Evidence一覧）
- E-01: `pkg/proxy/conntrack/conntrack.go` - conntrackインターフェースと実装
- E-02: `pkg/proxy/conntrack/cleanup.go` - CleanStaleEntriesロジック
- E-03: `pkg/proxy/conntrack/filter.go` - flowFilterとflowKey
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Interface定義（ListEntries/DeleteEntries） | E-01 (32-35行目) | ○ |
| C-02 | netlink.Handleベースの実装 | E-01 (51行目) | ○ |
| C-03 | ListEntriesのEINTRリトライ | E-01 (60-64行目) | ○ |
| C-04 | DeleteEntriesのflowFilter使用 | E-01 (74-79行目) | ○ |
| C-05 | UDPプロトコルのみ対象 | E-02 (69行目, 118行目) | ○ |
| C-06 | serviceIPEndpointsマッピング構築 | E-02 (63行目) | ○ |
| C-07 | serviceNodePortEndpointsマッピング構築 | E-02 (65行目) | ○ |
| C-08 | ClusterIP/LB/ExternalIP/NodePort対応 | E-02 (97-112行目) | ○ |
| C-09 | IsServing()によるエンドポイント判定 | E-02 (83行目) | ○ |
| C-10 | Forward.Dst/Reverse.Srcによる突合 | E-02 (122-127行目) | ○ |
| C-11 | エンドポイント0のServiceをスキップ | E-02 (90-92行目) | ○ |
| C-12 | メトリクス記録 | E-02 (155-156行目) | ○ |
| C-13 | flowKeyの9フィールド構成 | E-03 (48-58行目) | ○ |
| C-14 | MatchConntrackFlowの実装 | E-03 (61-68行目) | ○ |
| C-15 | ipFamilyMapの定義 | E-02 (160-163行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードから直接確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] トラフィックポリシーを無視してクリーンアップする設計方針が適切か確認
- [ ] EINTR時の部分結果での処理継続が安全か確認
