---
generated_at: 2026-02-02 10:45:00
metrics:
  claims_total: 16
  claims_with_evidence: 14
  claims_without_evidence: 2
confidence_derived: 0.88
---

# 根拠レポート：80-リソース取得（get）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：14 / 16、根拠なし：2
- 優先レビュー（高）
  1. **Run関数の完全な実行ロジック**：ファイル後半部分が未読
  2. **Watch モードの詳細実装**：watchtools.UntilWithoutRetryの呼び出し詳細

## 2) 参照した情報（Evidence一覧）
- E-01: `staging/src/k8s.io/kubectl/pkg/cmd/get/get.go` - getコマンド実装（先頭350行）
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GetOptions構造体の定義 | E-01 (55-85行目) | ○ |
| C-02 | getLong/getExampleの定義 | E-01 (88-141行目) | ○ |
| C-03 | デフォルトチャンクサイズ500 | E-01 (154行目) | ○ |
| C-04 | デフォルトServerPrint=true | E-01 (155行目) | ○ |
| C-05 | NewCmdGetのcobra.Command構築 | E-01 (161-194行目) | ○ |
| C-06 | Complete関数の名前空間解決 | E-01 (206行目) | ○ |
| C-07 | サーバーサイドプリントの判定条件 | E-01 (222-225行目) | ○ |
| C-08 | ToPrinterのプリンターチェーン構築 | E-01 (237-270行目) | ○ |
| C-09 | Watch + Sort時の警告出力 | E-01 (274-276行目) | ○ |
| C-10 | Validate関数のRAW排他チェック | E-01 (298-309行目) | ○ |
| C-11 | show-labelsと出力フォーマットの互換性チェック | E-01 (310-315行目) | ○ |
| C-12 | output-watch-eventsの依存チェック | E-01 (316-318行目) | ○ |
| C-13 | SuggestFor: "list", "ps" | E-01 (176行目) | ○ |
| C-14 | --raw, --watch, --field-selectorフラグ登録 | E-01 (181-192行目) | ○ |
| C-15 | Run関数の完全な実行ロジック | **根拠なし** | △ |
| C-16 | Watchモードの詳細実装 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-15: get.goの後半（Run関数の本体）が未読
  - 候補：`staging/src/k8s.io/kubectl/pkg/cmd/get/get.go` の後半
- C-16: Watch/WatchOnlyモードの実装詳細が未確認
  - 候補：Run関数内のWatch処理部分

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - Run関数のメインロジックが未確認
- 0: 低リスク - Complete/Validateの記述はソースコードと一致

## 6) レビュアーチェックリスト（最小）
- [ ] Run関数の完全な実行フローを確認
- [ ] Watchモードの実装詳細を確認
- [ ] resource.Builderの使用方法と設定を確認
- [ ] ページング取得（ChunkSize）の動作を確認
