---
generated_at: 2026-02-02 10:00:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：81-リソース作成（create）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **RBAC権限要件の詳細**：Kubernetes公式ドキュメントに基づく記述であるが、コード内では直接確認できない

## 2) 参照した情報（Evidence一覧）
- E-01: `staging/src/k8s.io/kubectl/pkg/cmd/create/create.go` - CreateOptions構造体定義（51-70行目）
- E-02: `staging/src/k8s.io/kubectl/pkg/cmd/create/create.go` - NewCmdCreate関数（102-154行目）
- E-03: `staging/src/k8s.io/kubectl/pkg/cmd/create/create.go` - Validate関数（157-187行目）
- E-04: `staging/src/k8s.io/kubectl/pkg/cmd/create/create.go` - RunCreate関数（225-301行目）
- E-05: `staging/src/k8s.io/kubectl/pkg/cmd/create/create.go` - RunEditOnCreate関数（304-324行目）
- E-06: `staging/src/k8s.io/kubectl/pkg/cmd/create/create.go` - CreateSubcommandOptions（340-470行目）
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.81の定義
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面No.1の関連情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CreateOptionsは51-70行目で定義される | E-01 | ○ |
| C-02 | JSON/YAML形式を受け付ける | E-02（createLong記述） | ○ |
| C-03 | --rawと--editは排他 | E-03（163-165行目） | ○ |
| C-04 | --rawは単一ローカルファイルのみ | E-03（166-167行目） | ○ |
| C-05 | --rawはURLからの読み込み不可 | E-03（169-171行目） | ○ |
| C-06 | 位置引数は受け付けない | E-04（191-193行目のComplete） | ○ |
| C-07 | Raw指定時はrawhttp.RawPostを呼び出す | E-04（228-233行目） | ○ |
| C-08 | Edit指定時はRunEditOnCreateを呼び出す | E-04（236-238行目） | ○ |
| C-09 | ResourceBuilderでオブジェクトを構築する | E-04（250-258行目） | ○ |
| C-10 | CreateOrUpdateAnnotationでアノテーション付与 | E-04（269-271行目） | ○ |
| C-11 | resource.NewHelper.Createで作成リクエスト | E-04（278-283行目） | ○ |
| C-12 | count==0でエラー | E-04（297-299行目） | ○ |
| C-13 | 17個のサブコマンドが登録される | E-02（136-152行目） | ○ |
| C-14 | フィールドマネージャーのデフォルトはkubectl-create | E-02（131行目） | ○ |
| C-15 | DryRunClient時はAPI呼び出しをスキップ | E-04（277行目） | ○ |
| C-16 | サブコマンドはStructuredGeneratorパターン | E-06（421行目） | ○ |
| C-17 | DynamicClientを使用してリソース作成 | E-06（456行目） | ○ |
| C-18 | EditBeforeCreateModeでエディタ経由作成 | E-05（305行目） | ○ |
| C-19 | RBAC create権限が必要 | **根拠なし** | △ |
| C-20 | 画面No.1がkubectl createに対応 | E-08 | ○ |

## 4) 不足情報（Unknown / Missing）
- RBAC権限要件はKubernetes APIの一般的な仕様であるが、createコマンドのコード内には直接的なRBAC権限チェックのロジックは存在しない（API Server側で処理される）
  - 候補：Kubernetes公式ドキュメント / API Server認可コード / RBACテストケース

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コードから直接確認可能な内容がほとんどであり、信頼度は高い

## 6) レビュアーチェックリスト（最小）
- [ ] CreateOptions構造体のフィールドが設計書の入力パラメータと一致しているか
- [ ] サブコマンド一覧が最新のコードと一致しているか
- [ ] エラーケースの網羅性は十分か
