---
generated_at: 2026-02-02 10:05:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：82-宣言的適用（apply）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **patcher.goのThree-way merge詳細**：patcher.goの詳細コードは概要レベルでの参照のみ

## 2) 参照した情報（Evidence一覧）
- E-01: `staging/src/k8s.io/kubectl/pkg/cmd/apply/apply.go` - ApplyFlags構造体（60-79行目）
- E-02: `staging/src/k8s.io/kubectl/pkg/cmd/apply/apply.go` - ApplyOptions構造体（82-142行目）
- E-03: `staging/src/k8s.io/kubectl/pkg/cmd/apply/apply.go` - NewCmdApply関数（198-223行目）
- E-04: `staging/src/k8s.io/kubectl/pkg/cmd/apply/apply.go` - Validate関数（390-448行目）
- E-05: `staging/src/k8s.io/kubectl/pkg/cmd/apply/apply.go` - Run関数（500-553行目）
- E-06: `staging/src/k8s.io/kubectl/pkg/cmd/apply/apply.go` - applyOneObject関数（555-780行目）
- E-07: `staging/src/k8s.io/kubectl/pkg/cmd/apply/apply.go` - フィールドマネージャー定数（1088-1101行目）
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面No.30

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ApplyFlagsは60-79行目で定義 | E-01 | ○ |
| C-02 | ApplyOptionsは82-142行目で定義 | E-02 | ○ |
| C-03 | --force-conflictsは--server-sideが必要 | E-04（391-393行目） | ○ |
| C-04 | --dry-run=clientと--server-sideは排他 | E-04（395-397行目） | ○ |
| C-05 | --forceと--server-sideは排他 | E-04（399-401行目） | ○ |
| C-06 | --allと--selectorは排他 | E-04（407-409行目） | ○ |
| C-07 | --applysetは--pruneが必要 | E-04（411-414行目） | ○ |
| C-08 | --subresourceは--server-sideが必要 | E-04（443-445行目） | ○ |
| C-09 | CSAフィールドマネージャーはkubectl-client-side-apply | E-07（1093行目） | ○ |
| C-10 | SSAフィールドマネージャーはkubectl | E-07（1098行目） | ○ |
| C-11 | SSAでApplyPatchTypeを使用 | E-06（590行目） | ○ |
| C-12 | CSAでリソース未存在時にhelper.Create | E-06（699行目） | ○ |
| C-13 | CSAでリソース存在時にpatcher.Patch | E-06（743行目） | ○ |
| C-14 | PostProcessorFnでプルーニング実行 | E-05（545-550行目） | ○ |
| C-15 | ContinueOnErrorでエラー集約 | E-05（515-543行目） | ○ |
| C-16 | SSAマイグレーション処理が存在 | E-06（627行目） | ○ |
| C-17 | last-applied-configurationアノテーション保存 | E-06（625行目） | ○ |
| C-18 | 3つのサブコマンドが登録される | E-03（218-220行目） | ○ |
| C-19 | OpenAPI V3スキーマを使用 | E-02（109行目、OpenAPIV3Root） | ○ |
| C-20 | VisitedUidsでプルーニング対象を判定 | E-02（128行目） | ○ |
| C-21 | patcher.goでThree-way mergeを実行 | **根拠なし（概要レベル）** | △ |
| C-22 | 画面No.30がkubectl applyに対応 | E-08 | ○ |

## 4) 不足情報（Unknown / Missing）
- patcher.goの詳細なThree-way mergeアルゴリズムは概要レベルでの参照にとどまる
  - 候補：patcher.go / strategic merge patchライブラリ / OpenAPIスキーマ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な処理フローはapply.goから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] SSAとCSAの切り替え条件が正確に記述されているか
- [ ] バリデーションの排他制約がすべて網羅されているか
- [ ] プルーニングの動作条件が正確か
