---
generated_at: 2026-02-02 10:20:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：85-リソースパッチ（patch）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. 特になし - 全主張にコード根拠あり

## 2) 参照した情報（Evidence一覧）
- E-01: `staging/src/k8s.io/kubectl/pkg/cmd/patch/patch.go` - PatchOptions構造体（54-78行目）
- E-02: `staging/src/k8s.io/kubectl/pkg/cmd/patch/patch.go` - patchTypesマップ（50行目）
- E-03: `staging/src/k8s.io/kubectl/pkg/cmd/patch/patch.go` - NewCmdPatch（117-147行目）
- E-04: `staging/src/k8s.io/kubectl/pkg/cmd/patch/patch.go` - Validate（181-199行目）
- E-05: `staging/src/k8s.io/kubectl/pkg/cmd/patch/patch.go` - RunPatch（202-316行目）
- E-06: `staging/src/k8s.io/kubectl/pkg/cmd/patch/patch.go` - getPatchedJSON（318-350行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PatchOptionsは54-78行目で定義 | E-01 | ○ |
| C-02 | 3種類のパッチタイプをサポート | E-02 | ○ |
| C-03 | --patchと--patch-fileは排他 | E-04（182-183行目） | ○ |
| C-04 | いずれか必須 | E-04（185-186行目） | ○ |
| C-05 | --localとサーバーリソースは排他 | E-04（188-189行目） | ○ |
| C-06 | --localと--dry-run=serverは排他 | E-04（191-192行目） | ○ |
| C-07 | パッチタイプのデフォルトはstrategic | E-03（139行目） | ○ |
| C-08 | フィールドマネージャーのデフォルトはkubectl-patch | E-03（143行目） | ○ |
| C-09 | YAML→JSON変換を実行 | E-05（219-221行目） | ○ |
| C-10 | helper.Patchでサーバーパッチ | E-05（259行目） | ○ |
| C-11 | reflect.DeepEqualで変更検出 | E-05（267行目） | ○ |
| C-12 | RecordMergePatchで変更記録 | E-05（270-278行目） | ○ |
| C-13 | getPatchedJSONでローカルパッチ | E-06 | ○ |
| C-14 | JSONPatchTypeではjsonpatch.DecodePatch.Apply | E-06（321-333行目） | ○ |
| C-15 | MergePatchTypeではjsonpatch.MergePatch | E-06（335-336行目） | ○ |
| C-16 | StrategicMergePatchTypeではstrategicpatch.StrategicMergePatch | E-06（338-344行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張にコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] 3種類のパッチタイプの説明が正確か
- [ ] ローカルパッチの挙動説明が正確か
