---
generated_at: 2026-02-02 10:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：90-ロールアウト管理（rollout）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **restartサブコマンドのrestartedAtアノテーション**：rollout_restart.goの詳細は未確認

## 2) 参照した情報（Evidence一覧）
- E-01: `staging/src/k8s.io/kubectl/pkg/cmd/rollout/rollout.go` - NewCmdRollout（57-75行目）
- E-02: `staging/src/k8s.io/kubectl/pkg/cmd/rollout/rollout_status.go` - RolloutStatusOptions（64-82行目）
- E-03: `staging/src/k8s.io/kubectl/pkg/cmd/rollout/rollout_status.go` - Run（160-243行目）
- E-04: `staging/src/k8s.io/kubectl/pkg/cmd/rollout/rollout_undo.go` - UndoOptions（38-53行目）
- E-05: `staging/src/k8s.io/kubectl/pkg/cmd/rollout/rollout_undo.go` - RunUndo（141-179行目）
- E-06: `staging/src/k8s.io/kubectl/pkg/cmd/rollout/rollout_history.go` - RolloutHistoryOptions（50-67行目）
- E-07: `staging/src/k8s.io/kubectl/pkg/cmd/rollout/rollout_history.go` - Run（142-231行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 6つのサブコマンドが登録される | E-01（67-72行目） | ○ |
| C-02 | 対象リソースはdeployment/daemonset/statefulset | rollout.go（47-53行目） | ○ |
| C-03 | statusのwatchデフォルトはtrue | E-02（90行目） | ○ |
| C-04 | statusのtimeoutデフォルトは0 | E-02（91行目） | ○ |
| C-05 | UntilWithSyncでWatch処理 | E-03（202行目） | ○ |
| C-06 | Added/ModifiedでstatusViewer.Status呼び出し | E-03（204-205行目） | ○ |
| C-07 | Deletedでエラー | E-03（222-224行目） | ○ |
| C-08 | watchがfalseの場合、即座に終了 | E-03（216-218行目） | ○ |
| C-09 | undoのToRevisionデフォルトは0 | E-04（75行目） | ○ |
| C-10 | RollbackerFnでRollbacker取得 | E-05（160行目） | ○ |
| C-11 | rollbacker.Rollback呼び出し | E-05（165行目） | ○ |
| C-12 | historyのrevision検証 | E-07（131-136行目） | ○ |
| C-13 | -o指定時にGetHistoryでリビジョン詳細取得 | E-07（170-174行目） | ○ |
| C-14 | テキスト出力時にViewHistory | E-07（214行目） | ○ |
| C-15 | リソース未指定でエラー | E-03（148-149行目）, E-05（134行目） | ○ |
| C-16 | revision負数でエラー | E-03（152-153行目）, E-07（134-136行目） | ○ |
| C-17 | ContextWithOptionalTimeoutでタイムアウト制御 | E-03（199行目） | ○ |
| C-18 | restartがrestartedAtアノテーション設定 | **根拠なし（概要レベル）** | △ |

## 4) 不足情報（Unknown / Missing）
- rollout_restart.goの詳細な実装（restartedAtアノテーションの設定処理）は直接読み込んでいない
  - 候補：rollout_restart.go / polymorphichelpers/objectrestarter.go

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要なサブコマンド（status, undo, history）は詳細に確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 6つのサブコマンドの説明が正確か
- [ ] Watch APIの動作（新リビジョン追従、削除検出）が正確か
- [ ] restartサブコマンドの動作メカニズムが正確か
