---
generated_at: 2026-02-02 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：91-スケーリング（scale）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件の記述**：具体的な数値基準の根拠なし

## 2) 参照した情報（Evidence一覧）

- E-01: `staging/src/k8s.io/kubectl/pkg/cmd/scale/scale.go` - scaleコマンド実装
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（No.91）
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング（画面No.10）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 対応リソースはdeployment, replicaset, replicationcontroller, statefulset | E-01 (109行目 validArgs) | ○ |
| C-02 | --replicasは必須フラグ | E-01 (132行目 MarkFlagRequired) | ○ |
| C-03 | replicasは0以上である必要がある | E-01 (181-183行目 Validate) | ○ |
| C-04 | current-replicasは-1以上である必要がある | E-01 (185-187行目 Validate) | ○ |
| C-05 | resource-versionは複数リソース指定時に使用不可 | E-01 (214-216行目) | ○ |
| C-06 | リトライは1秒間隔、最大5分 | E-01 (224行目 NewRetryParams) | ○ |
| C-07 | timeout指定かつdry-run=none時のみ待機 | E-01 (227-229行目) | ○ |
| C-08 | dry-run=client時はオブジェクト出力のみ | E-01 (240-245行目) | ○ |
| C-09 | 変更記録のMerge Patchを適用 | E-01 (252-263行目) | ○ |
| C-10 | ScaleOptionsがコマンドの全状態を保持 | E-01 (67-93行目) | ○ |
| C-11 | Complete関数でnamespace、builder、scalerを初期化 | E-01 (140-178行目) | ○ |
| C-12 | scaler関数でScaleClientFnを使用 | E-01 (274-281行目) | ○ |
| C-13 | 画面No.10がkubectl scale | E-03 (28-30行目) | ○ |
| C-14 | Deploymentコントローラーとの連携 | E-03 (29行目) | ○ |
| C-15 | ReplicaSetコントローラーとの連携 | E-03 (30行目) | ○ |
| C-16 | 機能No.91はスケーリング（scale） | E-02 (92行目) | ○ |
| C-17 | Scale APIはサブリソースアクセス | E-01 (247行目 mapping.Resource) | ○ |
| C-18 | パフォーマンスはScale APIサブリソースアクセスのため軽量 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件に関する具体的な数値基準はソースコードからは導出できない
  - 候補：Kubernetesパフォーマンスベンチマーク / SLO定義 / クラスタスケールテスト結果

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体的にソースコードとの整合性が高い
- 0: 低リスク - 画面機能マッピングとの整合性も確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] ScaleOptions構造体のフィールドが最新のコードと一致しているか確認
- [ ] リトライパラメータ（1秒/5分）が運用上適切か確認
- [ ] 前提条件チェックのユースケースが網羅されているか確認
