---
generated_at: 2026-02-02 10:05:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：92-オートスケール設定（autoscale）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **HPA Controllerポーリング間隔のデフォルト値**：設定値の根拠がコード外

## 2) 参照した情報（Evidence一覧）

- E-01: `staging/src/k8s.io/kubectl/pkg/cmd/autoscale/autoscale.go` - autoscaleコマンド実装
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（No.92）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | autoscaleはHPAリソースを作成する | E-01（autoscale.go全体） | ○ |
| C-02 | --maxは必須パラメータ | E-01（Validate関数） | ○ |
| C-03 | 対応リソースはdeployment, replicaset, statefulset, replicationcontroller | E-01（validArgs定義） | ○ |
| C-04 | GeneratorFnを使用してHPAを生成 | E-01（Run関数内） | ○ |
| C-05 | Override機能を適用可能 | E-01（Run関数内 overrider.Apply） | ○ |
| C-06 | dry-run=client時はCreate呼び出しをスキップ | E-01（Run関数内） | ○ |
| C-07 | 名前デフォルトはターゲットリソース名 | E-01（パラメータ設定部分） | ○ |
| C-08 | RecordFlagsによる変更記録 | E-01（RecordFlags定義） | ○ |
| C-09 | namespace取得はkubeconfigから | E-01（Complete関数） | ○ |
| C-10 | 機能No.92はオートスケール設定 | E-02（93行目） | ○ |
| C-11 | cpu-percentのバリデーション | E-01（Validate関数） | ○ |
| C-12 | HPA Controllerのポーリング間隔はデフォルト15秒 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- HPA Controllerのポーリング間隔はkube-controller-managerの設定で、autoscaleコマンドのソースコードには含まれない
  - 候補：kube-controller-manager --horizontal-pod-autoscaler-sync-period / Kubernetes公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コマンド自体の機能はシンプルなリソース作成

## 6) レビュアーチェックリスト（最小）
- [ ] HPAのAPIバージョン（v2/v2beta2）が最新のコードと一致しているか確認
- [ ] --cpu-percent以外のカスタムメトリクス設定の制限が明記されているか確認
- [ ] GeneratorFnの生成パラメータが網羅されているか確認
