---
generated_at: 2026-02-02 10:10:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：93-ドレイン（drain）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **drain操作の冪等性に関する記述**：コードレベルでの挙動詳細確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `staging/src/k8s.io/kubectl/pkg/cmd/drain/drain.go` - drain CLIコマンド定義
- E-02: `staging/src/k8s.io/kubectl/pkg/drain/` - ドレインロジック共通実装（パッケージ全体）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（No.93）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | drainはノードをcordonしてからPodを退去させる | E-01（RunDrain関数） | ○ |
| C-02 | Eviction APIはPDBの制約を尊重する | E-02（EvictPod実装） | ○ |
| C-03 | DaemonSet管理Podはデフォルトで退去対象外 | E-02（フィルタロジック） | ○ |
| C-04 | emptyDir使用Podはデフォルトで退去不可 | E-02（フィルタロジック） | ○ |
| C-05 | Controller管理外Podはデフォルトで退去不可 | E-02（フィルタロジック） | ○ |
| C-06 | --forceで未管理Podの強制削除が可能 | E-01（フラグ定義）, E-02 | ○ |
| C-07 | --disable-evictionでEviction APIをバイパス | E-01（フラグ定義） | ○ |
| C-08 | cordon操作はMerge Patchで実行 | E-01（RunCordonOrUncordon） | ○ |
| C-09 | --grace-periodでPod終了猶予を指定 | E-01（フラグ定義） | ○ |
| C-10 | chunk-sizeはPod一覧のページネーションに使用 | E-01（フラグ定義） | ○ |
| C-11 | skip-wait-for-delete-timeoutでDeletionTimestamp設定済みPodをスキップ | E-01（フラグ定義） | ○ |
| C-12 | pod-selectorでPodのフィルタリングが可能 | E-01（フラグ定義） | ○ |
| C-13 | 機能No.93はドレイン（drain） | E-03（94行目） | ○ |
| C-14 | uncordonでノードを再びスケジューリング可能にする | E-01（NewCmdUncordon定義） | ○ |
| C-15 | drain操作は冪等ではない | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- drain操作の冪等性についてはコードの詳細挙動から導出する必要がある
  - 候補：Eviction APIのエラーハンドリング / Pod存在チェックの挙動

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - drainは本番環境に直接影響するため、ビジネスルールの正確性が重要

## 6) レビュアーチェックリスト（最小）
- [ ] PDBとの相互作用が正確に記述されているか確認
- [ ] フィルタリング条件（DaemonSet/Mirror/LocalStorage/Unmanaged）の網羅性確認
- [ ] --forceと--disable-evictionの組み合わせ時の挙動確認
