---
generated_at: 2026-02-02 10:15:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：94-Taint管理（taint）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `staging/src/k8s.io/kubectl/pkg/cmd/taint/taint.go` - taintコマンド実装
- E-02: `staging/src/k8s.io/kubectl/pkg/cmd/taint/utils.go` - Taintユーティリティ
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（No.94）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | parseTaintsでTaint仕様をパース | E-02（39-73行目） | ○ |
| C-02 | Taint追加時はeffect必須 | E-02（56-58行目） | ○ |
| C-03 | Taint形式はkey=value:effect / key:effect / key- | E-02（77-118行目） | ○ |
| C-04 | 有効なeffectはNoSchedule/PreferNoSchedule/NoExecute | E-02（120-126行目） | ○ |
| C-05 | 同一key:effectの重複Taintは不可 | E-02（60-67行目） | ○ |
| C-06 | reorganizeTaintsで新旧Taintをマージ | E-02（130-142行目） | ○ |
| C-07 | 結果はMODIFIED/TAINTED/UNTAINTEDの3状態 | E-02（32-35行目、136-141行目） | ○ |
| C-08 | addTaintsで既存Taintを保持 | E-02（163-177行目） | ○ |
| C-09 | deleteTaintsで指定Taintを削除 | E-02（145-159行目） | ○ |
| C-10 | deleteTaintsByKeyでkeyベースの全削除 | E-02（193-202行目） | ○ |
| C-11 | deleteTaintでkey:effectマッチの削除 | E-02（205-214行目） | ○ |
| C-12 | checkIfTaintsAlreadyExistsで重複検出 | E-02（180-190行目） | ○ |
| C-13 | Merge Patchでノードを更新 | E-01（RunTaint関数内） | ○ |
| C-14 | 機能No.94はTaint管理 | E-03（95行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードとの高い整合性

## 6) レビュアーチェックリスト（最小）
- [ ] Taintパース形式の全パターンが正確に記述されているか確認
- [ ] reorganizeTaintsのoverwriteフラグの挙動が正確か確認
- [ ] NoExecute Taintの即時影響に関する注意事項が適切か確認
