---
generated_at: 2026-02-02 10:30:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：97-Service公開（expose）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `staging/src/k8s.io/kubectl/pkg/cmd/expose/expose.go` - exposeコマンド実装（630行）
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（No.97）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 対応リソースはpod, service, replicationcontroller, deployment, replicaset | E-01（49-50行目 exposeResources） | ○ |
| C-02 | Service名はDNS1035LabelMaxLength(63文字)に制限 | E-01（321-323行目） | ○ |
| C-03 | セレクタ未指定時はターゲットリソースから自動抽出 | E-01（328-334行目） | ○ |
| C-04 | ポート未指定時はターゲットリソースから自動抽出 | E-01（340-355行目） | ○ |
| C-05 | headless時はポートなしでもOK | E-01（346-349行目） | ○ |
| C-06 | 複数ポート時はPorts変数に格納 | E-01（353行目） | ○ |
| C-07 | プロトコルデフォルトはTCP | E-01（490-492行目） | ○ |
| C-08 | マルチプロトコル対応でport-{n}-{protocol}形式 | E-01（504-512行目） | ○ |
| C-09 | マルチポート時はport-1, port-2...名を自動生成 | E-01（484-486行目） | ○ |
| C-10 | TargetPort未指定時はServicePortと同値 | E-01（543-546行目） | ○ |
| C-11 | cluster-ip=NoneでheadlessService | E-01（568-569行目） | ○ |
| C-12 | LoadBalancer型時にLoadBalancerIPを設定 | E-01（554-556行目） | ○ |
| C-13 | SessionAffinityの検証（None/ClientIP） | E-01（557-565行目） | ○ |
| C-14 | CanBeExposedでリソースタイプのexpose可否チェック | E-01（316-318行目） | ○ |
| C-15 | Override適用後にAPI Serverに作成 | E-01（381-425行目） | ○ |
| C-16 | 機能No.97はService公開 | E-02（98行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコード全文を確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] マルチプロトコル対応のポート名生成ロジックが正確か確認
- [ ] headless Serviceの挙動が正確に記述されているか確認
- [ ] Override機能の適用範囲が適切に説明されているか確認
