---
generated_at: 2026-02-02 00:00:00
metrics:
  claims_total: 54
  claims_with_evidence: 54
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：画面一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：54 / 54、根拠なし：0
- 優先レビュー（高）
  1. **該当なし**：全項目がソースコードに基づいて生成されています
  2. **注意点**：本プロジェクトはGUIを持たないCLIプロジェクトです。「画面」をCLIコマンドインターフェースとして解釈しています
  3. **注意点**：コマンドの説明文はソースコードのShort/Long descriptionを参考にしていますが、日本語に意訳しています

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `staging/src/k8s.io/kubectl/pkg/cmd/cmd.go` - kubectlメインコマンド定義（コマンドグループ構造）
- E-02: `staging/src/k8s.io/kubectl/pkg/cmd/create/create.go` - createコマンド定義
- E-03: `staging/src/k8s.io/kubectl/pkg/cmd/expose/expose.go` - exposeコマンド定義
- E-04: `staging/src/k8s.io/kubectl/pkg/cmd/run/run.go` - runコマンド定義
- E-05: `staging/src/k8s.io/kubectl/pkg/cmd/set/set.go` - setコマンド定義
- E-06: `staging/src/k8s.io/kubectl/pkg/cmd/explain/explain.go` - explainコマンド定義
- E-07: `staging/src/k8s.io/kubectl/pkg/cmd/get/get.go` - getコマンド定義
- E-08: `staging/src/k8s.io/kubectl/pkg/cmd/edit/edit.go` - editコマンド定義
- E-09: `staging/src/k8s.io/kubectl/pkg/cmd/delete/delete.go` - deleteコマンド定義
- E-10: `staging/src/k8s.io/kubectl/pkg/cmd/rollout/rollout.go` - rolloutコマンド定義
- E-11: `staging/src/k8s.io/kubectl/pkg/cmd/scale/scale.go` - scaleコマンド定義
- E-12: `staging/src/k8s.io/kubectl/pkg/cmd/autoscale/autoscale.go` - autoscaleコマンド定義
- E-13: `staging/src/k8s.io/kubectl/pkg/cmd/certificates/certificates.go` - certificateコマンド定義
- E-14: `staging/src/k8s.io/kubectl/pkg/cmd/clusterinfo/clusterinfo.go` - cluster-infoコマンド定義
- E-15: `staging/src/k8s.io/kubectl/pkg/cmd/top/top.go` - topコマンド定義
- E-16: `staging/src/k8s.io/kubectl/pkg/cmd/drain/drain.go` - cordon/uncordon/drainコマンド定義
- E-17: `staging/src/k8s.io/kubectl/pkg/cmd/taint/taint.go` - taintコマンド定義
- E-18: `staging/src/k8s.io/kubectl/pkg/cmd/describe/describe.go` - describeコマンド定義
- E-19: `staging/src/k8s.io/kubectl/pkg/cmd/logs/logs.go` - logsコマンド定義
- E-20: `staging/src/k8s.io/kubectl/pkg/cmd/attach/attach.go` - attachコマンド定義
- E-21: `staging/src/k8s.io/kubectl/pkg/cmd/exec/exec.go` - execコマンド定義
- E-22: `staging/src/k8s.io/kubectl/pkg/cmd/portforward/portforward.go` - port-forwardコマンド定義
- E-23: `staging/src/k8s.io/kubectl/pkg/cmd/proxy/proxy.go` - proxyコマンド定義
- E-24: `staging/src/k8s.io/kubectl/pkg/cmd/cp/cp.go` - cpコマンド定義
- E-25: `staging/src/k8s.io/kubectl/pkg/cmd/auth/auth.go` - authコマンド定義
- E-26: `staging/src/k8s.io/kubectl/pkg/cmd/debug/debug.go` - debugコマンド定義
- E-27: `staging/src/k8s.io/kubectl/pkg/cmd/events/events.go` - eventsコマンド定義
- E-28: `staging/src/k8s.io/kubectl/pkg/cmd/diff/diff.go` - diffコマンド定義
- E-29: `staging/src/k8s.io/kubectl/pkg/cmd/apply/apply.go` - applyコマンド定義
- E-30: `staging/src/k8s.io/kubectl/pkg/cmd/patch/patch.go` - patchコマンド定義
- E-31: `staging/src/k8s.io/kubectl/pkg/cmd/replace/replace.go` - replaceコマンド定義
- E-32: `staging/src/k8s.io/kubectl/pkg/cmd/wait/wait.go` - waitコマンド定義
- E-33: `staging/src/k8s.io/kubectl/pkg/cmd/kustomize/kustomize.go` - kustomizeコマンド定義
- E-34: `staging/src/k8s.io/kubectl/pkg/cmd/label/label.go` - labelコマンド定義
- E-35: `staging/src/k8s.io/kubectl/pkg/cmd/annotate/annotate.go` - annotateコマンド定義
- E-36: `staging/src/k8s.io/kubectl/pkg/cmd/completion/completion.go` - completionコマンド定義
- E-37: `staging/src/k8s.io/kubectl/pkg/cmd/config/config.go` - configコマンド定義
- E-38: `staging/src/k8s.io/kubectl/pkg/cmd/plugin/plugin.go` - pluginコマンド定義
- E-39: `staging/src/k8s.io/kubectl/pkg/cmd/version/version.go` - versionコマンド定義
- E-40: `staging/src/k8s.io/kubectl/pkg/cmd/apiresources/apiresources.go` - api-versions/api-resourcesコマンド定義
- E-41: `staging/src/k8s.io/kubectl/pkg/cmd/options/options.go` - optionsコマンド定義
- E-42: `staging/src/k8s.io/kubectl/pkg/cmd/kuberc/kuberc.go` - kubercコマンド定義
- E-43: `cmd/kubeadm/app/cmd/init.go` - kubeadm initコマンド定義
- E-44: `cmd/kubeadm/app/cmd/join.go` - kubeadm joinコマンド定義
- E-45: `cmd/kubeadm/app/cmd/reset.go` - kubeadm resetコマンド定義
- E-46: `cmd/kubeadm/app/cmd/token.go` - kubeadm tokenコマンド定義
- E-47: `cmd/kubeadm/app/cmd/config.go` - kubeadm configコマンド定義
- E-48: `cmd/kubeadm/app/cmd/certs.go` - kubeadm certsコマンド定義
- E-49: `cmd/kubeadm/app/cmd/kubeconfig.go` - kubeadm kubeconfigコマンド定義
- E-50: `cmd/kubeadm/app/cmd/upgrade/` - kubeadm upgradeコマンド定義
- E-51: `cmd/kubeadm/app/cmd/version.go` - kubeadm versionコマンド定義
- E-52: `cmd/kubeadm/app/cmd/completion.go` - kubeadm completionコマンド定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | kubectl createコマンドが存在し、リソース作成を行う | E-01, E-02 | ○ |
| C-02 | kubectl exposeコマンドが存在し、Service公開を行う | E-01, E-03 | ○ |
| C-03 | kubectl runコマンドが存在し、イメージ実行を行う | E-01, E-04 | ○ |
| C-04 | kubectl setコマンドが存在し、6つのサブコマンドを持つ | E-01, E-05 | ○ |
| C-05 | kubectl explainコマンドが存在し、リソースドキュメント表示を行う | E-01, E-06 | ○ |
| C-06 | kubectl getコマンドが存在し、リソース表示を行う | E-01, E-07 | ○ |
| C-07 | kubectl editコマンドが存在し、リソース編集を行う | E-01, E-08 | ○ |
| C-08 | kubectl deleteコマンドが存在し、リソース削除を行う | E-01, E-09 | ○ |
| C-09 | kubectl rolloutコマンドが存在し、6つのサブコマンドを持つ | E-01, E-10 | ○ |
| C-10 | kubectl scaleコマンドが存在し、レプリカ数変更を行う | E-01, E-11 | ○ |
| C-11 | kubectl autoscaleコマンドが存在し、オートスケーラー作成を行う | E-01, E-12 | ○ |
| C-12 | kubectl certificateコマンドが存在し、証明書管理を行う | E-01, E-13 | ○ |
| C-13 | kubectl cluster-infoコマンドが存在し、クラスタ情報表示を行う | E-01, E-14 | ○ |
| C-14 | kubectl topコマンドが存在し、node/podサブコマンドを持つ | E-01, E-15 | ○ |
| C-15 | kubectl cordonコマンドが存在し、ノードスケジュール不可設定を行う | E-01, E-16 | ○ |
| C-16 | kubectl uncordonコマンドが存在し、ノードスケジュール可能に戻す | E-01, E-16 | ○ |
| C-17 | kubectl drainコマンドが存在し、ノード排出を行う | E-01, E-16 | ○ |
| C-18 | kubectl taintコマンドが存在し、taint管理を行う | E-01, E-17 | ○ |
| C-19 | kubectl describeコマンドが存在し、リソース詳細表示を行う | E-01, E-18 | ○ |
| C-20 | kubectl logsコマンドが存在し、コンテナログ出力を行う | E-01, E-19 | ○ |
| C-21 | kubectl attachコマンドが存在し、コンテナアタッチを行う | E-01, E-20 | ○ |
| C-22 | kubectl execコマンドが存在し、コンテナ内コマンド実行を行う | E-01, E-21 | ○ |
| C-23 | kubectl port-forwardコマンドが存在し、ポート転送を行う | E-01, E-22 | ○ |
| C-24 | kubectl proxyコマンドが存在し、APIサーバプロキシを行う | E-01, E-23 | ○ |
| C-25 | kubectl cpコマンドが存在し、ファイルコピーを行う | E-01, E-24 | ○ |
| C-26 | kubectl authコマンドが存在し、3つのサブコマンドを持つ | E-01, E-25 | ○ |
| C-27 | kubectl debugコマンドが存在し、デバッグワークロード作成を行う | E-01, E-26 | ○ |
| C-28 | kubectl eventsコマンドが存在し、イベント一覧表示を行う | E-01, E-27 | ○ |
| C-29 | kubectl diffコマンドが存在し、変更差分表示を行う | E-01, E-28 | ○ |
| C-30 | kubectl applyコマンドが存在し、構成適用を行う | E-01, E-29 | ○ |
| C-31 | kubectl patchコマンドが存在し、フィールド更新を行う | E-01, E-30 | ○ |
| C-32 | kubectl replaceコマンドが存在し、リソース置換を行う | E-01, E-31 | ○ |
| C-33 | kubectl waitコマンドが存在し、条件待機を行う | E-01, E-32 | ○ |
| C-34 | kubectl kustomizeコマンドが存在し、Kustomizeビルドを行う | E-01, E-33 | ○ |
| C-35 | kubectl labelコマンドが存在し、ラベル更新を行う | E-01, E-34 | ○ |
| C-36 | kubectl annotateコマンドが存在し、アノテーション更新を行う | E-01, E-35 | ○ |
| C-37 | kubectl completionコマンドが存在し、シェル補完出力を行う | E-01, E-36 | ○ |
| C-38 | kubectl configコマンドが存在し、15のサブコマンドを持つ | E-01, E-37 | ○ |
| C-39 | kubectl pluginコマンドが存在し、プラグイン管理を行う | E-01, E-38 | ○ |
| C-40 | kubectl versionコマンドが存在し、バージョン情報出力を行う | E-01, E-39 | ○ |
| C-41 | kubectl api-versionsコマンドが存在し、APIバージョン一覧を行う | E-01, E-40 | ○ |
| C-42 | kubectl api-resourcesコマンドが存在し、APIリソース一覧を行う | E-01, E-40 | ○ |
| C-43 | kubectl optionsコマンドが存在し、共通フラグ一覧を行う | E-01, E-41 | ○ |
| C-44 | kubectl kubercコマンドが存在し、kuberc設定管理を行う | E-01, E-42 | ○ |
| C-45 | kubeadm initコマンドが存在し、コントロールプレーン初期化を行う | E-43 | ○ |
| C-46 | kubeadm joinコマンドが存在し、ノード参加を行う | E-44 | ○ |
| C-47 | kubeadm resetコマンドが存在し、変更取り消しを行う | E-45 | ○ |
| C-48 | kubeadm tokenコマンドが存在し、トークン管理を行う | E-46 | ○ |
| C-49 | kubeadm configコマンドが存在し、設定管理を行う | E-47 | ○ |
| C-50 | kubeadm certsコマンドが存在し、証明書管理を行う | E-48 | ○ |
| C-51 | kubeadm kubeconfigコマンドが存在し、kubeconfig管理を行う | E-49 | ○ |
| C-52 | kubeadm upgradeコマンドが存在し、クラスタアップグレードを行う | E-50 | ○ |
| C-53 | kubeadm versionコマンドが存在し、バージョン情報出力を行う | E-51 | ○ |
| C-54 | kubeadm completionコマンドが存在し、シェル補完出力を行う | E-52 | ○ |

## 4) 不足情報（Unknown / Missing）
- 本プロジェクトはGUIを持たないCLIプロジェクトのため、従来の「画面」は存在しません。CLIコマンドインターフェースを「画面」として解釈しています。
  - 候補：Kubernetes Dashboard（別リポジトリ） / Web UI（本リポジトリ外）
- kube-apiserver / kube-controller-manager / kube-scheduler / kubelet / kube-proxy等のサーバコンポーネントは、ユーザが直接操作するCLIインターフェースではないため画面一覧に含めていません。
  - 候補：各サーバコンポーネントの起動オプション一覧

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全コマンドがソースコードのcmd.go内のコマンド登録処理から直接確認できる
- 1: 中リスク - コマンドの日本語説明文はソースコード内のShort/Long descriptionの意訳であり、正確性にはレビューが必要
- 0: 低リスク - 画面遷移図のワークフロー部分は典型的な運用パターンに基づくが、全パターンを網羅しているわけではない

## 6) レビュアーチェックリスト（最小）
- [ ] 「画面」をCLIコマンドインターフェースとして解釈することが本プロジェクトにおいて適切か確認
- [ ] 各コマンドの日本語説明がソースコードの英語説明と整合しているか確認
- [ ] サブコマンド一覧が最新のソースコードと一致しているか確認
- [ ] kubeadm以外のCLIツール（kubelet等）を画面一覧に含める必要があるか確認
- [ ] 画面遷移図の典型的なワークフローが実際の運用パターンと整合しているか確認
