# 画面遷移図

本プロジェクト（Kubernetes）はGUIを持たないCLIベースのプロジェクトです。
以下では、主要CLIツール（kubectl / kubeadm）のコマンド階層をMermaid図で表現しています。

## kubectl コマンド階層

```mermaid
graph TD
    kubectl["kubectl"]

    subgraph beginner["Basic Commands (Beginner)"]
        create["kubectl create"]
        expose["kubectl expose"]
        run["kubectl run"]
        set["kubectl set"]
    end

    subgraph intermediate["Basic Commands (Intermediate)"]
        explain["kubectl explain"]
        get["kubectl get"]
        edit["kubectl edit"]
        delete["kubectl delete"]
    end

    subgraph deploy["Deploy Commands"]
        rollout["kubectl rollout"]
        scale["kubectl scale"]
        autoscale["kubectl autoscale"]
    end

    subgraph cluster["Cluster Management Commands"]
        certificate["kubectl certificate"]
        clusterinfo["kubectl cluster-info"]
        top["kubectl top"]
        cordon["kubectl cordon"]
        uncordon["kubectl uncordon"]
        drain["kubectl drain"]
        taint["kubectl taint"]
    end

    subgraph debug["Troubleshooting and Debugging"]
        describe["kubectl describe"]
        logs["kubectl logs"]
        attach["kubectl attach"]
        exec["kubectl exec"]
        portforward["kubectl port-forward"]
        proxy["kubectl proxy"]
        cp["kubectl cp"]
        auth["kubectl auth"]
        debugcmd["kubectl debug"]
        events["kubectl events"]
    end

    subgraph advanced["Advanced Commands"]
        diff["kubectl diff"]
        apply["kubectl apply"]
        patch["kubectl patch"]
        replace["kubectl replace"]
        wait["kubectl wait"]
        kustomize["kubectl kustomize"]
    end

    subgraph settings["Settings Commands"]
        label["kubectl label"]
        annotate["kubectl annotate"]
        completion["kubectl completion"]
    end

    subgraph other["Other Commands"]
        config["kubectl config"]
        plugin["kubectl plugin"]
        version["kubectl version"]
        apiversions["kubectl api-versions"]
        apiresources["kubectl api-resources"]
        options["kubectl options"]
        kuberc["kubectl kuberc"]
    end

    kubectl --> beginner
    kubectl --> intermediate
    kubectl --> deploy
    kubectl --> cluster
    kubectl --> debug
    kubectl --> advanced
    kubectl --> settings
    kubectl --> other
```

## kubectl create サブコマンド

```mermaid
graph TD
    create["kubectl create"]
    create --> create_clusterrole["create clusterrole"]
    create --> create_clusterrolebinding["create clusterrolebinding"]
    create --> create_configmap["create configmap"]
    create --> create_cronjob["create cronjob"]
    create --> create_deployment["create deployment"]
    create --> create_ingress["create ingress"]
    create --> create_job["create job"]
    create --> create_namespace["create namespace"]
    create --> create_pdb["create pdb"]
    create --> create_priorityclass["create priorityclass"]
    create --> create_quota["create quota"]
    create --> create_role["create role"]
    create --> create_rolebinding["create rolebinding"]
    create --> create_secret["create secret"]
    create --> create_service["create service"]
    create --> create_serviceaccount["create serviceaccount"]
    create --> create_token["create token"]
```

## kubectl rollout サブコマンド

```mermaid
graph TD
    rollout["kubectl rollout"]
    rollout --> rollout_history["rollout history"]
    rollout --> rollout_pause["rollout pause"]
    rollout --> rollout_restart["rollout restart"]
    rollout --> rollout_resume["rollout resume"]
    rollout --> rollout_status["rollout status"]
    rollout --> rollout_undo["rollout undo"]
```

## kubectl config サブコマンド

```mermaid
graph TD
    config["kubectl config"]
    config --> current_context["config current-context"]
    config --> delete_cluster["config delete-cluster"]
    config --> delete_context["config delete-context"]
    config --> delete_user["config delete-user"]
    config --> get_clusters["config get-clusters"]
    config --> get_contexts["config get-contexts"]
    config --> get_users["config get-users"]
    config --> rename_context["config rename-context"]
    config --> set_val["config set"]
    config --> set_cluster["config set-cluster"]
    config --> set_context["config set-context"]
    config --> set_credentials["config set-credentials"]
    config --> unset["config unset"]
    config --> use_context["config use-context"]
    config --> view["config view"]
```

## kubectl set サブコマンド

```mermaid
graph TD
    set["kubectl set"]
    set --> set_env["set env"]
    set --> set_image["set image"]
    set --> set_resources["set resources"]
    set --> set_selector["set selector"]
    set --> set_serviceaccount["set serviceaccount"]
    set --> set_subject["set subject"]
```

## kubectl auth サブコマンド

```mermaid
graph TD
    auth["kubectl auth"]
    auth --> auth_cani["auth can-i"]
    auth --> auth_reconcile["auth reconcile"]
    auth --> auth_whoami["auth whoami"]
```

## kubectl top サブコマンド

```mermaid
graph TD
    top["kubectl top"]
    top --> top_node["top node"]
    top --> top_pod["top pod"]
```

## kubeadm コマンド階層

```mermaid
graph TD
    kubeadm["kubeadm"]
    kubeadm --> init["kubeadm init"]
    kubeadm --> join["kubeadm join"]
    kubeadm --> reset["kubeadm reset"]
    kubeadm --> token["kubeadm token"]
    kubeadm --> kubeadm_config["kubeadm config"]
    kubeadm --> certs["kubeadm certs"]
    kubeadm --> kubeconfig["kubeadm kubeconfig"]
    kubeadm --> upgrade["kubeadm upgrade"]
    kubeadm --> kubeadm_version["kubeadm version"]
    kubeadm --> kubeadm_completion["kubeadm completion"]
```

## 典型的なワークフロー（運用フロー）

```mermaid
graph LR
    subgraph cluster_setup["クラスタセットアップ"]
        A["kubeadm init"] --> B["kubeadm join"]
    end

    subgraph deploy_flow["デプロイフロー"]
        C["kubectl create / apply"] --> D["kubectl get / describe"]
        D --> E["kubectl logs / events"]
        E -->|問題あり| F["kubectl edit / patch"]
        F --> D
        E -->|正常| G["kubectl scale / autoscale"]
    end

    subgraph update_flow["アップデートフロー"]
        H["kubectl apply / set image"] --> I["kubectl rollout status"]
        I -->|失敗| J["kubectl rollout undo"]
        J --> I
        I -->|成功| K["kubectl get"]
    end

    subgraph maintenance_flow["メンテナンスフロー"]
        L["kubectl cordon"] --> M["kubectl drain"]
        M --> N["メンテナンス作業"]
        N --> O["kubectl uncordon"]
    end

    cluster_setup --> deploy_flow
    deploy_flow --> update_flow
    deploy_flow --> maintenance_flow
```
