---
generated_at: 2026-02-02 12:00:00
metrics:
  claims_total: 95
  claims_with_evidence: 82
  claims_without_evidence: 13
confidence_derived: 0.86
---

# 根拠レポート：画面機能マッピング.csv

## 本レポートについて

### 目的
本レポートは、生成された画面機能マッピングCSVの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.86**
  - 根拠あり：82 / 95、根拠なし：13
- 優先レビュー（高）
  1. **kubeadm系コマンドの機能マッピング**：kubeadmの各サブコマンドと機能一覧の対応がやや抽象的で、コード上の直接的な依存関係の確認が困難
  2. **コントローラー連携の関連種別**：kubectlコマンドからサーバーサイドコントローラーへの間接的な連携について「API連携」とした分類の妥当性
  3. **kubectl completion / optionsの機能マッピング**：補助的なコマンドの機能割り当てが推定ベース

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（54画面）
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（160機能）
- E-03: `staging/src/k8s.io/kubectl/pkg/cmd/create/create.go` - create コマンド実装（import文・構造体定義）
- E-04: `staging/src/k8s.io/kubectl/pkg/cmd/get/get.go` - get コマンド実装（import文・構造体定義）
- E-05: `staging/src/k8s.io/kubectl/pkg/cmd/apply/apply.go` - apply コマンド実装（import文・delete連携）
- E-06: `staging/src/k8s.io/kubectl/pkg/cmd/rollout/rollout.go` - rollout コマンド実装（サブコマンド構成）
- E-07: `staging/src/k8s.io/kubectl/pkg/cmd/drain/drain.go` - drain/cordon/uncordon コマンド実装（共通パッケージ）
- E-08: `staging/src/k8s.io/kubectl/pkg/cmd/scale/scale.go` - scale コマンド実装（対象リソースタイプ定義）
- E-09: `staging/src/k8s.io/kubectl/pkg/cmd/top/top.go` - top コマンド実装（metricsapi import）
- E-10: `staging/src/k8s.io/kubectl/pkg/cmd/debug/debug.go` - debug コマンド実装（attach/exec/logs import）
- E-11: `staging/src/k8s.io/kubectl/pkg/cmd/expose/expose.go` - expose コマンドのファイルパス
- E-12: `staging/src/k8s.io/kubectl/pkg/cmd/exec/exec.go` - exec コマンドのファイルパス
- E-13: `staging/src/k8s.io/kubectl/pkg/cmd/logs/logs.go` - logs コマンドのファイルパス
- E-14: `staging/src/k8s.io/kubectl/pkg/cmd/cp/cp.go` - cp コマンドのファイルパス
- E-15: `staging/src/k8s.io/kubectl/pkg/cmd/auth/auth.go` - auth コマンドのファイルパス
- E-16: `staging/src/k8s.io/kubectl/pkg/cmd/config/config.go` - config コマンドのファイルパス
- E-17: `cmd/kubeadm/app/cmd/init.go` - kubeadm init コマンドのファイルパス
- E-18: `cmd/kubeadm/app/cmd/join.go` - kubeadm join コマンドのファイルパス
- E-19: `cmd/kubeadm/app/cmd/certs.go` - kubeadm certs コマンドのファイルパス
- E-20: `cmd/kubeadm/app/cmd/upgrade/` - kubeadm upgrade コマンドのディレクトリ

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | kubectl create -> リソース作成（create）が主機能 | E-01, E-02, E-03 | ○ |
| C-02 | kubectl create -> API Serverコアへの連携 | E-03 | ○ |
| C-03 | kubectl create -> アドミッション制御連携 | E-03 | ○ |
| C-04 | kubectl create -> Config管理が補助機能 | E-03 | ○ |
| C-05 | kubectl expose -> Service公開（expose）が主機能 | E-01, E-02, E-11 | ○ |
| C-06 | kubectl expose -> Service管理へのAPI連携 | E-11 | ○ |
| C-07 | kubectl run -> Pod実行（run）が主機能 | E-01, E-02 | ○ |
| C-08 | kubectl run -> Attach遷移先機能 | E-01 | ○ |
| C-09 | kubectl set -> 設定セット（set）が主機能 | E-01, E-02 | ○ |
| C-10 | kubectl explain -> explainが主機能、OpenAPI連携 | E-01, E-02 | ○ |
| C-11 | kubectl get -> リソース取得（get）が主機能 | E-01, E-02, E-04 | ○ |
| C-12 | kubectl edit -> リソース編集（edit）が主機能 | E-01, E-02 | ○ |
| C-13 | kubectl edit -> リソース取得（get）が補助機能 | E-01 | ○ |
| C-14 | kubectl delete -> リソース削除（delete）が主機能 | E-01, E-02 | ○ |
| C-15 | kubectl delete -> Garbage Collectorコントローラー連携 | E-02 | ○ |
| C-16 | kubectl rollout -> ロールアウト管理（rollout）が主機能 | E-01, E-02, E-06 | ○ |
| C-17 | kubectl rollout -> Deploymentコントローラー連携 | E-06 | ○ |
| C-18 | kubectl rollout -> ReplicaSetコントローラー連携 | E-06 | ○ |
| C-19 | kubectl scale -> スケーリング（scale）が主機能 | E-01, E-02, E-08 | ○ |
| C-20 | kubectl scale -> Deploymentコントローラー連携 | E-08 | ○ |
| C-21 | kubectl autoscale -> オートスケール設定が主機能 | E-01, E-02 | ○ |
| C-22 | kubectl autoscale -> HPAコントローラー連携 | E-02 | ○ |
| C-23 | kubectl autoscale -> メトリクスサーバー連携 | E-02 | ○ |
| C-24 | kubectl certificate -> 証明書管理が主機能 | E-01, E-02 | ○ |
| C-25 | kubectl certificate -> Certificate署名コントローラー連携 | E-02 | ○ |
| C-26 | kubectl cluster-info -> クラスター情報が主機能 | E-01, E-02 | ○ |
| C-27 | kubectl top -> トップ（top）が主機能 | E-01, E-02, E-09 | ○ |
| C-28 | kubectl top -> メトリクスサーバー連携 | E-09 | ○ |
| C-29 | kubectl cordon -> ドレイン（drain）が主機能 | E-01, E-02, E-07 | ○ |
| C-30 | kubectl cordon -> Node Lifecycleコントローラー連携 | E-02 | ○ |
| C-31 | kubectl uncordon -> ドレイン（drain）が主機能 | E-01, E-02, E-07 | ○ |
| C-32 | kubectl drain -> ドレイン（drain）が主機能 | E-01, E-02, E-07 | ○ |
| C-33 | kubectl drain -> Disruption Budgetコントローラー連携 | E-02 | ○ |
| C-34 | kubectl taint -> Taint管理（taint）が主機能 | E-01, E-02 | ○ |
| C-35 | kubectl taint -> Taint Evictionコントローラー連携 | E-02 | ○ |
| C-36 | kubectl describe -> リソース詳細表示が主機能 | E-01, E-02 | ○ |
| C-37 | kubectl describe -> イベント表示が補助機能 | E-01 | ○ |
| C-38 | kubectl logs -> ログ表示が主機能 | E-01, E-02, E-13 | ○ |
| C-39 | kubectl logs -> ログ管理連携 | E-02 | ○ |
| C-40 | kubectl logs -> Kubelet API Server連携 | E-02 | ○ |
| C-41 | kubectl attach -> Attachが主機能 | E-01, E-02 | ○ |
| C-42 | kubectl exec -> コンテナ実行が主機能 | E-01, E-02, E-12 | ○ |
| C-43 | kubectl port-forward -> ポートフォワードが主機能 | E-01, E-02 | ○ |
| C-44 | kubectl proxy -> Proxyが主機能 | E-01, E-02 | ○ |
| C-45 | kubectl cp -> ファイルコピーが主機能 | E-01, E-02, E-14 | ○ |
| C-46 | kubectl cp -> exec補助機能（tar転送） | E-14 | ○ |
| C-47 | kubectl auth -> 認証情報確認が主機能 | E-01, E-02, E-15 | ○ |
| C-48 | kubectl auth -> 認証/認可/RBAC連携 | E-02, E-15 | ○ |
| C-49 | kubectl debug -> デバッグが主機能 | E-01, E-02, E-10 | ○ |
| C-50 | kubectl debug -> Attach遷移先機能 | E-10 | ○ |
| C-51 | kubectl debug -> exec/logs補助機能 | E-10 | ○ |
| C-52 | kubectl events -> イベント表示が主機能 | E-01, E-02 | ○ |
| C-53 | kubectl diff -> リソース差分が主機能 | E-01, E-02 | ○ |
| C-54 | kubectl apply -> 宣言的適用が主機能 | E-01, E-02, E-05 | ○ |
| C-55 | kubectl apply -> リソース削除（delete）が補助機能 | E-05 | ○ |
| C-56 | kubectl apply -> アドミッション制御連携 | E-05 | ○ |
| C-57 | kubectl patch -> リソースパッチが主機能 | E-01, E-02 | ○ |
| C-58 | kubectl replace -> リソース置換が主機能 | E-01, E-02 | ○ |
| C-59 | kubectl wait -> Waitが主機能 | E-01, E-02 | ○ |
| C-60 | kubectl kustomize -> apply補助機能 | E-01, E-02 | ○ |
| C-61 | kubectl label -> ラベル管理が主機能 | E-01, E-02 | ○ |
| C-62 | kubectl annotate -> アノテーション管理が主機能 | E-01, E-02 | ○ |
| C-63 | kubectl completion -> Config管理が補助機能 | E-01 | △ |
| C-64 | kubectl config -> Config管理が主機能 | E-01, E-02, E-16 | ○ |
| C-65 | kubectl plugin -> プラグイン管理が主機能 | E-01, E-02 | ○ |
| C-66 | kubectl version -> API Serverコア連携 | E-01 | ○ |
| C-67 | kubectl api-versions -> API Resources表示が主機能 | E-01, E-02 | ○ |
| C-68 | kubectl api-resources -> API Resources表示が主機能 | E-01, E-02 | ○ |
| C-69 | kubectl options -> Config管理が補助機能 | E-01 | △ |
| C-70 | kubectl kuberc -> kuberc設定が主機能 | E-01, E-02 | ○ |
| C-71 | kubeadm init -> クラスター初期化が主機能 | E-01, E-02, E-17 | ○ |
| C-72 | kubeadm init -> 証明書管理が補助機能 | E-17 | ○ |
| C-73 | kubeadm init -> API Serverコア連携 | E-17 | ○ |
| C-74 | kubeadm join -> ノード参加が主機能 | E-01, E-02, E-18 | ○ |
| C-75 | kubeadm join -> 証明書管理が補助機能 | E-18 | ○ |
| C-76 | kubeadm reset -> init遷移先機能 | E-01 | △ |
| C-77 | kubeadm reset -> 証明書管理が補助機能 | E-01 | △ |
| C-78 | kubeadm token -> init補助機能 | E-01 | △ |
| C-79 | kubeadm token -> 認証連携 | E-02 | △ |
| C-80 | kubeadm config -> init補助機能 | E-01 | △ |
| C-81 | kubeadm certs -> 証明書管理が主機能 | E-01, E-02, E-19 | ○ |
| C-82 | kubeadm kubeconfig -> Config管理が主機能 | E-01, E-02 | ○ |
| C-83 | kubeadm kubeconfig -> 証明書管理が補助機能 | E-01 | △ |
| C-84 | kubeadm upgrade -> クラスターアップグレードが主機能 | E-01, E-02, E-20 | ○ |
| C-85 | kubeadm upgrade -> 証明書管理が補助機能 | E-20 | ○ |
| C-86 | kubeadm upgrade -> API Serverコア連携 | E-20 | △ |
| C-87 | kubeadm version -> init補助機能 | E-01 | △ |
| C-88 | kubeadm completion -> init補助機能 | E-01 | △ |
| C-89 | 全kubectlコマンドがAPI Serverコアを介してリソース操作を行う | E-03, E-04, E-05 | ○ |
| C-90 | drain/cordon/uncordonは同一パッケージ（drain.go）で実装 | E-07 | ○ |
| C-91 | debugコマンドがattach/exec/logsをimport | E-10 | ○ |
| C-92 | topコマンドがmetricsapi をimport | E-09 | ○ |
| C-93 | applyコマンドがdeleteパッケージをimport | E-05 | ○ |
| C-94 | cpコマンドがexec経由でtar転送を行う | E-14 | ○ |
| C-95 | scaleコマンドがdeployment/replicaset/statefulsetを対象とする | E-08 | ○ |

## 4) 不足情報（Unknown / Missing）
- kubeadmの一部サブコマンド（reset, token, config, version, completion）について、機能一覧に直接対応する独立機能がないため、最も近い機能（クラスター初期化）の補助機能として分類した。これらのコマンドの個別ソースファイルの詳細分析が不足している。
  - 候補：`cmd/kubeadm/app/cmd/reset.go` / `cmd/kubeadm/app/cmd/token.go` / `cmd/kubeadm/app/cmd/config.go`
- kubectl completionとkubectl optionsは機能一覧に直接対応する機能がなく、Config管理の補助機能として分類した。
  - 候補：`staging/src/k8s.io/kubectl/pkg/cmd/completion/completion.go` / `staging/src/k8s.io/kubectl/pkg/cmd/options/options.go`
- サーバーサイドコントローラーとの間接連携（kubectl操作後にコントローラーが動作する関係）については、コードの直接的なimport関係ではなく、Kubernetesアーキテクチャの設計知識に基づく推定が含まれる。

## 5) リスクフラグ（レビュー観点）
- 0: kubectlコマンドと直接対応するkubectl機能のマッピング（C-01〜C-68の主機能） - 画面一覧と機能一覧のファイルパスが一致しており低リスク
- 1: kubectlコマンドとサーバーサイドコントローラーの間接連携（C-15, C-17, C-18, C-20, C-22, C-25, C-30, C-33, C-35） - Kubernetesアーキテクチャ知識に基づく推定
- 2: kubeadmコマンドの機能割り当て（C-76〜C-80, C-83, C-86〜C-88） - 機能一覧にkubeadm個別機能の粒度が粗く、マッピングの妥当性要確認

## 6) レビュアーチェックリスト（最小）
- [ ] kubectlコマンド（画面No 1〜44）の主機能マッピングが、画面一覧と機能一覧のファイルパスの一致に基づいて正確か
- [ ] 関連種別（主機能/補助機能/遷移先機能/API連携）の分類が適切か
- [ ] kubeadm系コマンド（画面No 45〜54）の機能マッピングが妥当か、特にreset/token/config/version/completionの分類
- [ ] サーバーサイドコントローラーとの間接連携（API連携種別）が適切に記載されているか
- [ ] 画面一覧の全54画面がマッピングに網羅されているか
- [ ] 1つの画面に対して複数機能が関連する場合の粒度が適切か
