# 画面設計書 1-kubectl create

## 概要

本ドキュメントは、Kubernetes CLIツール `kubectl` の `create` コマンドに関する画面設計書である。`kubectl create` はマニフェストファイルまたは標準入力からKubernetesリソースを作成するためのコマンドであり、Kubernetesクラスタ上でのリソース管理における基本操作を担う。

### 本画面の処理概要

`kubectl create` コマンドは、ユーザーが指定したJSONまたはYAML形式のマニフェストファイルを読み込み、Kubernetes API Serverを介してリソースを作成する。また多数のサブコマンドを提供し、マニフェストファイルを使用せずにコマンドラインオプションのみでリソースを作成することも可能である。

**業務上の目的・背景**：Kubernetesクラスタ上でPod、Service、Deployment等のリソースを新規に作成するための基本コマンドである。宣言的管理（`kubectl apply`）に対して、命令的にリソースを作成する手段を提供する。初期セットアップやテスト環境の構築、緊急時のリソース作成など、即座にリソースを作成したい場合に使用される。

**画面へのアクセス方法**：ターミナルから `kubectl create -f <ファイルパス>` または `kubectl create <サブコマンド> <名前>` の形式で実行する。

**主要な操作・処理内容**：
1. マニフェストファイル（JSON/YAML）を指定してリソースを作成する（`kubectl create -f <file>`）
2. 標準入力からマニフェストを受け取りリソースを作成する（`cat file | kubectl create -f -`）
3. 作成前にエディタで内容を編集する（`kubectl create -f <file> --edit`）
4. Raw URIを指定して直接API ServerにPOSTする（`kubectl create --raw <URI> -f <file>`）
5. サブコマンドによる個別リソースの作成（namespace, configmap, secret, deployment, service, job, cronjob 等17種）
6. ドライランモードでの作成確認（`--dry-run=client` / `--dry-run=server`）

**画面遷移**：本コマンドはkubectlのBasic Commands (Beginner)カテゴリに属し、`kubectl` ルートコマンドから直接呼び出される。作成後のリソースは `kubectl get`、`kubectl describe`、`kubectl edit` 等で確認・操作可能。`--edit` オプションを指定した場合、内部的にエディタ機能（`kubectl edit` と同等）が呼び出される。

**権限による表示制御**：リソースの作成にはRBACによる適切な権限（対象リソースに対するcreate権限）が必要。権限不足の場合はAPI Serverからforbiddenエラーが返却される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 81 | リソース作成（create） | 主機能 | マニフェストファイルまたはstdinからKubernetesリソースを作成する主処理 |
| 1 | API Serverコア | API連携 | リソース作成リクエストをAPI Serverに送信しRESTエンドポイントを介して永続化する |
| 4 | アドミッション制御 | API連携 | リソース作成時にMutating/Validating Admission Webhookによる検証・変換が実行される |
| 117 | Config管理 | 補助機能 | kubeconfigに基づくクラスター接続情報の取得とコンテキスト管理 |

## 画面種別

CLIコマンド（リソース作成）

## URL/ルーティング

```
kubectl create -f FILENAME
kubectl create <subcommand> <name> [options]
```

サブコマンド: `namespace`, `quota`, `secret`, `configmap`, `serviceaccount`, `service`, `deployment`, `clusterrole`, `clusterrolebinding`, `role`, `rolebinding`, `poddisruptionbudget`, `priorityclass`, `job`, `cronjob`, `ingress`, `token`

## 入出力項目

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| -f, --filename | string[] | Yes（--rawまたはサブコマンド時は不要） | リソース定義ファイルのパス（JSON/YAML） |
| -k, --kustomize | string | No | Kustomizeディレクトリのパス |
| --edit | bool | No | 作成前にエディタで編集する（デフォルト: false） |
| --raw | string | No | API ServerへのRaw URI |
| -l, --selector | string | No | ラベルセレクタ |
| --dry-run | string | No | ドライランモード（none/client/server） |
| --field-manager | string | No | フィールドマネージャ名（デフォルト: kubectl-create） |
| --validate | string | No | バリデーション方式（strict/warn/ignore） |
| -o, --output | string | No | 出力フォーマット（json/yaml/name等） |
| -R, --recursive | bool | No | ディレクトリを再帰的に処理 |
| --save-config | bool | No | 現在の設定をアノテーションに保存 |
| --windows-line-endings | bool | No | Windows改行コードを使用（--edit時のみ有効） |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| リソース作成結果 | 作成されたリソースのタイプと名前（例: `pod/nginx created`） |
| ドライラン結果 | `--dry-run` 時はリソース定義のYAML/JSON出力 |
| エラーメッセージ | バリデーションエラー、権限エラー等のメッセージ |

## イベント仕様

### 1-コマンド実行（通常モード）

1. ユーザーが `kubectl create -f <file>` を実行
2. `CreateOptions.Complete()` でフラグの解析とオプションの完了処理（行番号190-222）
3. `CreateOptions.Validate()` でバリデーション（行番号157-187）
4. `CreateOptions.RunCreate()` で以下を実行（行番号225-301）:
   a. `f.Validator()` でスキーマバリデータを取得
   b. `f.ToRawKubeConfigLoader().Namespace()` で名前空間を取得
   c. `resource.Builder` でファイルからリソース情報を構築
   d. `resource.NewHelper().Create()` でAPI Serverにリソースを作成
   e. 作成結果を出力

### 2-コマンド実行（--editモード）

1. ユーザーが `kubectl create -f <file> --edit` を実行
2. `RunEditOnCreate()` 関数でエディタモードを起動（行番号304-324）
3. `editor.NewEditOptions(editor.EditBeforeCreateMode)` でエディタオプションを初期化
4. エディタでユーザーが内容を編集
5. 編集後の内容でリソースを作成

### 3-コマンド実行（--rawモード）

1. ユーザーが `kubectl create --raw <URI> -f <file>` を実行
2. `rawhttp.RawPost()` で直接API ServerにPOSTリクエストを送信（行番号228-234）

### 4-サブコマンド実行

1. ユーザーが `kubectl create <subcommand> <name>` を実行
2. 各サブコマンドの `Complete()` → `Validate()` → `Run()` が実行
3. `CreateSubcommandOptions.Run()` でジェネレータによりオブジェクトを生成（行番号420-470）
4. `DynamicClient.Resource().Create()` でAPI Serverにリソースを作成

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| リソース作成 | etcd（Kubernetes APIリソース） | INSERT | 指定されたリソースオブジェクトをetcdに永続化する |

### テーブル別更新項目詳細

#### etcd（Kubernetes APIリソース）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | リソースメタデータ（metadata） | name, namespace, labels, annotations等 | ユーザー指定値またはデフォルト値 |
| INSERT | リソース仕様（spec） | リソースタイプに応じた仕様 | マニフェストで定義された内容 |
| INSERT | リソース状態（status） | 初期状態 | API Serverによる自動設定 |

## メッセージ仕様

| 種別 | メッセージ | 条件 |
|------|-----------|------|
| 成功 | `<resource-type>/<name> created` | リソースが正常に作成された場合 |
| 成功（ドライラン） | `<resource-type>/<name> created (dry run)` / `(server dry run)` | ドライランモード時 |
| エラー | `error: error validating "<file>": ...` | マニフェストのバリデーションエラー |
| エラー | `error: no objects passed to create` | 作成対象のオブジェクトが存在しない場合 |
| エラー | `--raw and --edit are mutually exclusive` | --rawと--editを同時指定した場合 |
| エラー | `--raw can only use a single local file or stdin` | --raw使用時に複数ファイルを指定した場合 |
| エラー | `--raw cannot read from a url` | --raw使用時にURLを指定した場合 |
| エラー | `--raw and --recursive are mutually exclusive` | --rawと--recursiveを同時指定した場合 |
| エラー | `--raw and --selector (-l) are mutually exclusive` | --rawと--selectorを同時指定した場合 |
| エラー | `--raw and --output are mutually exclusive` | --rawと--outputを同時指定した場合 |
| エラー | `Unexpected args: <args>` | 不正な引数が渡された場合 |

## 例外処理

| 例外条件 | 動作 |
|----------|------|
| ファイルが存在しない | ファイル読み込みエラーを表示して終了 |
| YAML/JSONパースエラー | パースエラーの詳細を表示して終了 |
| API Server接続不可 | 接続エラーを表示して終了 |
| 権限不足（RBAC） | `Error from server (Forbidden)` メッセージを表示して終了 |
| リソース名の重複 | `Error from server (AlreadyExists)` メッセージを表示して終了 |
| バリデーションエラー | `error validating` メッセージとともに詳細を表示して終了 |
| Admission Webhook拒否 | Webhookのエラーメッセージを表示して終了 |

## 備考

- `kubectl create` は命令的なリソース作成コマンドであり、既存リソースの更新は行わない。既存リソースがある場合は AlreadyExists エラーとなる。宣言的管理には `kubectl apply` を使用する。
- `--dry-run=server` は API Server 側でバリデーションを実行するため、Admission Webhook のチェックも含まれる。
- サブコマンドは17種あり、それぞれ独立したファイルに実装されている（例: `create_deployment.go`, `create_configmap.go` 等）。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、コマンドオプションを保持するデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | create.go | `staging/src/k8s.io/kubectl/pkg/cmd/create/create.go` | `CreateOptions` 構造体（行51-70）でコマンドの全オプションを定義。`FilenameOptions`, `DryRunStrategy`, `EditBeforeCreate` 等のフィールドを確認 |
| 1-2 | create.go | `staging/src/k8s.io/kubectl/pkg/cmd/create/create.go` | `CreateSubcommandOptions` 構造体（行340-361）でサブコマンド共通のオプションを定義 |

**読解のコツ**: Go言語のcobra/pflagsパターンに従い、Options構造体 → NewCmdXxx() → Complete() → Validate() → Run() の順で処理が流れる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | create.go | `staging/src/k8s.io/kubectl/pkg/cmd/create/create.go` | `NewCmdCreate()` 関数（行102-154）がエントリーポイント。cobraコマンドの構築、フラグの登録、サブコマンドの追加を行う |

**主要処理フロー**:
1. **行102-103**: `NewCreateOptions()` でオプション初期化
2. **行105-116**: cobra.Command の定義。Run関数内で Complete → Validate → RunCreate の順で呼び出す
3. **行118-133**: フラグの登録（RecordFlags, FilenameOptions, Validate, edit, dry-run, selector, raw, field-manager, PrintFlags）
4. **行136-153**: 17個のサブコマンド（namespace, quota, secret, configmap等）を追加

#### Step 3: バリデーション処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | create.go | `staging/src/k8s.io/kubectl/pkg/cmd/create/create.go` | `Validate()` メソッド（行157-187）でフラグの整合性を確認。特に `--raw` フラグの排他制約の検証 |

#### Step 4: メイン処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | create.go | `staging/src/k8s.io/kubectl/pkg/cmd/create/create.go` | `RunCreate()` メソッド（行225-301）が主処理。rawモード、editモード、通常モードの3パスを持つ |
| 4-2 | create.go | `staging/src/k8s.io/kubectl/pkg/cmd/create/create.go` | `RunEditOnCreate()` 関数（行304-324）でeditモード時の処理 |
| 4-3 | create.go | `staging/src/k8s.io/kubectl/pkg/cmd/create/create.go` | `CreateSubcommandOptions.Run()` メソッド（行420-470）でサブコマンド共通の実行処理 |

**主要処理フロー**:
- **行228-234**: rawモード時は `rawhttp.RawPost()` で直接POSTリクエスト
- **行236-238**: editモード時は `RunEditOnCreate()` でエディタ起動
- **行240-301**: 通常モードでは resource.Builder でリソースを構築し、`resource.NewHelper().Create()` でAPI Serverに送信

### プログラム呼び出し階層図

```
NewCmdCreate()
    |
    +-- CreateOptions.Complete()
    |       +-- RecordFlags.Complete()
    |       +-- GetDryRunStrategy()
    |       +-- GetValidationDirective()
    |       +-- PrintFlags.ToPrinter()
    |
    +-- CreateOptions.Validate()
    |       +-- FilenameOptions.RequireFilenameOrKustomize()
    |
    +-- CreateOptions.RunCreate()
            |
            +-- [rawモード] rawhttp.RawPost()
            |
            +-- [editモード] RunEditOnCreate()
            |       +-- editor.NewEditOptions()
            |       +-- editOptions.Complete()
            |       +-- editOptions.Run()
            |
            +-- [通常モード]
                    +-- f.Validator()
                    +-- f.ToRawKubeConfigLoader().Namespace()
                    +-- f.NewBuilder().Unstructured().Schema()...Do()
                    +-- r.Visit()
                            +-- util.CreateOrUpdateAnnotation()
                            +-- Recorder.Record()
                            +-- resource.NewHelper().Create()
                            +-- PrintObj()
```

### データフロー図

```
[入力]                          [処理]                              [出力]

マニフェストファイル  ───▶  resource.Builder          ───▶  resource.Info
(JSON/YAML)                    |
                               v
                         Validator                    ───▶  バリデーション結果
                               |
                               v
                         resource.NewHelper().Create() ───▶  API Server (etcd)
                               |
                               v
                         PrintObj()                   ───▶  stdout (作成結果)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| create.go | `staging/src/k8s.io/kubectl/pkg/cmd/create/create.go` | ソース | createコマンドの主処理 |
| create_deployment.go | `staging/src/k8s.io/kubectl/pkg/cmd/create/create_deployment.go` | ソース | create deploymentサブコマンド |
| create_configmap.go | `staging/src/k8s.io/kubectl/pkg/cmd/create/create_configmap.go` | ソース | create configmapサブコマンド |
| create_secret.go | `staging/src/k8s.io/kubectl/pkg/cmd/create/create_secret.go` | ソース | create secretサブコマンド |
| create_namespace.go | `staging/src/k8s.io/kubectl/pkg/cmd/create/create_namespace.go` | ソース | create namespaceサブコマンド |
| create_service.go | `staging/src/k8s.io/kubectl/pkg/cmd/create/create_service.go` | ソース | create serviceサブコマンド |
| create_job.go | `staging/src/k8s.io/kubectl/pkg/cmd/create/create_job.go` | ソース | create jobサブコマンド |
| create_cronjob.go | `staging/src/k8s.io/kubectl/pkg/cmd/create/create_cronjob.go` | ソース | create cronjobサブコマンド |
| create_ingress.go | `staging/src/k8s.io/kubectl/pkg/cmd/create/create_ingress.go` | ソース | create ingressサブコマンド |
| create_token.go | `staging/src/k8s.io/kubectl/pkg/cmd/create/create_token.go` | ソース | create tokenサブコマンド |
| create_role.go | `staging/src/k8s.io/kubectl/pkg/cmd/create/create_role.go` | ソース | create roleサブコマンド |
| create_rolebinding.go | `staging/src/k8s.io/kubectl/pkg/cmd/create/create_rolebinding.go` | ソース | create rolebindingサブコマンド |
| create_clusterrole.go | `staging/src/k8s.io/kubectl/pkg/cmd/create/create_clusterrole.go` | ソース | create clusterroleサブコマンド |
| create_clusterrolebinding.go | `staging/src/k8s.io/kubectl/pkg/cmd/create/create_clusterrolebinding.go` | ソース | create clusterrolebindingサブコマンド |
| create_serviceaccount.go | `staging/src/k8s.io/kubectl/pkg/cmd/create/create_serviceaccount.go` | ソース | create serviceaccountサブコマンド |
| create_quota.go | `staging/src/k8s.io/kubectl/pkg/cmd/create/create_quota.go` | ソース | create quotaサブコマンド |
| create_pdb.go | `staging/src/k8s.io/kubectl/pkg/cmd/create/create_pdb.go` | ソース | create poddisruptionbudgetサブコマンド |
| create_priorityclass.go | `staging/src/k8s.io/kubectl/pkg/cmd/create/create_priorityclass.go` | ソース | create priorityclassサブコマンド |
| rawhttp.go | `staging/src/k8s.io/kubectl/pkg/rawhttp/rawhttp.go` | ソース | Raw HTTPリクエスト処理 |
| editor.go | `staging/src/k8s.io/kubectl/pkg/cmd/util/editor/editoptions.go` | ソース | エディタ機能 |
