# 画面設計書 10-kubectl scale

## 概要

本ドキュメントは、Kubernetes CLIツール `kubectl` の `scale` コマンドに関する画面設計書である。`kubectl scale` はDeployment、ReplicaSet、ReplicationController、StatefulSetのレプリカ数を変更するコマンドである。

### 本画面の処理概要

`kubectl scale` コマンドは、指定されたワークロードリソースのレプリカ数を変更し、Kubernetesコントローラーが目標のPod数に合わせてスケーリングを実行するようにする。

**業務上の目的・背景**：アプリケーションのワークロードに応じてPodの数を手動で調整するために使用する。トラフィック増加時のスケールアウト、コスト削減のためのスケールイン、メンテナンス時のレプリカ数0への縮小等、運用上のスケーリングニーズに対応する。前提条件（現在のレプリカ数、リソースバージョン）を指定して安全なスケーリングが可能。

**画面へのアクセス方法**：ターミナルから `kubectl scale --replicas=<count> <resource-type>/<name>` の形式で実行する。

**主要な操作・処理内容**：
1. レプリカ数の変更（`kubectl scale --replicas=3 deployment/nginx`）
2. 前提条件付きスケーリング（`--current-replicas=2 --replicas=3`）
3. リソースバージョンによる前提条件（`--resource-version`）
4. 複数リソースの同時スケーリング（`kubectl scale --replicas=5 rc/foo rc/bar`）
5. ファイル指定によるスケーリング（`kubectl scale --replicas=3 -f foo.yaml`）
6. タイムアウト付き待機（`--timeout`）
7. ラベルセレクタによる対象絞り込み（`-l`）

**画面遷移**：本コマンドはDeploy Commandsカテゴリに属する。`kubectl get` でリソースの現在のレプリカ数を確認し、必要に応じて `kubectl scale` でスケーリングする。自動スケーリングが必要な場合は `kubectl autoscale` を使用する。

**権限による表示制御**：対象リソースに対するupdate権限と、Scale サブリソースへのアクセス権限が必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 91 | スケーリング（scale） | 主機能 | Deployment、ReplicaSet等のレプリカ数を変更する主処理 |
| 7 | Deploymentコントローラー | API連携 | スケーリング結果としてDeploymentコントローラーがレプリカ数を調整する |
| 8 | ReplicaSetコントローラー | API連携 | ReplicaSetコントローラーが目標レプリカ数に合わせてPodを作成/削除する |

## 画面種別

CLIコマンド（リソース更新・スケーリング）

## URL/ルーティング

```
kubectl scale [--resource-version=version] [--current-replicas=count] --replicas=COUNT (-f FILENAME | TYPE NAME)
```

## 入出力項目

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| TYPE NAME / -f FILENAME | string | Yes | スケーリング対象のリソース |
| --replicas | int | Yes | 目標レプリカ数（0以上） |
| --current-replicas | int | No | 現在のレプリカ数の前提条件（-1でチェックなし、デフォルト: -1） |
| --resource-version | string | No | リソースバージョンの前提条件 |
| --timeout | duration | No | レプリカ数到達の待機タイムアウト（0で待機なし、デフォルト: 0） |
| --all | bool | No | 指定タイプの全リソースを対象 |
| -l, --selector | string | No | ラベルセレクタ |
| --dry-run | string | No | ドライランモード |
| -o, --output | string | No | 出力フォーマット |
| -f, --filename | string[] | No | リソース定義ファイル |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| スケーリング結果 | `<resource-type>/<name> scaled` の形式 |
| ドライラン結果 | ドライラン時のリソース出力 |

## イベント仕様

### 1-コマンド実行

1. ユーザーが `kubectl scale --replicas=3 deployment/nginx` を実行
2. `ScaleOptions.Complete()` でオプション完了（行140-178）:
   a. DryRunStrategy取得
   b. プリンター構築
   c. 名前空間取得
   d. resource.Builder構築
   e. Scalerの初期化（行170-173）
3. `ScaleOptions.Validate()` でバリデーション（行180-190）:
   a. `--replicas` >= 0 の確認
   b. `--current-replicas` >= -1 の確認
4. `ScaleOptions.RunScale()` で以下を実行（行193-272）:
   a. resource.Builderで対象リソースを取得（行194-202）
   b. `--resource-version` 使用時に複数リソースは不可（行214-216）
   c. 前提条件（ScalePrecondition）の構築（行220-223）
   d. リトライパラメータの設定（1秒間隔、最大5分）（行224）
   e. 各リソースに対して `scaler.Scale()` を実行（行247）
   f. レコーダーによるパッチ記録（行252-263）
   g. 結果を出力

### 2-前提条件付きスケーリング

1. `--current-replicas` または `--resource-version` が指定された場合
2. `ScalePrecondition` 構造体を構築（行220-223）
3. スケーリング前にAPI Serverから現在の状態を取得
4. 前提条件と一致しない場合はエラーを返す
5. 一致する場合のみスケーリングを実行

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| レプリカ数変更 | etcd（Scale サブリソース） | UPDATE | spec.replicasフィールドの更新 |
| レコーダーパッチ | etcd（対象リソース） | UPDATE（PATCH） | 変更記録のアノテーション更新 |

### テーブル別更新項目詳細

#### etcd（Scaleサブリソース）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | spec.replicas | --replicasで指定した値 | ScalePrecondition通過後に更新 |

## メッセージ仕様

| 種別 | メッセージ | 条件 |
|------|-----------|------|
| 成功 | `<resource-type>/<name> scaled` | スケーリング成功 |
| エラー | `The --replicas=COUNT flag is required, and COUNT must be greater than or equal to 0` | --replicasが負の値 |
| エラー | `The --current-replicas must specify an integer of -1 or greater` | --current-replicasが-1未満 |
| エラー | `cannot use --resource-version with multiple resources` | --resource-versionで複数リソース |
| エラー | `no objects passed to scale` | スケーリング対象が見つからない |

## 例外処理

| 例外条件 | 動作 |
|----------|------|
| 前提条件不一致 | エラーメッセージを表示（現在のレプリカ数が期待値と異なる） |
| リソースが存在しない | NotFoundエラーを表示 |
| 権限不足 | Forbiddenエラーを表示 |
| スケーリングタイムアウト | タイムアウトエラーを表示 |
| API Server接続不可 | 接続エラーを表示 |

## 備考

- スケーリングはScale サブリソースを通じて行われる。これはDeployment、ReplicaSet、StatefulSet、ReplicationControllerで共通のインターフェース。
- `--timeout` はドライラン時以外に有効で、レプリカ数が目標に到達するまで待機する。
- リトライパラメータは1秒間隔、最大5分で、前提条件の競合時にリトライを行う。
- `--current-replicas=-1` （デフォルト）は前提条件チェックなし（ブラインドアップデート）を意味する。
- 対象リソース: deployment, replicaset, replicationcontroller, statefulset

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | scale.go | `staging/src/k8s.io/kubectl/pkg/cmd/scale/scale.go` | `ScaleOptions` 構造体（行67-93）: Replicas, CurrentReplicas, ResourceVersion, Timeout, scaler等 |

**読解のコツ**: `scaler` フィールド（行87）は `scale.Scaler` インターフェースで、Scale サブリソースAPIを通じてスケーリングを行う。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | scale.go | `staging/src/k8s.io/kubectl/pkg/cmd/scale/scale.go` | `NewCmdScale()` 関数（行106-138）: --replicas必須フラグ（行132）、validArgsに4つのリソースタイプ（行109） |

**主要処理フロー**:
1. **行107**: NewScaleOptions初期化（CurrentReplicas=-1がデフォルト）
2. **行109**: validArgs: deployment, replicaset, replicationcontroller, statefulset
3. **行118-122**: Run関数: Complete → Validate → RunScale
4. **行132**: `--replicas` を必須フラグとしてマーク

#### Step 3: メイン処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | scale.go | `staging/src/k8s.io/kubectl/pkg/cmd/scale/scale.go` | `RunScale()` メソッド（行193-272）: resource.Builder → Scale → Recorder → PrintObj |
| 3-2 | scale.go | `staging/src/k8s.io/kubectl/pkg/cmd/scale/scale.go` | `scaler()` 関数（行274-281）: ScaleClientの取得とScaler初期化 |

**主要処理フロー**:
- **行220-223**: ScalePrecondition構築（CurrentReplicasまたはResourceVersion指定時のみ）
- **行224**: RetryParams: 1秒間隔、最大5分
- **行227-229**: Timeout指定時のwaitForReplicasパラメータ構築
- **行247**: `scaler.Scale()` でScale サブリソースを更新
- **行252-263**: Recorder.MakeRecordMergePatch() でパッチ記録

### プログラム呼び出し階層図

```
NewCmdScale()
    |
    +-- ScaleOptions.Complete()
    |       +-- f.NewBuilder()
    |       +-- f.KubernetesClientSet()
    |       +-- scaler() → scale.NewScaler()
    |
    +-- ScaleOptions.Validate()
    |
    +-- ScaleOptions.RunScale()
            +-- resource.Builder.Do()
            +-- r.Infos()
            +-- [前提条件] ScalePrecondition構築
            +-- scaler.Scale()
            |       +-- Scale サブリソース API 呼び出し
            +-- Recorder.MakeRecordMergePatch()
            +-- resource.NewHelper().Patch()
            +-- PrintObj()
```

### データフロー図

```
[入力]                          [処理]                              [出力]

--replicas=N           ───▶  resource.Builder       ───▶  resource.Info[]
--current-replicas            |
--resource-version            v
                         ScalePrecondition検証
                               |
                               v
                         scaler.Scale()            ───▶  Scale API (etcd更新)
                               |
                               v
                         [--timeout] 待機           ───▶  レプリカ数到達確認
                               |
                               v
                         PrintObj()                ───▶  stdout (結果)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| scale.go | `staging/src/k8s.io/kubectl/pkg/cmd/scale/scale.go` | ソース | scaleコマンドの主処理 |
| scale/ | `staging/src/k8s.io/kubectl/pkg/scale/` | ソース | Scaler実装、ScalePrecondition、RetryParams |
| resource.Builder | `staging/src/k8s.io/cli-runtime/pkg/resource/builder.go` | ソース | リソース取得 |
| resource.Helper | `staging/src/k8s.io/cli-runtime/pkg/resource/helper.go` | ソース | API Server通信（Patch） |
