# 画面設計書 11-kubectl autoscale

## 概要

本ドキュメントは、Kubernetes CLIツール `kubectl autoscale` コマンドの画面設計書である。Deployment、ReplicaSet、StatefulSet、ReplicationControllerに対してHorizontalPodAutoscaler（HPA）リソースを作成し、Pod数の自動スケーリングを設定するコマンドの仕様を記載する。

### 本画面の処理概要

`kubectl autoscale` コマンドは、指定されたワークロードリソースに対してHorizontalPodAutoscaler（HPA）を作成し、CPU使用率やメモリ使用量に基づいてPod数を自動的に増減させるオートスケーリング機能を設定する。

**業務上の目的・背景**：クラスタ上で動作するアプリケーションの負荷は時間帯やトラフィック量によって変動する。手動でレプリカ数を調整するのは非効率であり、HPAを利用することで負荷に応じたPod数の自動調整が可能となる。本コマンドはHPAリソースの作成を簡便化し、オートスケーリングの迅速な設定を実現する。

**画面へのアクセス方法**：ターミナル上で `kubectl autoscale` コマンドを実行する。対象リソースの種別と名前、および最大レプリカ数（`--max`）を必須パラメータとして指定する。

**主要な操作・処理内容**：
1. 対象リソース（Deployment/ReplicaSet/StatefulSet/ReplicationController）の指定とバリデーション
2. HPA作成オプション（min/max/cpu/memory）の解析と検証
3. autoscaling/v2 APIを優先してHPAリソースを作成（失敗時はv1にフォールバック）
4. 作成結果の標準出力への表示

**画面遷移**：本コマンドは単独実行のCLIコマンドであり、他の画面への遷移はない。デプロイフローにおいて `kubectl scale` の延長として使用されることが多い。

**権限による表示制御**：HPAリソースの作成にはautoscaling APIグループに対するcreate権限が必要。対象リソースのget権限も必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 92 | オートスケール設定（autoscale） | 主機能 | HPAリソースを作成してオートスケーリングを設定する主処理 |
| 23 | HPAコントローラー | API連携 | 作成されたHPAリソースに基づきHPAコントローラーがPodのレプリカ数を自動調整する |
| 151 | メトリクスサーバー連携 | API連携 | HPAがスケーリング判断のためにMetrics APIからリソースメトリクスを取得する |

## 画面種別

CLI コマンド（リソース登録）

## URL/ルーティング

```
kubectl autoscale (-f FILENAME | TYPE NAME | TYPE/NAME) [--min=MINPODS] --max=MAXPODS [--cpu=CPU] [--memory=MEMORY]
```

## 入出力項目

### 入力項目（コマンドライン引数・フラグ）

| 項目名 | フラグ | 型 | 必須 | デフォルト | 説明 |
|--------|--------|------|------|-----------|------|
| リソース種別 | 位置引数 | string | Yes | - | deployment / replicaset / statefulset / replicationcontroller |
| リソース名 | 位置引数 | string | Yes | - | オートスケール対象のリソース名 |
| 最大レプリカ数 | --max | int32 | Yes | -1 | Pod数の上限（1以上必須） |
| 最小レプリカ数 | --min | int32 | No | -1 | Pod数の下限。未指定時はサーバーデフォルト値が適用 |
| CPU使用率（旧） | --cpu-percent | int32 | No | -1 | 目標CPU使用率（%）。非推奨、--cpuを使用すること |
| CPU使用量/率 | --cpu | string | No | "" | 目標CPU。百分率（例: "70%"）または数量（例: "500m"） |
| メモリ使用量/率 | --memory | string | No | "" | 目標メモリ。百分率（例: "60%"）または数量（例: "200Mi"） |
| HPA名 | --name | string | No | "" | 作成するHPAの名前。未指定時は対象リソース名を使用 |
| ファイル指定 | -f, --filename | string[] | No | - | リソース定義ファイルのパス |
| Dry Run | --dry-run | string | No | "none" | "none" / "client" / "server" |
| フィールドマネージャ | --field-manager | string | No | "kubectl-autoscale" | サーバーサイドApply用のフィールドマネージャ名 |

### 出力項目

| 項目名 | 説明 |
|--------|------|
| 作成結果メッセージ | HPAリソースの作成成功時に「`<type>/<name> autoscaled`」形式で出力 |

## 表示項目

CLIコマンドのため、表示は作成結果のメッセージのみ。

| 項目 | 形式 | 説明 |
|------|------|------|
| リソース種別/名前 | `horizontalpodautoscaler.autoscaling/<name>` | 作成されたHPAリソースの種別と名前 |
| 操作結果 | `autoscaled` | 実行された操作の結果 |

## イベント仕様

### 1-コマンド実行

1. コマンドライン引数とフラグを解析する（`Complete`メソッド、L156-197）
2. 入力値のバリデーションを実行する（`Validate`メソッド、L200-224）
   - `--max`が1未満の場合エラー
   - `--max`が`--min`未満の場合エラー
   - `--cpu-percent`と`--cpu`の同時指定でエラー
   - CPU/メモリ値のフォーマット検証
3. 対象リソースのRESTマッピングを取得し、スケール可能か確認する（L246-249）
4. autoscaling/v2 APIでHPAリソースを作成する（`createHorizontalPodAutoscalerV2`、L341-446）
5. v2作成失敗時、v1互換性を確認し（`canCreateHPAV1`、L282-292）、v1 APIにフォールバックする（L265-269）
6. API Serverに作成リクエストを送信する（`handleHPA`、L295-339）
7. 結果を標準出力に表示する

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象リソース | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| autoscaleコマンド実行 | HorizontalPodAutoscaler | CREATE | HPAリソースをetcd上に作成 |

### テーブル別更新項目詳細

#### HorizontalPodAutoscaler（autoscaling/v2）

| 操作 | 項目 | 更新値・取得条件 | 備考 |
|-----|------|-----------------|------|
| CREATE | metadata.name | --nameフラグ値、未指定時は対象リソース名 | |
| CREATE | metadata.namespace | 現在のnamespaceコンテキスト | --namespace指定時はその値 |
| CREATE | spec.scaleTargetRef | 対象リソースのAPIVersion/Kind/Name | |
| CREATE | spec.minReplicas | --min値 | 未指定時はnull（サーバーデフォルト） |
| CREATE | spec.maxReplicas | --max値 | 必須 |
| CREATE | spec.metrics[] | CPU/メモリのメトリクス仕様 | 指定されたメトリクスに応じて設定 |

## メッセージ仕様

| 種別 | メッセージ | 条件 |
|------|-----------|------|
| 成功 | `horizontalpodautoscaler.autoscaling/<name> autoscaled` | HPA作成成功時 |
| 成功（dry-run） | `horizontalpodautoscaler.autoscaling/<name> created (dry run)` | dry-run実行時 |
| エラー | `--max=MAXPODS is required and must be at least 1, max: %d` | --maxが1未満 |
| エラー | `--max=MAXPODS must be larger or equal to --min=MINPODS, max: %d, min: %d` | max < min |
| エラー | `--cpu-percent and --cpu are mutually exclusive` | 両フラグ同時指定 |
| エラー | `cannot autoscale a %s: %w` | スケール非対応リソース |
| エラー | `no objects passed to autoscale` | 対象リソースなし |
| エラー | `failed to create HorizontalPodAutoscaler using autoscaling/v2 API: %w` | v2 API作成失敗 |

## 例外処理

| 例外条件 | 動作 |
|---------|------|
| 対象リソースが存在しない | エラーメッセージを表示して終了 |
| スケール非対応のリソース種別 | `cannot autoscale a <Kind>` エラーを表示 |
| API Serverへの接続失敗 | 接続エラーメッセージを表示して終了 |
| RBAC権限不足 | 403 Forbiddenエラーを表示して終了 |
| autoscaling/v2とv1の両方で失敗 | v1非互換エラーメッセージを表示して終了 |
| CPU/メモリ値の不正フォーマット | パースエラーメッセージを表示して終了 |

## 備考

- autoscaling/v2 APIを優先して使用し、失敗時のみv1にフォールバックする（L251-269）
- `--cpu-percent`フラグは非推奨であり、`--cpu`フラグの使用が推奨される（L146-147）
- CPU値は百分率（例: "70%"）の場合はUtilizationMetricType、数量（例: "500m"）の場合はAverageValueMetricTypeとして設定される
- メモリ値も同様に百分率と数量の両方をサポートする
- 単位なしの数値はCPUの場合はmilliCPU（"m"）、メモリの場合はMebibyte（"Mi"）として解釈される（L530-539）
- v1へのフォールバックはCPUPercent使用時かつメモリ未指定時、またはメモリ未指定かつUtilizationMetricType時のみ可能（L282-292）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

HPAリソースの作成に使用されるオプション構造体とHPA仕様を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | autoscale.go | `staging/src/k8s.io/kubectl/pkg/cmd/autoscale/autoscale.go` | AutoscaleOptions構造体（L73-102）：コマンドの全オプションを保持するデータ構造 |
| 1-2 | types.go（autoscaling/v2） | `staging/src/k8s.io/api/autoscaling/v2/types.go` | HorizontalPodAutoscaler/HorizontalPodAutoscalerSpec：HPAリソースの定義 |

**読解のコツ**: AutoscaleOptionsのMin/Max/CPUPercent/CPU/Memoryフィールドがコマンドラインフラグと直接対応している。HPAClientV1/V2の使い分けがv1/v2フォールバックの鍵。

#### Step 2: エントリーポイントを理解する

コマンド登録とCobra統合部分を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | autoscale.go | `staging/src/k8s.io/kubectl/pkg/cmd/autoscale/autoscale.go` | NewCmdAutoscale関数（L117-153）：コマンド定義とフラグ登録 |

**主要処理フロー**:
1. **L117-118**: NewCmdAutoscale関数でAutoscaleOptionsを初期化
2. **L120**: validArgsで対象リソース種別を定義（deployment, replicaset, replicationcontroller, statefulset）
3. **L129-133**: Run関数でComplete -> Validate -> Runの順に実行
4. **L139-144**: min/max/cpu-percent/cpu/memoryフラグの登録

#### Step 3: 初期化とバリデーション

Complete/Validateメソッドの処理フローを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | autoscale.go | `staging/src/k8s.io/kubectl/pkg/cmd/autoscale/autoscale.go` | Completeメソッド（L156-197）：クライアント初期化とnamespace解決 |
| 3-2 | autoscale.go | `staging/src/k8s.io/kubectl/pkg/cmd/autoscale/autoscale.go` | Validateメソッド（L200-224）：入力値検証ロジック |

**主要処理フロー**:
- **L162-168**: DiscoveryClientとScaleKindResolverの初期化
- **L177-182**: KubernetesClientSetからHPAクライアント（v1/v2）を取得
- **L201-209**: max/min/cpu-percentの数値バリデーション
- **L212-223**: CPU/メモリ入力値のパース検証

#### Step 4: メイン処理（HPA作成）

Runメソッドとv2/v1フォールバックロジックを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | autoscale.go | `staging/src/k8s.io/kubectl/pkg/cmd/autoscale/autoscale.go` | Runメソッド（L226-280）：リソース解決とHPA作成メインループ |
| 4-2 | autoscale.go | `staging/src/k8s.io/kubectl/pkg/cmd/autoscale/autoscale.go` | createHorizontalPodAutoscalerV2（L341-446）：v2 HPA構築 |
| 4-3 | autoscale.go | `staging/src/k8s.io/kubectl/pkg/cmd/autoscale/autoscale.go` | handleHPA（L295-339）：HPA作成リクエスト送信 |
| 4-4 | autoscale.go | `staging/src/k8s.io/kubectl/pkg/cmd/autoscale/autoscale.go` | parseResourceInput（L491-528）：CPU/メモリ値パーサー |

**主要処理フロー**:
- **L227-237**: Builderパターンで対象リソースを取得
- **L254**: v2 HPAオブジェクトを構築
- **L258-269**: v2作成失敗時にv1フォールバックを試行
- **L322-327**: v1/v2の型に応じてAPI Serverに作成リクエストを送信

### プログラム呼び出し階層図

```
NewCmdAutoscale (L117)
    |
    +-- Complete (L156)
    |       +-- f.ToDiscoveryClient()
    |       +-- f.KubernetesClientSet()
    |       +-- f.ToRawKubeConfigLoader().Namespace()
    |
    +-- Validate (L200)
    |       +-- parseResourceInput (L491) [CPU検証]
    |       +-- parseResourceInput (L491) [メモリ検証]
    |
    +-- Run (L226)
            +-- builder.Do() [リソース解決]
            +-- r.Visit()
                    +-- scaleKindResolver.ScaleForResource() [スケール可能性確認]
                    +-- createHorizontalPodAutoscalerV2 (L341)
                    |       +-- parseResourceInput (L491) [CPU]
                    |       +-- parseResourceInput (L491) [メモリ]
                    +-- handleHPA (L295)
                    |       +-- Recorder.Record()
                    |       +-- HPAClientV2.Create() or HPAClientV1.Create()
                    |       +-- printer.PrintObj()
                    +-- [v2失敗時] canCreateHPAV1 (L282)
                    +-- [v1フォールバック] createHorizontalPodAutoscalerV1 (L448)
                    +-- [v1フォールバック] handleHPA (L295)
```

### データフロー図

```
[入力]                      [処理]                              [出力]

コマンドライン引数        Complete()
  TYPE NAME            --> クライアント初期化 --------+
  --max=N                                            |
  --min=N              Validate()                    |
  --cpu=VALUE          --> 入力値検証 ---------------+
  --memory=VALUE                                     |
                       Run()                         |
                       --> リソース解決 ------------>|
                       --> scaleKindResolver ------->|
                       --> createHPAv2() ----------->+---> API Server
                       --> handleHPA() ------------->|     (etcd)
                                                     |
                       [v2失敗時]                     |
                       --> canCreateHPAV1() -------->|     HPA作成結果
                       --> createHPAv1() ----------->+---> stdout
                       --> handleHPA() ------------->|     "autoscaled"
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| autoscale.go | `staging/src/k8s.io/kubectl/pkg/cmd/autoscale/autoscale.go` | ソース | autoscaleコマンドのメイン実装 |
| autoscale_test.go | `staging/src/k8s.io/kubectl/pkg/cmd/autoscale/autoscale_test.go` | テスト | autoscaleコマンドのユニットテスト |
| types.go | `staging/src/k8s.io/api/autoscaling/v2/types.go` | ソース | autoscaling/v2 HPAリソース定義 |
| types.go | `staging/src/k8s.io/api/autoscaling/v1/types.go` | ソース | autoscaling/v1 HPAリソース定義 |
| factory.go | `staging/src/k8s.io/kubectl/pkg/cmd/util/factory.go` | ソース | Factoryインタフェース定義 |
| builder.go | `staging/src/k8s.io/cli-runtime/pkg/resource/builder.go` | ソース | リソースBuilderパターン実装 |
