# 画面設計書 13-kubectl cluster-info

## 概要

本ドキュメントは、Kubernetes CLIツール `kubectl cluster-info` コマンドの画面設計書である。クラスタのコントロールプレーンおよびクラスタサービスのアドレス情報を表示するコマンドの仕様を記載する。

### 本画面の処理概要

`kubectl cluster-info` コマンドは、Kubernetesクラスタのコントロールプレーン（API Server）のエンドポイントアドレスと、`kubernetes.io/cluster-service=true` ラベルが付与されたServiceのアドレスを表示する。クラスタの基本的な接続情報を素早く確認するための診断コマンドである。

**業務上の目的・背景**：Kubernetesクラスタを管理・利用する際に、クラスタのエンドポイント情報やクラスタサービス（DNS、Dashboard等）のアクセスURLを素早く確認する必要がある。本コマンドにより、kubeconfigで設定されたクラスタへの接続先を即座に把握できる。

**画面へのアクセス方法**：ターミナル上で `kubectl cluster-info` を実行する。追加引数は不要。

**主要な操作・処理内容**：
1. kubeconfigからAPI Serverのホストアドレスを取得して表示する
2. kube-system名前空間の `kubernetes.io/cluster-service=true` ラベル付きServiceを一覧取得する
3. 各Serviceのプロキシアドレスまたはロードバランサーアドレスを表示する
4. サブコマンド `dump` によりクラスタの詳細デバッグ情報を出力可能

**画面遷移**：本コマンドは情報表示のみのコマンドであり、リソース変更は行わない。`kubectl cluster-info dump` サブコマンドで詳細情報出力に遷移可能。

**権限による表示制御**：kube-system名前空間のServiceリソースに対するlist/get権限が必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 108 | クラスター情報（cluster-info） | 主機能 | クラスターのエンドポイントや各コンポーネントの情報を表示する主処理 |
| 1 | API Serverコア | API連携 | クラスター情報取得のためAPI Serverにリクエストを送信する |

## 画面種別

CLI コマンド（情報表示）

## URL/ルーティング

```
kubectl cluster-info
kubectl cluster-info dump
```

## 入出力項目

### 入力項目（コマンドライン引数・フラグ）

| 項目名 | フラグ | 型 | 必須 | デフォルト | 説明 |
|--------|--------|------|------|-----------|------|
| 名前空間 | --namespace | string | No | kube-system | 対象名前空間。未指定時はkube-system |

### 出力項目

| 項目名 | 説明 |
|--------|------|
| コントロールプレーンアドレス | `Kubernetes control plane is running at <URL>` |
| クラスタサービスアドレス | `<サービス名> is running at <URL>` |
| ヘルプメッセージ | デバッグ手順のガイダンス |

## 表示項目

| 項目 | 形式 | 説明 |
|------|------|------|
| Kubernetes control plane | `Kubernetes control plane is running at <host>` | API Serverのアドレス |
| クラスタサービス名 | `<name> is running at <link>` | kubernetes.io/nameラベル値またはService名 |
| プロキシURL | `<host>/api/<version>/namespaces/<ns>/services/<name>/proxy` | Service未公開時のプロキシアクセスパス |
| ロードバランサーURL | `http://<IP>:<port>` | LoadBalancer Ingress設定時の直接アクセスURL |
| デバッグガイダンス | `To further debug and diagnose cluster problems, use 'kubectl cluster-info dump'.` | 固定メッセージ |

## イベント仕様

### 1-cluster-info実行

1. kubeconfigからRESTClientConfigを取得する（`Complete`、L77-92）
2. 名前空間をデフォルト（kube-system）または指定値に設定する（L84-88）
3. `kubernetes.io/cluster-service=true` ラベルセレクタでServiceを検索する（`Run`、L94-155）
4. コントロールプレーンのアドレスを表示する（L106）
5. 各Serviceについて：
   - LoadBalancer Ingressがある場合はそのIP/Hostnameとポートを組み合わせたURLを表示（L111-119）
   - ない場合はAPI Serverプロキシ経由のURLを構築して表示（L120-141）
6. デバッグガイダンスメッセージを表示する（L151）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象リソース | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| cluster-info実行 | Service | SELECT | kube-system名前空間のクラスタサービスを取得（読み取りのみ） |

読み取り専用コマンドのため、データベース（etcd）への書き込みは発生しない。

## メッセージ仕様

| 種別 | メッセージ | 条件 |
|------|-----------|------|
| 情報 | `Kubernetes control plane is running at <host>` | 常に表示 |
| 情報 | `<name> is running at <link>` | 各クラスタサービスごとに表示 |
| 情報 | `To further debug and diagnose cluster problems, use 'kubectl cluster-info dump'.` | 常に最後に表示 |

## 例外処理

| 例外条件 | 動作 |
|---------|------|
| API Serverに接続できない | 接続エラーメッセージを表示して終了 |
| kubeconfigが見つからない | エラーメッセージを表示して終了 |
| Service取得権限がない | 403 Forbiddenエラーを表示して終了 |
| クラスタサービスが存在しない | コントロールプレーン情報とガイダンスのみ表示 |

## 備考

- コントロールプレーンアドレスはkubeconfigの`server`フィールド（`Client.Host`）から取得する
- Serviceアドレスの構築では、ポート名が`https`または番号が443の場合にHTTPSスキームを使用する（L128-129）
- Service名の表示には`kubernetes.io/name`ラベルの値を優先使用し、なければmetadata.nameを使用する（L143-146）
- `dump`サブコマンドは別ファイル（clusterinfo_dump.go）で実装されている

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | clusterinfo.go | `staging/src/k8s.io/kubectl/pkg/cmd/clusterinfo/clusterinfo.go` | ClusterInfoOptions構造体（L49-56）：Namespace、Builder、Clientフィールド |

**読解のコツ**: Client（*restclient.Config）からHost情報を、BuilderからService一覧を取得する構造。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | clusterinfo.go | `staging/src/k8s.io/kubectl/pkg/cmd/clusterinfo/clusterinfo.go` | NewCmdClusterInfo関数（L58-75）：コマンド定義とdumpサブコマンド登録 |

**主要処理フロー**:
1. **L58-61**: ClusterInfoOptionsの初期化
2. **L68-71**: Complete -> Run の実行チェーン
3. **L73**: dumpサブコマンドの登録

#### Step 3: メイン処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | clusterinfo.go | `staging/src/k8s.io/kubectl/pkg/cmd/clusterinfo/clusterinfo.go` | Runメソッド（L94-155）：Service検索とアドレス表示の全体フロー |

**主要処理フロー**:
- **L96-101**: Builder設定 - kube-system名前空間、`kubernetes.io/cluster-service=true`ラベルセレクタ
- **L106**: コントロールプレーンアドレスの出力
- **L108-148**: ServiceListのイテレーションとアドレス構築
- **L111-119**: LoadBalancer Ingressからのアドレス取得
- **L120-141**: API Serverプロキシ経由のアドレス構築
- **L151**: デバッグガイダンスの出力

### プログラム呼び出し階層図

```
NewCmdClusterInfo (L58)
    |
    +-- Complete (L77)
    |       +-- restClientGetter.ToRESTConfig()
    |       +-- resource.NewBuilder()
    |
    +-- Run (L94)
    |       +-- Builder.Do().Visit()
    |       +-- printService() [コントロールプレーン]
    |       +-- [各Service] printService()
    |
    +-- NewCmdClusterInfoDump (L73) [サブコマンド]
```

### データフロー図

```
[入力]                      [処理]                              [出力]

kubeconfig              Complete()
  server: <host>       --> RESTConfig取得 ----------+
                                                    |
                       Run()                        |
                       --> Builder構築 ------------>|
                       --> ラベルセレクタ:          |
                          cluster-service=true     |
                       --> Service一覧取得 -------->+---> API Server
                                                    |
                       --> Client.Host ------------>+---> stdout
                       --> Service[].Ingress ------>|     "control plane is running at..."
                       --> Service[].Proxy URL ---->|     "<service> is running at..."
                       --> ガイダンスメッセージ ---->|     "use cluster-info dump"
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| clusterinfo.go | `staging/src/k8s.io/kubectl/pkg/cmd/clusterinfo/clusterinfo.go` | ソース | cluster-infoコマンドのメイン実装 |
| clusterinfo_dump.go | `staging/src/k8s.io/kubectl/pkg/cmd/clusterinfo/clusterinfo_dump.go` | ソース | cluster-info dumpサブコマンドの実装 |
| builder.go | `staging/src/k8s.io/cli-runtime/pkg/resource/builder.go` | ソース | リソースBuilderパターン実装 |
