# 画面設計書 15-kubectl cordon

## 概要

本ドキュメントは、Kubernetes CLIツール `kubectl cordon` コマンドの画面設計書である。ノードをスケジュール不可（Unschedulable）状態に設定し、新規Podの配置を防止するコマンドの仕様を記載する。

### 本画面の処理概要

`kubectl cordon` コマンドは、指定したノードの `spec.unschedulable` フィールドを `true` に設定し、Kubernetesスケジューラーがそのノードに新しいPodを配置しないようにする。既存のPodには影響を与えない。

**業務上の目的・背景**：ノードのメンテナンス（OSアップデート、ハードウェア交換等）を行う際、まずノードへの新規Pod配置を停止する必要がある。cordonは`drain`の前段階として使用され、安全なメンテナンスフローの起点となる。

**画面へのアクセス方法**：ターミナル上で `kubectl cordon <ノード名>` を実行する。

**主要な操作・処理内容**：
1. 指定されたノードの現在の状態を確認する
2. ノードの`spec.unschedulable`を`true`に設定するパッチを適用する
3. 結果を標準出力に表示する

**画面遷移**：メンテナンスフローにおいて `kubectl cordon` -> `kubectl drain` -> メンテナンス作業 -> `kubectl uncordon` の順序で使用される。

**権限による表示制御**：nodeリソースに対するget/patch権限が必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 93 | ドレイン（drain） | 主機能 | ノードをスケジュール不可（SchedulingDisabled）に設定する処理 |
| 18 | Node Lifecycleコントローラー | API連携 | ノードのスケジュール状態変更後にNode Lifecycleコントローラーが状態を監視する |

## 画面種別

CLI コマンド（リソース更新）

## URL/ルーティング

```
kubectl cordon NODE
```

## 入出力項目

### 入力項目

| 項目名 | フラグ | 型 | 必須 | デフォルト | 説明 |
|--------|--------|------|------|-----------|------|
| ノード名 | 位置引数 | string | Yes(*) | - | cordon対象のノード名 |
| ラベルセレクタ | -l, --selector | string | No | "" | ラベルによるノード選択 |
| Dry Run | --dry-run | string | No | "none" | "none" / "client" / "server" |

(*) ノード名または--selectorのいずれかが必須

### 出力項目

| 項目名 | 説明 |
|--------|------|
| 処理結果メッセージ | `node/<name> cordoned` または `node/<name> already cordoned` |

## 表示項目

| 項目 | 形式 | 説明 |
|------|------|------|
| ノード名 | `node/<name>` | 対象ノード |
| 操作結果 | `cordoned` / `already cordoned` | 実行結果 |

## イベント仕様

### 1-cordon実行

1. コマンドライン引数を解析し、DrainCmdOptionsを初期化する（`Complete`、drain.go L243-322）
2. ノード名と--selectorの排他チェックを行う（L249-251）
3. Builderでノードリソースを取得する（L292-321）
4. 各ノードに対してRunCordonOrUncordon(true)を実行する（`RunCordonOrUncordon`、L402-458）
   - CordonHelperを作成する（L416）
   - ノードが既にcordon済みか確認する（`UpdateIfRequired`、L422）
   - 未cordonの場合、PatchOrReplaceでノードを更新する（L431）
   - 結果メッセージを表示する

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象リソース | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| cordon実行 | Node | PATCH/UPDATE | spec.unschedulableをtrueに設定 |

### テーブル別更新項目詳細

#### Node

| 操作 | 項目 | 更新値・取得条件 | 備考 |
|-----|------|-----------------|------|
| PATCH | spec.unschedulable | true | SchedulingDisabled状態にする |

## メッセージ仕様

| 種別 | メッセージ | 条件 |
|------|-----------|------|
| 成功 | `node/<name> cordoned` | cordon成功時 |
| 情報 | `node/<name> already cordoned` | 既にcordon済み |
| エラー | `USAGE: cordon NODE [flags]` | 引数未指定 |
| エラー | `error: cannot specify both a node name and a --selector option` | 名前とセレクタの同時指定 |
| エラー | `error: unable to cordon node "<name>": <error>` | cordon処理失敗 |

## 例外処理

| 例外条件 | 動作 |
|---------|------|
| ノード名未指定かつセレクタ未指定 | 使用法エラーを表示して終了 |
| ノードが存在しない | NotFoundエラーを表示して終了 |
| パッチ適用失敗 | エラーメッセージを表示して次のノードに続行 |
| 権限不足 | 403 Forbiddenエラーを表示 |

## 備考

- cordonとuncordonは同一の`RunCordonOrUncordon`関数で実装されており、`desired`パラメータ（bool）で動作を切り替える（L402）
- ノードが既にcordon済みの場合はパッチを適用せず「already cordoned」と表示する（L422-428）
- `drain.NewCordonHelperFromRuntimeObject`がPatch/Replace操作を抽象化する（L416）
- dry-run=clientの場合はAPI Serverへのリクエストを送信しない（L430）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | drain.go | `staging/src/k8s.io/kubectl/pkg/cmd/drain/drain.go` | DrainCmdOptions構造体（L44-55）：cordon/uncordon/drain共通のオプション |

**読解のコツ**: DrainCmdOptionsはcordon/uncordon/drainの3コマンドで共有される構造体。`drainer`フィールド（drain.Helper型）が実際のPod退避処理を担当するが、cordon/uncordonではRunCordonOrUncordonのみ使用する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | drain.go | `staging/src/k8s.io/kubectl/pkg/cmd/drain/drain.go` | NewCmdCordon関数（L66-84）：cordonコマンド定義 |

**主要処理フロー**:
1. **L67**: NewDrainCmdOptionsでオプション初期化
2. **L76-79**: Complete -> RunCordonOrUncordon(true)の呼び出しチェーン
3. **L81-82**: --selectorと--dry-runフラグの登録

#### Step 3: コア処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | drain.go | `staging/src/k8s.io/kubectl/pkg/cmd/drain/drain.go` | Complete（L243-322）：ノードリソースの解決 |
| 3-2 | drain.go | `staging/src/k8s.io/kubectl/pkg/cmd/drain/drain.go` | RunCordonOrUncordon（L402-458）：cordon/uncordon実行 |

**主要処理フロー**:
- **L246-251**: 引数チェック（ノード名とセレクタの排他）
- **L292-321**: Builderでノードリソースを取得し、nodeInfosに格納
- **L414-415**: ノードのGroupVersionKindを確認
- **L416**: CordonHelper作成
- **L422**: 更新必要性の確認
- **L431**: PatchOrReplaceでノード更新

### プログラム呼び出し階層図

```
NewCmdCordon (L66)
    |
    +-- NewDrainCmdOptions (L149)
    |
    +-- Complete (L243)
    |       +-- f.KubernetesClientSet()
    |       +-- f.NewBuilder()
    |       +-- builder.ResourceNames("nodes", args...)
    |       +-- r.Visit() [nodeInfosに格納]
    |
    +-- RunCordonOrUncordon(true) (L402)
            +-- [各ノード]
                    +-- drain.NewCordonHelperFromRuntimeObject()
                    +-- c.UpdateIfRequired(true)
                    +-- c.PatchOrReplace()
                    +-- printer.PrintObj()
```

### データフロー図

```
[入力]                      [処理]                              [出力]

ノード名 / --selector   Complete()
                       --> Builder.Do() ------------>+---> API Server
                       --> ノードリソース取得 ------->|     (Node取得)
                                                     |
                       RunCordonOrUncordon(true)     |
                       --> CordonHelper作成 -------->|
                       --> UpdateIfRequired -------->|
                       --> PatchOrReplace ---------->+---> API Server
                                                     |     (Node更新)
                                                     |
                                                     +---> stdout
                                                           "cordoned"
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| drain.go | `staging/src/k8s.io/kubectl/pkg/cmd/drain/drain.go` | ソース | cordon/uncordon/drainコマンドの共通実装 |
| drain.go (pkg) | `staging/src/k8s.io/kubectl/pkg/drain/drain.go` | ソース | CordonHelper等のドレインユーティリティ |
| drain_test.go | `staging/src/k8s.io/kubectl/pkg/cmd/drain/drain_test.go` | テスト | drain関連コマンドのユニットテスト |
