# 画面設計書 19-kubectl describe

## 概要

本ドキュメントは、Kubernetes CLIツール `kubectl describe` コマンドの画面設計書である。リソースの詳細情報と関連イベントを人間が読みやすい形式で表示するコマンドの仕様を記載する。

### 本画面の処理概要

`kubectl describe` コマンドは、指定されたKubernetesリソースの詳細情報を取得し、イベント情報と合わせて構造化されたテキスト形式で出力する。`kubectl get -o yaml`とは異なり、関連リソースの情報やイベントも含めた人間が読みやすい詳細表示を提供する。

**業務上の目的・背景**：リソースの状態確認やトラブルシューティングにおいて、リソースの詳細スペック、ステータス、関連イベントを一覧で確認する必要がある。特にPodが起動しない、Serviceが接続できないなどの問題調査時に、describeの出力から原因を特定できることが多い。

**画面へのアクセス方法**：ターミナル上で `kubectl describe <TYPE> [NAME]` を実行する。名前のプレフィックス一致やラベルセレクタによる選択も可能。

**主要な操作・処理内容**：
1. 指定されたリソース種別と名前（またはプレフィックス/ラベル）でリソースを検索する
2. 各リソースに対応するDescriberを取得し、詳細情報を生成する
3. 関連イベント情報を含めた詳細テキストを標準出力に表示する

**画面遷移**：本コマンドは情報表示のみのコマンドであり、リソース変更は行わない。デプロイフローやトラブルシューティングフローで頻繁に使用される。

**権限による表示制御**：対象リソースのget権限と、イベントリソースのlist権限が必要。全名前空間指定時はクラスタスコープの権限が必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 86 | リソース詳細表示（describe） | 主機能 | リソースの詳細情報とイベント情報を表示する主処理 |
| 1 | API Serverコア | API連携 | リソース詳細情報の取得リクエストをAPI Serverに送信する |
| 115 | イベント表示（events） | 補助機能 | describeコマンド内でリソースに関連するイベント情報も表示する |

## 画面種別

CLI コマンド（情報表示 - 詳細）

## URL/ルーティング

```
kubectl describe (-f FILENAME | TYPE [NAME_PREFIX | -l label] | TYPE/NAME)
```

## 入出力項目

### 入力項目

| 項目名 | フラグ | 型 | 必須 | デフォルト | 説明 |
|--------|--------|------|------|-----------|------|
| リソース種別 | 位置引数 | string | Yes | - | Kubernetesリソース種別（pods, services, nodes等） |
| リソース名/プレフィックス | 位置引数 | string | No | - | リソース名または名前プレフィックス |
| ファイル指定 | -f, --filename | string[] | No | - | リソース定義ファイルのパス |
| ラベルセレクタ | -l, --selector | string | No | "" | ラベルによるフィルタリング |
| 全名前空間 | -A, --all-namespaces | bool | No | false | 全名前空間のリソースを表示 |
| イベント表示 | --show-events | bool | No | true | イベント情報を表示するか |
| チャンクサイズ | --chunk-size | int | No | 500 | リスト取得時のチャンクサイズ |

### 出力項目

リソース種別に応じた詳細テキスト出力（構造化テキスト形式）。

## 表示項目

リソース種別ごとに表示内容が異なるが、共通的に以下の情報が含まれる：

| 項目 | 説明 |
|------|------|
| Name | リソース名 |
| Namespace | 名前空間 |
| Labels | ラベル一覧 |
| Annotations | アノテーション一覧 |
| Status/State | リソースの状態 |
| Events | 関連イベント一覧（--show-events=true時） |

具体的な表示項目はリソース種別（Pod, Service, Node, Deployment等）ごとに異なり、各Describer実装で定義される。

## イベント仕様

### 1-describe実行

1. DescribeFlagsを初期化し、コマンドライン引数とフラグを解析する（`NewCmdDescribe`、describe.go L144-165）
2. ToOptionsでランタイムオプションに変換する（`ToOptions`、L106-142）
   - 名前空間の解決
   - リソース種別引数の検証
   - Describer関数の設定
3. Builderでリソースを検索する（`Run`、L171-236）
4. 各リソースに対してDescriberを取得し、Describeメソッドを呼び出す（L199-217）
5. 結果テキストを標準出力に表示する（L218-223）
6. リソースが見つからない場合、名前プレフィックスで再検索する（`DescribeMatchingResources`、L238-275）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象リソース | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| describe実行 | 指定リソース | SELECT | リソースの詳細情報を取得 |
| describe実行 | Event | SELECT | 関連イベントを取得（--show-events=true時） |

読み取り専用コマンドのため、データ書き込みは発生しない。

## メッセージ仕様

| 種別 | メッセージ | 条件 |
|------|-----------|------|
| エラー | `You must specify the type of resource to describe. <suggestions>` | リソース種別未指定 |
| 情報 | `No resources found` | 全名前空間でリソースなし |
| 情報 | `No resources found in %s namespace.` | 特定名前空間でリソースなし |

## 例外処理

| 例外条件 | 動作 |
|---------|------|
| リソース種別が未指定 | APIリソースの候補一覧を表示して終了 |
| リソースが見つからない | 名前プレフィックスによる再検索を実行。それでも見つからない場合はNotFoundエラー |
| Describerの取得失敗 | エラーを記録して次のリソースに続行（重複エラーは抑制） |
| Describe処理の失敗 | エラーを記録して次のリソースに続行 |
| 全リソースのDescribe失敗 | 集約されたエラーを返す |

## 備考

- DescriberはリソースRESTMappingに基づいて動的に解決される（`describe.DescriberFn`、L125-126）
- 名前プレフィックスマッチ機能により、正確な名前を知らなくてもリソースを特定できる（L238-275）
- --show-eventsはデフォルトtrueであり、明示的にfalseを指定しない限りイベントが表示される（L89-91）
- 複数リソースの表示時は改行2行で区切られる（L221-223）
- エラーの重複抑制にsets.Newを使用している（L196）
- ChunkSizeのデフォルトはcmdutil.DefaultChunkSize（500）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | describe.go | `staging/src/k8s.io/kubectl/pkg/cmd/describe/describe.go` | DescribeFlags構造体（L74-81）：CLI入力をそのまま保持 |
| 1-2 | describe.go | `staging/src/k8s.io/kubectl/pkg/cmd/describe/describe.go` | DescribeOptions構造体（L277-294）：ランタイム実行オプション |

**読解のコツ**: DescribeFlagsはCLI入力の生データ、DescribeOptionsはToOptionsで変換されたランタイム用データ。Describerフィールド（関数型）がリソース種別ごとの詳細表示ロジックを提供する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | describe.go | `staging/src/k8s.io/kubectl/pkg/cmd/describe/describe.go` | NewCmdDescribe関数（L144-165）：コマンド定義 |

**主要処理フロー**:
1. **L145**: NewDescribeFlagsでフラグ初期化
2. **L154-159**: ToOptions -> Validate -> Runの実行チェーン
3. **L162**: AddFlagsでフラグ登録

#### Step 3: 検索とDescribe処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | describe.go | `staging/src/k8s.io/kubectl/pkg/cmd/describe/describe.go` | Run（L171-236）：Builder検索→Describe→出力 |
| 3-2 | describe.go | `staging/src/k8s.io/kubectl/pkg/cmd/describe/describe.go` | DescribeMatchingResources（L238-275）：プレフィックスマッチ |

**主要処理フロー**:
- **L172-181**: Builderで対象リソースを検索（ラベルセレクタ、名前空間、ファイル指定対応）
- **L188-194**: Infos()で検索結果取得、NotFound時はプレフィックスマッチに遷移
- **L198-223**: 各リソースに対してDescriber.Describe()呼び出しと結果出力
- **L260-270**: プレフィックスマッチでのDescribe

### プログラム呼び出し階層図

```
NewCmdDescribe (L144)
    |
    +-- NewDescribeFlags (L84)
    |
    +-- ToOptions (L106)
    |       +-- Factory.ToRawKubeConfigLoader().Namespace()
    |       +-- describe.DescriberFn()
    |
    +-- Validate (L167)
    |
    +-- Run (L171)
            +-- NewBuilder().Do()
            +-- r.Infos()
            +-- [NotFound] DescribeMatchingResources (L238)
            |       +-- NewBuilder().Do().Infos()
            |       +-- [プレフィックスマッチ] describer.Describe()
            +-- [各リソース]
                    +-- Describer(mapping)
                    +-- describer.Describe(namespace, name, settings)
                    +-- fmt.Fprint(Out, s)
```

### データフロー図

```
[入力]                      [処理]                              [出力]

TYPE [NAME_PREFIX]      ToOptions()
  -l selector          --> 名前空間解決 -----------+
  -f filename          --> Describer関数設定 ------>|
                                                    |
                       Run()                        |
                       --> Builder.Do() ----------->+---> API Server
                       --> r.Infos() -------------->|     (リソース取得)
                       --> [各リソース]              |
                       |   Describer.Describe() -->+---> API Server
                       |   (リソース詳細取得)       |     (詳細+イベント)
                       --> 出力整形 --------------->+---> stdout
                                                          構造化テキスト
                       [NotFound時]
                       --> DescribeMatchingResources()
                       --> プレフィックスマッチ検索 >+---> API Server
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| describe.go (cmd) | `staging/src/k8s.io/kubectl/pkg/cmd/describe/describe.go` | ソース | describeコマンドのCobra統合とメイン処理 |
| describe.go (pkg) | `staging/src/k8s.io/kubectl/pkg/describe/describe.go` | ソース | DescriberFn：リソース種別ごとのDescriber解決 |
| versioned/ | `staging/src/k8s.io/kubectl/pkg/describe/versioned/` | ソース | リソース種別ごとのDescriber実装 |
| describe_test.go | `staging/src/k8s.io/kubectl/pkg/cmd/describe/describe_test.go` | テスト | describeコマンドのユニットテスト |
