# 画面設計書 24-kubectl proxy

## 概要

本ドキュメントは、Kubernetes CLIツール kubectl の `proxy` コマンドに関する画面設計書である。kubectl proxy はローカルマシンにKubernetes APIサーバーへのプロキシを作成し、認証済みのAPI通信を簡素化する。

### 本画面の処理概要

kubectl proxy コマンドは、ローカルマシン上でHTTPプロキシサーバーを起動し、kubeconfig の認証情報を使用してKubernetes APIサーバーへのリクエストを中継する。これにより、認証ヘッダーの設定なしでAPIにアクセスできるようになる。

**業務上の目的・背景**：Kubernetes Dashboard の操作、カスタムツールやスクリプトからの API アクセス、REST API の直接テスト等において、認証の手間を省いて安全にAPIにアクセスするために使用される。

**画面へのアクセス方法**：ターミナルから `kubectl proxy` を実行する。デフォルトでは localhost:8001 でプロキシを起動する。

**主要な操作・処理内容**：
1. プロキシサーバーの設定（ポート、アドレス、パスフィルタ等）
2. HTTPリスナーの起動
3. ローカルリクエストの受信とAPIサーバーへのプロキシ
4. 静的ファイルサービス（--www フラグ指定時）
5. CORSフィルタリング（--accept-hosts/--reject-paths によるアクセス制御）

**画面遷移**：単独で使用。Ctrl+C で停止。

**権限による表示制御**：プロキシ経由のリクエストは kubeconfig の認証情報で認可される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 90 | APIプロキシ（proxy） | 主機能 | ローカルプロキシの起動とAPI中継 |

## 画面種別

CLI常駐型コマンド（HTTPプロキシサーバー）

## URL/ルーティング

```
kubectl proxy [--port=PORT] [--www=DIR] [--www-prefix=PREFIX] [--api-prefix=PREFIX]
```

プロキシ起動後のアクセスURL：
```
http://localhost:{PORT}/api/v1/namespaces/...
```

## 入出力項目

| 項目名 | 種別 | 必須 | 型 | 説明 |
|--------|------|------|-----|------|
| --port, -p | フラグ | No | int | プロキシポート番号（デフォルト: 8001、0でランダム） |
| --address | フラグ | No | string | バインドアドレス（デフォルト: 127.0.0.1） |
| --api-prefix | フラグ | No | string | APIをサーブするプレフィックス（デフォルト: /） |
| --www, -w | フラグ | No | string | 静的ファイルのディレクトリ |
| --www-prefix | フラグ | No | string | 静的ファイルのURLプレフィックス（デフォルト: /static/） |
| --accept-hosts | フラグ | No | string | 許可するHostヘッダーの正規表現（デフォルト: ^localhost$,^127\.0\.0\.1$,^\[::1\]$） |
| --accept-paths | フラグ | No | string | 許可するパスの正規表現（デフォルト: ^.*） |
| --reject-paths | フラグ | No | string | 拒否するパスの正規表現（デフォルト: ^/api/.*/pods/.*/exec,^/api/.*/pods/.*/attach） |
| --reject-methods | フラグ | No | string | 拒否するHTTPメソッドの正規表現（デフォルト: ^$、すべて許可） |
| --unix-socket, -u | フラグ | No | string | UNIXソケットパス |
| --keepalive | フラグ | No | duration | キープアライブ間隔（デフォルト: 0、無効） |
| --disable-filter | フラグ | No | bool | フィルタリングを無効化（危険） |
| --append-server-path | フラグ | No | bool | サーバーURLのパスを追加 |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| 起動メッセージ | "Starting to serve on {address}:{port}" |
| アクセスログ | HTTP メソッド、パス、ステータスコード（プロキシ自体は出力しないが、アクセスされたAPI結果がレスポンスとなる） |

## イベント仕様

### 1-プロキシ起動

1. Complete: コマンドフラグの解析
2. filterByConfig設定: accept-hosts, reject-paths, accept-paths, reject-methods の正規表現コンパイル
3. NewServer: プロキシハンドラ作成、フィルタ適用、静的ファイルハンドラ追加
4. Listen: TCPリスナーまたはUNIXソケットリスナーの起動
5. Serve: HTTPサーバーとしてリクエスト受付開始

### 2-プロキシ停止

Ctrl+C（SIGINT/SIGTERM）でHTTPサーバーが停止する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| proxy実行 | - | - | kubectl proxy自体はリソースを変更しない。プロキシ経由のリクエスト次第 |

### テーブル別更新項目詳細

kubectl proxy 自体はKubernetesリソースの状態を変更しない。プロキシ経由でのAPI呼び出しにより変更が発生する場合がある。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|------------|------|--------------|----------|
| M-01 | 情報 | "Starting to serve on %s" | プロキシ起動時（行92） |
| M-02 | 警告 | "WARNING: Request filter disabled, your proxy is vulnerable to XSRF attacks..." | --disable-filter 指定時（行57-58） |
| M-03 | エラー | "No serving location was requested." | ポート0未指定かつunixソケット未指定で起動場所なし |

## 例外処理

| 例外 | 状態 | 対処 |
|------|------|------|
| ポートバインド失敗 | エラー終了 | ポートが使用中の旨を表示 |
| 正規表現コンパイルエラー | エラー終了 | 無効な正規表現のエラーを表示 |
| UNIXソケット作成失敗 | エラー終了 | パーミッションやパスのエラーを表示 |

## 備考

- デフォルトで exec/attach パスが拒否される（セキュリティ上の理由）。
- `--disable-filter` は XSRF 攻撃に対して脆弱になるため、本番環境では使用すべきではない（行57-58）。
- UNIXソケットが指定された場合、パーミッションは 0600 に設定される（行83-84）。
- `--port 0` でランダムポートが割り当てられ、割り当てられたポートが表示される。
- keepalive のデフォルトは無効（0秒）。
- `--append-server-path` は ProxyPassthrough API サーバーのパスを追加する。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | proxy.go | `staging/src/k8s.io/kubectl/pkg/cmd/proxy/proxy.go` | NewCmdProxy（行40-96）: フラグ定義とデフォルト値 |

**読解のコツ**: proxy コマンドはオプション構造体を独立して定義せず、NewCmdProxy 関数内でローカル変数として管理している。主要な処理は `proxy.Server` パッケージに委譲される。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | proxy.go | `staging/src/k8s.io/kubectl/pkg/cmd/proxy/proxy.go` | Run関数（行56-94）: フィルタ構築、Server作成、Listen、Serve |

**主要処理フロー**:
1. **行57-58**: disable-filter 時の警告表示
2. **行62-65**: accept-hosts, reject-paths, accept-paths, reject-methods の正規表現コンパイル
3. **行67-70**: proxy.NewServer で apiProxyHandler を作成
4. **行72-84**: TCP または UNIX ソケットリスナーの作成
5. **行92-94**: サーバー起動メッセージとHTTPサーバー起動

#### Step 3: プロキシハンドラを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | proxy_server.go | `staging/src/k8s.io/kubectl/pkg/proxy/proxy_server.go` | NewServer: プロキシハンドラの構築ロジック |

### プログラム呼び出し階層図

```
NewCmdProxy (行40)
    |
    +-- Run (行56)
            |
            +-- proxy.MakeRegexpArrayOrDie (行62-65)
            +-- proxy.NewServer (行67-70)
            |       +-- filterByConfig (パスフィルタ)
            |       +-- httputil.ReverseProxy (APIプロキシ)
            |       +-- staticFileHandler (静的ファイル)
            |
            +-- net.Listen("tcp" or "unix") (行72-84)
            +-- http.Serve (行94)
```

### データフロー図

```
[入力]                    [処理]                           [出力]

kubectl proxy            NewCmdProxy
(フラグ設定) -----------> (フラグ解析)
                              |
                         proxy.NewServer
                         (フィルタ構築)
                              |
ローカルHTTPクライアント  net.Listen
(localhost:8001) -------> (HTTPリスナー) ----------------> APIサーバーレスポンス
       |                      |
       +-- HTTP Request ---> filterByConfig
                              (accept/reject判定)
                              |
                         httputil.ReverseProxy
                         (APIサーバーに中継) ------------> HTTP Response
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| proxy.go | `staging/src/k8s.io/kubectl/pkg/cmd/proxy/proxy.go` | ソース | proxy コマンドの主実装 |
| proxy_server.go | `staging/src/k8s.io/kubectl/pkg/proxy/proxy_server.go` | ソース | プロキシサーバーのHTTPハンドラ実装 |
| transport/ | `staging/src/k8s.io/client-go/transport/` | ソース | 認証トランスポートの設定 |
