# 画面設計書 26-kubectl auth

## 概要

本ドキュメントは、Kubernetes CLIツール kubectl の `auth` コマンドに関する画面設計書である。kubectl auth は認可（Authorization）の検査と管理を行うサブコマンド群を提供する。

### 本画面の処理概要

kubectl auth コマンドは、Kubernetes クラスターの認可システムを検査するための親コマンドであり、3つのサブコマンド（can-i, reconcile, whoami）を提供する。

**業務上の目的・背景**：
- **can-i**: 特定のアクションが許可されているかを確認する。RBAC設定の検証やトラブルシューティングに使用。
- **reconcile**: RBACリソース（Role, RoleBinding, ClusterRole, ClusterRoleBinding）を入力ファイルと照合し差分を適用する。
- **whoami**: 現在の認証済みユーザー情報を表示する。

**画面へのアクセス方法**：ターミナルから `kubectl auth <subcommand>` を実行する。

**主要な操作・処理内容**：
1. `can-i`: SubjectAccessReview API を使用した権限チェック
2. `reconcile`: RBAC リソースのセマンティック対応の調整（マージ）
3. `whoami`: SelfSubjectReview API を使用した現在ユーザー情報の取得

**画面遷移**：各サブコマンドは独立して動作する。

**権限による表示制御**：can-i は SelfSubjectAccessReview（自分自身の権限確認）は全ユーザー利用可能。他者の権限確認には SubjectAccessReview の権限が必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 92 | 認可検査（auth） | 主機能 | 認可の検査と管理のサブコマンド群 |

## 画面種別

CLIコマンド（非対話型、サブコマンド集合）

## URL/ルーティング

```
kubectl auth [command]
kubectl auth can-i VERB [TYPE | TYPE/NAME | NONRESOURCEURL]
kubectl auth reconcile -f FILENAME
kubectl auth whoami
```

内部的に使用する API エンドポイント：
```
POST /apis/authorization.k8s.io/v1/selfsubjectaccessreviews     (can-i)
POST /apis/authorization.k8s.io/v1/subjectaccessreviews         (can-i --as)
POST /apis/authentication.k8s.io/v1/selfsubjectreviews           (whoami)
PUT  /apis/rbac.authorization.k8s.io/v1/clusterroles/{name}      (reconcile)
```

## 入出力項目

### auth can-i

| 項目名 | 種別 | 必須 | 型 | 説明 |
|--------|------|------|-----|------|
| VERB | 引数 | Yes | string | Kubernetes API動詞（get, list, create, delete等） |
| TYPE / NONRESOURCEURL | 引数 | Yes | string | リソースタイプまたは非リソースURL |
| --all-namespaces, -A | フラグ | No | bool | 全namespaceで確認 |
| --list | フラグ | No | bool | 許可されたアクション一覧を表示 |
| --quiet, -q | フラグ | No | bool | 結果をステータスコードのみで返す |
| --no-headers | フラグ | No | bool | ヘッダーを表示しない |
| --subresource | フラグ | No | string | サブリソースの指定 |

### auth reconcile

| 項目名 | 種別 | 必須 | 型 | 説明 |
|--------|------|------|-----|------|
| -f FILENAME | フラグ | Yes | string[] | RBACリソース定義ファイル |
| --dry-run | フラグ | No | string | ドライラン |
| --remove-extra-permissions | フラグ | No | bool | 入力にない余分な権限を削除 |
| --remove-extra-subjects | フラグ | No | bool | 入力にない余分なsubjectを削除 |

### auth whoami

| 項目名 | 種別 | 必須 | 型 | 説明 |
|--------|------|------|-----|------|
| -o, --output | フラグ | No | string | 出力形式（json, yaml等） |

## 表示項目

### auth can-i
| 項目名 | 説明 |
|--------|------|
| 結果 | "yes" / "no" / "no - <reason>" |
| アクション一覧 | --list 時: Resources, Non-Resource URLs, Resource Names, Verbs のテーブル |

### auth reconcile
| 項目名 | 説明 |
|--------|------|
| 適用結果 | 作成/更新されたRBACリソースの情報 |

### auth whoami
| 項目名 | 説明 |
|--------|------|
| ユーザー情報 | Username, UID, Groups, Extra のテーブル |

## イベント仕様

### 1-can-i 実行

1. Complete: 引数解析（VERB, リソースタイプ, リソース名, サブリソース）
2. Validate: 動詞とリソースの存在確認
3. Run: SelfSubjectAccessReview / SubjectAccessReview APIを呼び出し
4. 結果表示: "yes" / "no" / テーブル出力

### 2-reconcile 実行

1. ファイルからRBACリソースを読み込み
2. 各リソースタイプ（Role, ClusterRole, RoleBinding, ClusterRoleBinding）ごとに処理
3. 存在しないリソースは作成、存在するリソースは権限/subjectのマージ

### 3-whoami 実行

1. SelfSubjectReview APIを呼び出し
2. 認証済みユーザー情報を表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| can-i | SubjectAccessReview | CREATE（読み取り系） | AccessReview APIでの権限確認（リソース変更なし） |
| reconcile | Role, ClusterRole, RoleBinding, ClusterRoleBinding | CREATE/UPDATE | RBACリソースの作成・更新 |
| whoami | SelfSubjectReview | CREATE（読み取り系） | 認証情報の問い合わせ（リソース変更なし） |

### テーブル別更新項目詳細

reconcile のみがリソースを変更する。Role/ClusterRole の rules フィールド、RoleBinding/ClusterRoleBinding の subjects フィールドが更新対象。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|------------|------|--------------|----------|
| M-01 | 情報 | "yes" | can-i で権限あり |
| M-02 | 情報 | "no" / "no - reason" | can-i で権限なし |
| M-03 | 警告 | "Warning: the list may be incomplete..." | can-i --list で一覧が不完全な場合 |

## 例外処理

| 例外 | 状態 | 対処 |
|------|------|------|
| APIサーバー未対応（whoami） | フォールバック | v1alpha1 -> v1beta1 -> v1 の順で試行 |
| RBACリソース型不正（reconcile） | エラー終了 | サポート外のリソースタイプのエラーを表示 |
| 動詞/リソース未指定（can-i） | エラー終了 | 必要な引数が不足のエラーを表示 |

## 備考

- auth は親コマンドであり、直接実行するとサブコマンド一覧が表示される（auth.go 行33）。
- can-i は `--as` グローバルフラグと組み合わせて他者の権限を確認できる。
- reconcile は `apply` より RBAC に適している。セマンティック対応のマージ（ルールとsubjectの意味的な統合）を行うため。
- whoami は v1alpha1, v1beta1, v1 の順で SelfSubjectReview API を試行する（フォールバック）。
- can-i サブコマンドには3つのサブコマンド（can-i, reconcile, whoami）が登録される（auth.go 行36-38）。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 親コマンド構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | auth.go | `staging/src/k8s.io/kubectl/pkg/cmd/auth/auth.go` | NewCmdAuth（行27-41）: 3つのサブコマンド登録 |

#### Step 2: can-i サブコマンドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | cani.go | `staging/src/k8s.io/kubectl/pkg/cmd/auth/cani.go` | CanIOptions（行49-66）: AllNamespaces, Quiet, Verb, Resource, NonResourceURL 等 |
| 2-2 | cani.go | `staging/src/k8s.io/kubectl/pkg/cmd/auth/cani.go` | NewCmdCanI: コマンド定義 |

#### Step 3: reconcile サブコマンドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | reconcile.go | `staging/src/k8s.io/kubectl/pkg/cmd/auth/reconcile.go` | ReconcileOptions（行46-60）: RemoveExtraPermissions, RemoveExtraSubjects 等 |

#### Step 4: whoami サブコマンドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | whoami.go | `staging/src/k8s.io/kubectl/pkg/cmd/auth/whoami.go` | WhoAmIFlags（行46-51）: RESTClientGetter, PrintFlags |

### プログラム呼び出し階層図

```
NewCmdAuth (auth.go 行27)
    |
    +-- NewCmdCanI (cani.go)
    |       +-- Complete -> Validate -> Run
    |       +-- authorizationv1client.SelfSubjectAccessReviews().Create()
    |       +-- or authorizationv1client.SubjectAccessReviews().Create()
    |
    +-- NewCmdReconcile (reconcile.go)
    |       +-- Complete -> Validate -> RunReconcile
    |       +-- reconciliation.RBACRuleOwnerAdapter
    |       +-- reconciliation.ConfirmNoEscalation -> CreateOrUpdate
    |
    +-- NewCmdWhoAmI (whoami.go)
            +-- ToOptions -> Run
            +-- authenticationv1alpha1client -> v1beta1 -> v1 (フォールバック)
```

### データフロー図

```
[can-i]
ユーザー入力 --> Complete(VERB, TYPE解析) --> SelfSubjectAccessReview API --> "yes"/"no"

[reconcile]
RBACファイル --> Builder.Do() --> 各RBACリソース --> reconciliation --> Create/Update

[whoami]
(引数なし) --> SelfSubjectReview API --> Username, Groups, Extra 表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| auth.go | `staging/src/k8s.io/kubectl/pkg/cmd/auth/auth.go` | ソース | auth 親コマンド定義 |
| cani.go | `staging/src/k8s.io/kubectl/pkg/cmd/auth/cani.go` | ソース | can-i サブコマンド |
| reconcile.go | `staging/src/k8s.io/kubectl/pkg/cmd/auth/reconcile.go` | ソース | reconcile サブコマンド |
| whoami.go | `staging/src/k8s.io/kubectl/pkg/cmd/auth/whoami.go` | ソース | whoami サブコマンド |
| rbac/ | `staging/src/k8s.io/component-helpers/auth/rbac/reconciliation/` | ソース | RBAC調整ロジック |
