# 画面設計書 27-kubectl debug

## 概要

本ドキュメントは、Kubernetes CLIツール kubectl の `debug` コマンドに関する画面設計書である。kubectl debug はワークロードとノードのトラブルシューティングのためのデバッグセッションを作成する。

### 本画面の処理概要

kubectl debug コマンドは、インタラクティブなデバッグコンテナを使用してクラスターリソースのトラブルシューティングを自動化する。Podのデフォルトリソースとして動作し、3つのデバッグ戦略をサポートする。

**業務上の目的・背景**：本番環境のワークロードのデバッグにおいて、既存のPodを変更せずにデバッグツールを投入する必要がある。distroless イメージやminimalイメージには通常のデバッグツール（shell, curl等）が含まれていないため、エフェメラルコンテナやPodコピーを使用してデバッグ環境を提供する。

**画面へのアクセス方法**：ターミナルから `kubectl debug <POD|TYPE/NAME>` を実行する。

**主要な操作・処理内容**：
1. **エフェメラルコンテナ追加**: 既存Podにエフェメラルコンテナを追加してデバッグ（`--image` 指定）
2. **Podコピー**: 既存Podのコピーを作成し、属性を変更してデバッグ（`--copy-to` 指定）
3. **ノードデバッグ**: ノードのホスト名前空間で実行されるPodを作成（`node/<name>` 指定）
4. プロファイルに基づくセキュリティコンテキストの自動設定
5. オプションでのアタッチ（`-it` フラグ）

**画面遷移**：debug 実行後、`-it` フラグ指定時は自動的に attach に遷移する。セッション終了後はシェルに戻る。

**権限による表示制御**：pods の create, patch 権限が必要。エフェメラルコンテナの場合は pods/ephemeralcontainers サブリソースの patch 権限が必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 115 | Debug | 主機能 | デバッグセッションの作成と管理 |
| 114 | Attach | 連携 | デバッグコンテナへのアタッチ |

## 画面種別

CLI対話型コマンド（ストリーミング/バッチ）

## URL/ルーティング

```
kubectl debug (POD | TYPE[[.VERSION].GROUP]/NAME) [ -- COMMAND [args...] ]
```

内部的には以下の REST API エンドポイントを使用：
```
PATCH /api/v1/namespaces/{namespace}/pods/{name}/ephemeralcontainers  (エフェメラルコンテナ)
POST  /api/v1/namespaces/{namespace}/pods                             (Podコピー/ノードデバッグ)
```

## 入出力項目

| 項目名 | 種別 | 必須 | 型 | 説明 |
|--------|------|------|-----|------|
| POD / TYPE/NAME | 引数 | Yes | string | デバッグ対象リソース |
| -- COMMAND [args...] | 引数 | No | string[] | デバッグコンテナで実行するコマンド |
| --image | フラグ | 条件付き | string | デバッグコンテナのイメージ（--copy-to未使用時は必須） |
| --container, -c | フラグ | No | string | デバッグコンテナ名 |
| --copy-to | フラグ | No | string | Podコピー名 |
| --replace | フラグ | No | bool | --copy-to 使用時、元のPodを削除 |
| --set-image | フラグ | No | map[string]string | --copy-to 使用時、コンテナイメージを変更 |
| --stdin, -i | フラグ | No | bool | stdinを開放 |
| --tty, -t | フラグ | No | bool | TTYを割り当て |
| --quiet, -q | フラグ | No | bool | 情報メッセージを抑制 |
| --attach | フラグ | No | bool | コンテナへのアタッチ（-i 時はデフォルトtrue） |
| --target | フラグ | No | string | エフェメラルコンテナのターゲットプロセスコンテナ |
| --same-node | フラグ | No | bool | --copy-to使用時、同一ノードにスケジュール |
| --share-processes | フラグ | No | bool | --copy-to使用時、プロセス名前空間を共有（デフォルト: true） |
| --env | フラグ | No | map[string]string | 環境変数の設定 |
| --image-pull-policy | フラグ | No | string | イメージプルポリシー |
| --profile | フラグ | No | string | デバッグプロファイル（general/baseline/restricted/netadmin/sysadmin、デフォルト: general） |
| --custom | フラグ | No | string | カスタムプロファイルファイルパス（JSON/YAML） |
| --keep-labels | フラグ | No | bool | --copy-to使用時、元Podのラベルを保持 |
| --keep-annotations | フラグ | No | bool | --copy-to使用時、元Podのアノテーションを保持 |
| --keep-liveness | フラグ | No | bool | --copy-to使用時、livenessプローブを保持 |
| --keep-readiness | フラグ | No | bool | --copy-to使用時、readinessプローブを保持 |
| --keep-startup | フラグ | No | bool | --copy-to使用時、startupプローブを保持 |
| --keep-init-containers | フラグ | No | bool | --copy-to使用時、initコンテナを実行（デフォルト: true） |
| --arguments-only | フラグ | No | bool | -- 以降をコマンドではなくArgsとして渡す |
| -f | フラグ | No | string[] | リソース指定ファイル |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| コンテナ名メッセージ | "Defaulting debug container name to {name}" |
| Pod作成メッセージ | "Creating debugging pod {name} with container {name} on node {name}" |
| ターゲットメッセージ | "Targeting container {name}" |
| 非rootユーザー警告 | Pod全体に非rootユーザーが設定されている場合の権限に関する警告 |
| プロファイル非推奨警告 | --profile=legacy 使用時の非推奨警告 |
| コンテナ出力 | アタッチ時のコンテナ標準出力 |

## イベント仕様

### 1-エフェメラルコンテナデバッグ

1. Complete: 引数解析、Kubernetes Client 初期化、ProfileApplier 初期化
2. Validate: Image/Container 要件確認、TTY/stdin 整合性
3. Run: Pod取得 -> generateDebugContainer -> Strategic Merge Patch -> (Attach)

### 2-Podコピーデバッグ

1. Complete/Validate: 同上 + --copy-to 固有バリデーション
2. Run: Pod取得 -> generatePodCopyWithDebugContainer -> Pods.Create -> (Attach)

### 3-ノードデバッグ

1. Complete/Validate: 同上
2. Run: Node取得 -> generateNodeDebugPod -> Pods.Create -> (Attach)

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| エフェメラルコンテナ追加 | pods/ephemeralcontainers | PATCH | 既存Podにエフェメラルコンテナを追加 |
| Podコピー作成 | pods | CREATE | 新規Podの作成 |
| Podコピー+置換 | pods | CREATE + DELETE | 新規Pod作成と元Pod削除 |
| ノードデバッグPod作成 | pods | CREATE | ノードデバッグ用Podの作成 |

### テーブル別更新項目詳細

#### pods/ephemeralcontainers (PATCH)
- spec.ephemeralContainers: エフェメラルコンテナの追加

#### pods (CREATE)
- 全フィールド: Podコピーまたはノードデバッグ用Pod

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|------------|------|--------------|----------|
| M-01 | 情報 | "Defaulting debug container name to %s." | コンテナ名未指定時（行874-876） |
| M-02 | 情報 | "Creating debugging pod %s with container %s on node %s." | ノードデバッグ時（行723） |
| M-03 | 情報 | "Targeting container %q..." | --target 指定時（行381） |
| M-04 | 警告 | "Warning: Non-root user is configured..." | Pod全体に非rootユーザー設定ありでcapability追加時（行664） |
| M-05 | エラー | "you must specify --image when not using --copy-to." | --copy-to未使用で--image未指定（行346） |
| M-06 | エラー | "--replace may only be used with --copy-to." | --copy-to無しで--replace指定（行340） |
| M-07 | エラー | "-i/--stdin is required for containers with -t/--tty=true" | -t指定で-i未指定（行388） |
| M-08 | エラー | "NAME or filename is required for debug" | ターゲット名未指定（行357） |
| M-09 | 警告 | "--profile=legacy is deprecated..." | legacyプロファイル使用時（行404） |

## 例外処理

| 例外 | 状態 | 対処 |
|------|------|------|
| EphemeralContainers未対応 | エラー終了 | クラスターが対応していない旨のエラーを表示（行519） |
| 不正イメージ名 | エラー終了 | イメージ名のバリデーションエラーを表示（行351-353） |
| 不正プルポリシー | エラー終了 | サポートされていないプルポリシーのエラーを表示（行361-366） |
| --target と --copy-to の同時指定 | エラー終了 | 非互換のエラーを表示（行377-379） |
| カスタムプロファイルに不正フィールド | エラー終了 | name, command, image, lifecycle, volumeDevices は変更不可のエラー（行397-399） |
| アタッチ失敗 | フォールバック | ログ表示にフォールバック（行994-997） |

## 備考

- プロファイルは general, baseline, restricted, netadmin, sysadmin, legacy の6種類をサポート。generalがデフォルト（行216）。
- legacyプロファイルはv1.39で削除予定（行404）。
- ノードデバッグPodはホストPID/Network/IPC名前空間で実行され、/hostにノードのファイルシステムがマウントされる（行708-710）。
- ノードデバッグPodには `app.kubernetes.io/managed-by: kubectl-debug` ラベルが付与される（行729-731）。
- ShareProcesses のデフォルトは true（行167）。
- KeepInitContainers のデフォルトは true（行165）。
- --custom フラグで JSON/YAML ファイルによるコンテナスペックのカスタマイズが可能（行289-302）。ただし name, command, image, lifecycle, volumeDevices は変更不可。
- アタッチ先コンテナが既に終了している場合、ログ表示にフォールバックする（行989-997）。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | debug.go | `staging/src/k8s.io/kubectl/pkg/cmd/debug/debug.go` | DebugOptions（行116-158）: Attach, CopyTo, Replace, Image, Profile, CustomProfile 等 |
| 1-2 | debug.go | `staging/src/k8s.io/kubectl/pkg/cmd/debug/debug.go` | DebugAttachFunc type（行113）: アタッチ関数の型定義 |

**読解のコツ**: DebugOptions は非常に多くのフィールドを持つ。主要な分岐は CopyTo の有無（Podコピー vs エフェメラル）と、対象がNode か Pod かで決まる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | debug.go | `staging/src/k8s.io/kubectl/pkg/cmd/debug/debug.go` | NewCmdDebug（行172-190）: コマンド定義 |
| 2-2 | debug.go | `staging/src/k8s.io/kubectl/pkg/cmd/debug/debug.go` | AddFlags（行192-218）: 26個のフラグ登録 |

#### Step 3: 3つのデバッグ戦略を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | debug.go | `staging/src/k8s.io/kubectl/pkg/cmd/debug/debug.go` | Run（行411-456）: Builder -> Visit -> Node/Pod 分岐 |
| 3-2 | debug.go | `staging/src/k8s.io/kubectl/pkg/cmd/debug/debug.go` | visitNode（行460-472）: ノードデバッグPod生成 |
| 3-3 | debug.go | `staging/src/k8s.io/kubectl/pkg/cmd/debug/debug.go` | visitPod（行479-484）: CopyTo有無で分岐 |
| 3-4 | debug.go | `staging/src/k8s.io/kubectl/pkg/cmd/debug/debug.go` | debugByEphemeralContainer（行487-526）: エフェメラルコンテナ追加 |
| 3-5 | debug.go | `staging/src/k8s.io/kubectl/pkg/cmd/debug/debug.go` | debugByCopy（行613-639）: Podコピー作成 |
| 3-6 | debug.go | `staging/src/k8s.io/kubectl/pkg/cmd/debug/debug.go` | generateNodeDebugPod（行710-773）: ノードデバッグPod生成 |

#### Step 4: プロファイルとカスタマイズを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | debug.go | `staging/src/k8s.io/kubectl/pkg/cmd/debug/debug.go` | Applier.Apply（行692, 761, 850）: プロファイル適用 |
| 4-2 | debug.go | `staging/src/k8s.io/kubectl/pkg/cmd/debug/debug.go` | applyCustomProfile（行530-568）: カスタムプロファイル適用 |

### プログラム呼び出し階層図

```
NewCmdDebug (行172)
    |
    +-- Complete (行221)
    |       +-- PullPolicy, Env, Namespace 取得
    |       +-- NewProfileApplier (行282)
    |       +-- CustomProfile 読み込み (行289-302)
    |       +-- kubernetes.NewForConfig -> podClient (行314)
    |
    +-- Validate (行322)
    |       +-- Attach/Image/CopyTo 整合性チェック
    |       +-- Image format 検証 (reference.ReferenceRegexp)
    |       +-- TTY/stdin 整合性
    |
    +-- Run (行411)
            |
            +-- Builder.Do().Visit()
            |
            +-- [Node の場合]
            |       visitNode (行460)
            |       +-- generateNodeDebugPod (行710)
            |       +-- Pods.Create
            |
            +-- [Pod の場合]
                    visitPod (行479)
                    |
                    +-- [CopyTo あり]
                    |       debugByCopy (行613)
                    |       +-- generatePodCopyWithDebugContainer (行776)
                    |       +-- Pods.Create
                    |       +-- (--replace: Pods.Delete)
                    |
                    +-- [CopyTo なし]
                            debugByEphemeralContainer (行487)
                            +-- generateDebugContainer (行669)
                            +-- strategicpatch.CreateTwoWayMergePatch
                            +-- Pods.Patch (ephemeralcontainers)
            |
            +-- [Attach=true]
                    AttachFunc -> handleAttachPod (行952)
                    +-- waitForContainer (行898)
                    +-- attach.AttachOptions.Run()
                    +-- (Terminated: logOpts fallback)
```

### データフロー図

```
[入力]                    [処理]                           [出力]

ユーザー引数             Complete
(POD/Node, フラグ) ---> (Client初期化, Profile設定)
                              |
                         Validate
                         (整合性チェック)
                              |
                         Run
                         (Builder.Visit)
                              |
                    +----+----+----+
                    |              |
               [Node]         [Pod]
                    |              |
              visitNode      visitPod
                    |         /         \
         generateNodePod  [CopyTo]   [Ephemeral]
                    |         |           |
              Pod CREATE  Pod CREATE  Pod PATCH
                    |         |           |
                    +----+----+----+------+
                              |
                    [Attach=true の場合]
                              |
                    waitForContainer
                              |
                    attach (stdin/stdout)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| debug.go | `staging/src/k8s.io/kubectl/pkg/cmd/debug/debug.go` | ソース | debug コマンドの主実装 |
| profiles.go | `staging/src/k8s.io/kubectl/pkg/cmd/debug/profiles.go` | ソース | デバッグプロファイル定義 |
| attach.go | `staging/src/k8s.io/kubectl/pkg/cmd/attach/attach.go` | ソース | アタッチ機能 |
| exec.go | `staging/src/k8s.io/kubectl/pkg/cmd/exec/exec.go` | ソース | StreamOptions 構造体 |
| logs.go | `staging/src/k8s.io/kubectl/pkg/cmd/logs/logs.go` | ソース | ログフォールバック |
| debug_test.go | `staging/src/k8s.io/kubectl/pkg/cmd/debug/debug_test.go` | テスト | debug コマンドのユニットテスト |
