# 画面設計書 28-kubectl events

## 概要

本ドキュメントは、Kubernetes CLIツール kubectl の `events` コマンドに関する画面設計書である。kubectl events はクラスターのイベントを一覧表示する機能を提供する。

### 本画面の処理概要

kubectl events コマンドは、Kubernetes クラスター内のイベントリソースを取得し、テーブル形式または指定の出力形式で表示する。ウォッチモードでのリアルタイム監視もサポートする。

**業務上の目的・背景**：クラスターの状態変化や問題の診断において、イベントは最も重要な情報源の一つである。Pod のスケジューリング失敗、イメージプルエラー、リソース制限到達、OOMKill 等、さまざまな問題をイベント経由で把握できる。

**画面へのアクセス方法**：ターミナルから `kubectl events` を実行する。

**主要な操作・処理内容**：
1. 指定namespace（またはall-namespaces）のイベント取得
2. リソースフィルタリング（`--for TYPE/NAME`）
3. イベントタイプフィルタリング（`--types Normal,Warning`）
4. 時系列ソート
5. ウォッチモードでの継続監視

**画面遷移**：単独で使用される。ウォッチモードでは Ctrl+C で終了。

**権限による表示制御**：events リソースの list/watch 権限が必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 93 | イベント一覧（events） | 主機能 | イベントの取得と表示 |

## 画面種別

CLI出力コマンド（バッチ/ウォッチ）

## URL/ルーティング

```
kubectl events [(-o|--output=)FORMAT] [--for TYPE/NAME] [--watch] [--types=Normal,Warning]
```

内部的には以下の REST API エンドポイントを使用：
```
GET   /api/v1/namespaces/{namespace}/events           (一覧)
GET   /api/v1/namespaces/{namespace}/events?watch=true (ウォッチ)
GET   /api/v1/events                                   (全namespace)
```

## 入出力項目

| 項目名 | 種別 | 必須 | 型 | 説明 |
|--------|------|------|-----|------|
| --watch, -w | フラグ | No | bool | イベントをウォッチする |
| --all-namespaces, -A | フラグ | No | bool | 全namespaceのイベントを表示 |
| --for | フラグ | No | string | 特定リソースのイベントをフィルタ（TYPE/NAME形式） |
| --types | フラグ | No | string[] | イベントタイプフィルタ（Normal, Warning） |
| --no-headers | フラグ | No | bool | ヘッダーを非表示 |
| -o, --output | フラグ | No | string | 出力形式（yaml, json等） |
| --chunk-size | フラグ | No | int64 | チャンクサイズ（デフォルト: 500） |

## 表示項目

### デフォルトテーブル出力
| 列名 | 説明 |
|------|------|
| LAST SEEN | 最終観測時刻 |
| TYPE | イベントタイプ（Normal/Warning） |
| REASON | イベント理由 |
| OBJECT | 関連オブジェクト |
| MESSAGE | イベントメッセージ |

### all-namespaces 時の追加列
| 列名 | 説明 |
|------|------|
| NAMESPACE | イベントのnamespace |

## イベント仕様

### 1-イベント一覧表示

1. ToOptions: フラグからオプション変換、Client初期化、Printer初期化
2. Validate: FilterTypes の値チェック（Normal/Warning のみ許可）
3. Run: Events.List -> フィルタリング -> ソート -> テーブル出力

### 2-イベントウォッチ

1. ToOptions/Validate: 同上
2. Run -> runWatch: Events.Watch -> UntilWithoutRetry -> フィルタ -> 出力

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| events実行 | events | SELECT | イベントリソースの読み取り |

kubectl events は読み取り専用コマンドである。

### テーブル別更新項目詳細

該当なし

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|------------|------|--------------|----------|
| M-01 | 情報 | "No events found." | 全namespaceでイベントなし（行278） |
| M-02 | 情報 | "No events found in %s namespace." | 特定namespaceでイベントなし（行280） |
| M-03 | エラー | "valid --types are Normal or Warning" | 不正なタイプ指定（行213） |
| M-04 | エラー | "--for must be in resource/name form" | --for の形式不正（行176） |

## 例外処理

| 例外 | 状態 | 対処 |
|------|------|------|
| 不正なタイプ指定 | エラー終了 | Normal/Warning のみ許可のエラーを表示 |
| --for 形式不正 | エラー終了 | resource/name 形式必須のエラーを表示 |
| イベントなし | 正常終了 | "No events found" メッセージを stderr に出力 |

## 備考

- イベントは Kubernetes API サーバーにより1時間後に自動削除される。ウォッチモードではこの削除イベント（watch.Deleted）は表示しない（行306）。
- SortableEvents によるソートは、Series.LastObservedTime -> LastTimestamp -> EventTime の優先順で行われる（行366-374）。
- --for フラグは FieldSelector（involvedObject.kind, involvedObject.apiVersion, involvedObject.name）を使用してサーバー側フィルタリングを行う（行229-233）。
- FollowContinue によるページネーション対応（行246-254）。
- デフォルトのチャンクサイズは cmdutil.DefaultChunkSize（500）（行97）。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | events.go | `staging/src/k8s.io/kubectl/pkg/cmd/events/events.go` | EventsFlags（行78-89）: CLI入力の直接反映 |
| 1-2 | events.go | `staging/src/k8s.io/kubectl/pkg/cmd/events/events.go` | EventsOptions（行103-117）: ランタイムオプション |

**読解のコツ**: Flags -> Options パターン。EventsFlags がCLI入力を受け、ToOptions で EventsOptions に変換される。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | events.go | `staging/src/k8s.io/kubectl/pkg/cmd/events/events.go` | NewCmdEvents（行120-139）: コマンド定義 |

#### Step 3: イベント取得と表示を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | events.go | `staging/src/k8s.io/kubectl/pkg/cmd/events/events.go` | Run（行222-292）: イベント一覧取得、フィルタ、ソート、出力 |
| 3-2 | events.go | `staging/src/k8s.io/kubectl/pkg/cmd/events/events.go` | runWatch（行294-329）: ウォッチモード |
| 3-3 | events.go | `staging/src/k8s.io/kubectl/pkg/cmd/events/events.go` | SortableEvents（行350-374）: ソートロジック |
| 3-4 | events.go | `staging/src/k8s.io/kubectl/pkg/cmd/events/events.go` | decodeResourceTypeName（行380-410）: --for 引数の解析 |

### プログラム呼び出し階層図

```
NewCmdEvents (行120)
    |
    +-- EventsFlags.ToOptions (行152)
    |       +-- Namespace取得
    |       +-- --for 解析 (decodeResourceTypeName)
    |       +-- kubernetes.NewForConfig -> client
    |       +-- Printer初期化
    |
    +-- EventsOptions.Validate (行211)
    |
    +-- EventsOptions.Run (行222)
            |
            +-- [Watch=false]
            |       +-- FollowContinue (行246)
            |       |       +-- Events.List (ページネーション)
            |       +-- filteredEventType (行260-272)
            |       +-- sort.Sort(SortableEvents) (行287)
            |       +-- PrintObj (行289)
            |
            +-- [Watch=true]
                    +-- runWatch (行294)
                            +-- Events.Watch (行295)
                            +-- UntilWithoutRetry (行305)
                                    +-- filteredEventType
                                    +-- PrintObj
```

### データフロー図

```
[入力]                    [処理]                           [出力]

ユーザーフラグ           ToOptions
(--for, --types) -----> (Client初期化, Printer初期化)
                              |
                         Validate
                         (types チェック)
                              |
                    +----+----+
                    |              |
              [一覧]          [ウォッチ]
                    |              |
              Events.List    Events.Watch
              (ページネーション)    |
                    |         UntilWithoutRetry
              フィルタリング   (イベント受信)
              (filteredEventType)    |
                    |         フィルタリング
              ソート              |
              (SortableEvents)    |
                    |              |
              PrintObj -------> テーブル出力 or YAML/JSON
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| events.go | `staging/src/k8s.io/kubectl/pkg/cmd/events/events.go` | ソース | events コマンドの主実装 |
| event_printer.go | `staging/src/k8s.io/kubectl/pkg/cmd/events/event_printer.go` | ソース | イベントテーブルプリンター |
| events_test.go | `staging/src/k8s.io/kubectl/pkg/cmd/events/events_test.go` | テスト | ユニットテスト |
