# 画面設計書 3-kubectl run

## 概要

本ドキュメントは、Kubernetes CLIツール `kubectl` の `run` コマンドに関する画面設計書である。`kubectl run` は指定したコンテナイメージからPodを作成し、クラスタ上で実行するコマンドである。

### 本画面の処理概要

`kubectl run` コマンドは、指定されたコンテナイメージを使用してPodリソースを生成し、Kubernetes API Serverを通じてクラスタ上で実行する。対話的なセッション、アタッチ機能、自動的なService公開機能も提供する。

**業務上の目的・背景**：マニフェストファイルを作成せずに、コマンドラインから直接コンテナイメージを指定してPodを起動する。開発・デバッグ・テスト時のワンショット実行や、対話的なシェルセッションの起動に利用される。`docker run` に類似した操作感を提供する。

**画面へのアクセス方法**：ターミナルから `kubectl run <name> --image=<image> [options]` の形式で実行する。

**主要な操作・処理内容**：
1. 指定イメージでPodを作成（`kubectl run nginx --image=nginx`）
2. 環境変数の設定（`--env`）
3. ラベルの設定（`--labels`）
4. 対話的セッション（`-i -t` でstdin/ttyを有効化）
5. Podへの自動アタッチ（`--attach` または `-i` 指定時）
6. Podの自動削除（`--rm`、アタッチ時のみ有効）
7. Serviceの自動作成（`--expose --port`）
8. リスタートポリシーの設定（Always/OnFailure/Never）
9. 特権コンテナの実行（`--privileged`）
10. コマンドのオーバーライド（`--command -- <cmd> <args>`）

**画面遷移**：本コマンドはBasic Commands (Beginner)カテゴリに属する。`--attach` フラグ指定時は内部的に `kubectl attach` と同等の処理が呼び出される。`--expose` フラグ指定時はServiceも自動作成される。終了後は `kubectl get pods` で作成されたPodを確認可能。

**権限による表示制御**：Podの作成権限が必要。`--expose` 使用時はService作成権限も必要。`--privileged` はPodSecurityPolicyまたはPod Security Standardの制約を受ける。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 98 | Pod実行（run） | 主機能 | 指定したコンテナイメージでPodを実行する主処理 |
| 1 | API Serverコア | API連携 | Pod作成リクエストをAPI Serverに送信する |
| 114 | Attach | 遷移先機能 | --attachフラグ指定時に作成したPodの標準入出力にアタッチする |

## 画面種別

CLIコマンド（リソース作成・実行）

## URL/ルーティング

```
kubectl run NAME --image=image [--env="key=value"] [--port=port] [--dry-run=server|client] [--overrides=inline-json] [--command] -- [COMMAND] [args...]
```

## 入出力項目

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| NAME | string | Yes | Pod名 |
| --image | string | Yes | コンテナイメージ |
| --port | string | No | コンテナが公開するポート |
| --env | string[] | No | 環境変数（KEY=VALUE形式） |
| -l, --labels | string | No | ラベル（カンマ区切り） |
| -i, --stdin | bool | No | stdinを開いたままにする |
| -t, --tty | bool | No | TTYを割り当てる |
| --attach | bool | No | Podにアタッチする（-i指定時は自動的にtrue） |
| --rm | bool | No | 終了後にPodを削除（アタッチ時のみ） |
| --restart | string | No | リスタートポリシー（Always/OnFailure/Never、デフォルト: Always） |
| --expose | bool | No | ClusterIP Serviceも作成する（--port必須） |
| --privileged | bool | No | 特権モードで実行 |
| --command | bool | No | 追加引数をコマンドとして使用 |
| --image-pull-policy | string | No | イメージプルポリシー（Always/IfNotPresent/Never） |
| --overrides | string | No | JSON形式でspecをオーバーライド |
| --annotations | string[] | No | Podに付与するアノテーション |
| --dry-run | string | No | ドライランモード |
| --pod-running-timeout | duration | No | Podの起動待ちタイムアウト（デフォルト: 60秒） |
| -q, --quiet | bool | No | 情報メッセージを抑制 |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| Pod作成結果 | `pod/<name> created` の形式 |
| コンテナ出力 | アタッチ時のstdout/stderr出力 |
| Service作成結果 | `--expose` 時の `service/<name> created` |

## イベント仕様

### 1-通常実行

1. ユーザーが `kubectl run <name> --image=<image>` を実行
2. `RunOptions.Complete()` でオプション完了（行197-243）
3. `RunOptions.Run()` で以下を実行（行245-413）:
   a. イメージ名のバリデーション（行257-263）
   b. リスタートポリシーの取得（行276）
   c. ジェネレータでPodオブジェクトを生成（行294-305）
   d. `createGeneratedObject()` でAPI ServerにPodを作成（行311-312）
   e. 結果を出力（行407-409）

### 2-アタッチモード実行

1. ユーザーが `kubectl run -it <name> --image=<image>` を実行
2. `-i` 指定により `Attach` が自動的にtrue（行216-219）
3. Pod作成後、`handleAttachPod()` でPodの起動を待機（行471-510）
4. `waitForPod()` でPodがRunning状態になるまで監視（行442-469）
5. `attach.AttachOptions.Run()` でアタッチ実行
6. `--rm` 指定時は終了後にPodを自動削除（行328-329）

### 3-expose付き実行

1. ユーザーが `kubectl run <name> --image=<image> --expose --port=<port>` を実行
2. Pod作成後、`generateService()` でServiceを自動生成（行319-324, 570-614）
3. ServiceジェネレータでServiceオブジェクトを作成しAPI Serverに送信

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| Pod作成 | etcd（Pod） | INSERT | Podリソースをetcdに永続化 |
| Service作成 | etcd（Service） | INSERT | --expose時のServiceリソース作成 |
| Pod削除 | etcd（Pod） | DELETE | --rm時の終了後のPod削除 |

## メッセージ仕様

| 種別 | メッセージ | 条件 |
|------|-----------|------|
| 成功 | `pod/<name> created` | Podが正常に作成された場合 |
| 成功 | `service/<name> created` | --expose時にServiceが作成された場合 |
| エラー | `NAME is required for run` | Pod名が指定されていない場合 |
| エラー | `--image is required` | --imageが指定されていない場合 |
| エラー | `Invalid image name "<name>"` | イメージ名が不正な場合 |
| エラー | `-i/--stdin is required for containers with -t/--tty=true` | -tのみ指定で-iなしの場合 |
| エラー | `--port must be set when exposing a service` | --expose時に--portがない場合 |
| エラー | `--rm should only be used for attached containers` | --rm使用時にアタッチなしの場合 |
| エラー | `--dry-run can't be used with attached containers options` | ドライランとアタッチの同時指定 |
| エラー | `invalid restart policy: <value>` | 不正なリスタートポリシー |
| エラー | `invalid image pull policy: <value>` | 不正なイメージプルポリシー |

## 例外処理

| 例外条件 | 動作 |
|----------|------|
| Pod起動タイムアウト | タイムアウトエラーを表示して終了 |
| Podが失敗で終了 | 終了コードとエラー理由を表示 |
| アタッチ失敗 | ログストリーミングにフォールバック |
| API Server接続不可 | 接続エラーを表示して終了 |

## 備考

- `kubectl run` はPodを直接作成する。Deploymentを作成する場合は `kubectl create deployment` を使用する。
- アタッチモードでは、Podの起動をwatch APIで監視し、Running状態になるまで待機する。
- `--rm` フラグはアタッチモードでのみ有効。非アタッチモードで使用するとエラーとなる。
- イメージ名のバリデーションには `reference.ReferenceRegexp` が使用される。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | run.go | `staging/src/k8s.io/kubectl/pkg/cmd/run/run.go` | `RunOptions` 構造体（行104-134）: Attach, Interactive, TTY, LeaveStdinOpen等のフラグ |
| 1-2 | run.go | `staging/src/k8s.io/kubectl/pkg/cmd/run/run.go` | `RunObject` 構造体（行99-102）: 作成されたオブジェクトとそのRESTマッピングを保持 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | run.go | `staging/src/k8s.io/kubectl/pkg/cmd/run/run.go` | `NewCmdRun()` 関数（行148-172）: フラグ登録、特に`addRunFlags()`（行174-195）での多数のフラグ定義 |

#### Step 3: メイン処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | run.go | `staging/src/k8s.io/kubectl/pkg/cmd/run/run.go` | `Run()` メソッド（行245-413）: バリデーション、Pod生成、アタッチ、expose、結果出力 |
| 3-2 | run.go | `staging/src/k8s.io/kubectl/pkg/cmd/run/run.go` | `handleAttachPod()` 関数（行471-510）: アタッチ処理の実装 |
| 3-3 | run.go | `staging/src/k8s.io/kubectl/pkg/cmd/run/run.go` | `waitForPod()` 関数（行442-469）: watch APIによるPod状態監視 |

### プログラム呼び出し階層図

```
NewCmdRun()
    |
    +-- RunOptions.Complete()
    |
    +-- RunOptions.Run()
            |
            +-- バリデーション（image, tty, expose, rm, dry-run等）
            +-- generateversioned.GeneratorFn("run")
            +-- createGeneratedObject()
            |       +-- generate.ValidateParams()
            |       +-- generator.Generate()
            |       +-- Overrider.Apply()
            |       +-- resource.NewHelper().Create()
            |
            +-- [--expose] generateService()
            |       +-- generateversioned.GeneratorFn("expose")
            |       +-- createGeneratedObject()
            |
            +-- [--attach] handleAttachPod()
                    +-- waitForPod() (podRunningAndReady)
                    +-- logOpts() (pre-attach logs)
                    +-- attach.AttachOptions.Run()
                    +-- [--rm] removeCreatedObjects()
                    +-- waitForPod() (podCompleted/podSucceeded)
```

### データフロー図

```
[入力]                          [処理]                              [出力]

--image, --env等  ───────▶  Generator.Generate()   ───▶  corev1.Pod
                               |
                               v
                         resource.NewHelper().Create() ───▶  API Server (etcd)
                               |
                               v
                         [--attach] waitForPod()      ───▶  Pod Running
                               |
                               v
                         attach.Run()                 ───▶  stdin/stdout接続
                               |
                               v
                         [--rm] removeCreatedObjects() ───▶  Pod削除
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| run.go | `staging/src/k8s.io/kubectl/pkg/cmd/run/run.go` | ソース | runコマンドの主処理 |
| attach.go | `staging/src/k8s.io/kubectl/pkg/cmd/attach/attach.go` | ソース | アタッチ機能 |
| exec.go | `staging/src/k8s.io/kubectl/pkg/cmd/exec/exec.go` | ソース | StreamOptions定義 |
| logs.go | `staging/src/k8s.io/kubectl/pkg/cmd/logs/logs.go` | ソース | ログ出力（pre-attach logs） |
| delete.go | `staging/src/k8s.io/kubectl/pkg/cmd/delete/delete.go` | ソース | --rm時のPod削除 |
| versioned/generate.go | `staging/src/k8s.io/kubectl/pkg/generate/versioned/` | ソース | Podジェネレータ |
