# 画面設計書 32-kubectl replace

## 概要

本ドキュメントは、Kubernetes CLIツール `kubectl` の `replace` コマンドに関する画面設計書である。`kubectl replace` は、マニフェストファイルまたは標準入力の内容でKubernetesリソース全体を置換（PUT操作）するコマンドである。

### 本画面の処理概要

**業務上の目的・背景**：Kubernetesリソースの完全な更新が必要な場合に使用する。`kubectl apply`による宣言的管理とは異なり、リソースの全スペックを明示的に指定して置き換える命令的な操作を行う。既存のリソース状態を完全に新しい定義で上書きするため、`kubectl get -o yaml` で取得したリソース定義を編集して適用する運用フローで利用されることが多い。`--force` フラグによる強制置換（削除+再作成）も可能である。

**画面へのアクセス方法**：ターミナルから `kubectl replace -f FILENAME` コマンドを実行する。ファイルまたは標準入力からリソース定義を読み込む必要があり、ファイル指定は必須である。

**主要な操作・処理内容**：
1. マニフェストファイルの読み込みとバリデーション
2. リソースのPUT操作によるAPI Serverへの全体置換リクエスト
3. `--force` フラグによる削除+再作成の強制置換
4. `--raw` フラグによるRAW URI直接PUT
5. DryRunモード（client/server）でのシミュレーション実行
6. サブリソースの置換（`--subresource` 指定時）

**画面遷移**：kubectl replaceは単独で完結するコマンドである。典型的なワークフローとして `kubectl get TYPE NAME -o yaml > file.yaml` -> 編集 -> `kubectl replace -f file.yaml` のパターンがある。

**権限による表示制御**：リソースの置換にはRBACにおける `update` 権限が必要。`--force` 使用時はさらに `delete` と `create` 権限が必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 107 | リソース置換（replace） | 主機能 | マニフェストでリソース全体を置換する主処理 |
| 1 | API Serverコア | API連携 | リソース置換（PUT）リクエストをAPI Serverに送信する |

## 画面種別

CLI コマンド（リソース置換操作）

## URL/ルーティング

```
kubectl replace -f FILENAME
```

コマンドエントリーポイント: `staging/src/k8s.io/kubectl/pkg/cmd/replace/replace.go` の `NewCmdReplace` 関数（行111）

## 入出力項目

### 入力パラメータ（フラグ）

| パラメータ名 | 短縮形 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|--------|-----|------|-------------|------|
| -f / --filename | -f | []string | Yes | - | 置換するリソース定義を含むファイル |
| --force | - | bool | No | false | trueの場合、リソースを削除して再作成する |
| --grace-period | - | int | No | -1 | 強制削除時の猶予期間（秒） |
| --cascade | - | string | No | "background" | 強制削除時のカスケード戦略 |
| --timeout | - | duration | No | 0 | 強制削除時の待機タイムアウト |
| --raw | - | string | No | "" | サーバーへの直接PUT用Raw URI |
| --dry-run | - | string | No | "none" | DryRun戦略（none / client / server） |
| --validate | - | string | No | "strict" | バリデーションディレクティブ |
| --save-config | - | bool | No | false | 現在の設定をアノテーションに保存 |
| --subresource | - | string | No | "" | 操作対象のサブリソース |
| --field-manager | - | string | No | "kubectl-replace" | フィールドマネージャー名 |
| -o / --output | -o | string | No | "" | 出力形式（json / yaml / name 等） |
| -R / --recursive | -R | bool | No | false | ディレクトリの再帰処理 |
| -k / --kustomize | -k | string | No | "" | Kustomizeディレクトリ |

## 表示項目

### 成功時の出力

| 項目 | 形式 | 説明 |
|------|------|------|
| リソース種別/名前 | テキスト | 置換後のリソース情報（例: `pod/mypod replaced`） |

## イベント仕様

### 1-通常置換（非force）

1. ファイルからリソース定義を読み込み（行268-276）
2. `resource.Builder` でリソース情報を構築
3. バリデーション実行（`Schema.Validate`）
4. `CreateOrUpdateAnnotation` で設定アノテーションの処理（行286）
5. `resource.Helper.Replace` でAPI ServerにPUTリクエスト送信（行299-305）
6. 結果の出力（行311）

### 2-強制置換（--force）

1. stdin使用時は一時ファイルに保存（行317-332）
2. `resource.Builder` でリソース情報を構築（行334-341）
3. `DeleteOptions.DeleteResult` で既存リソース削除（行350）
4. リソース削除完了をポーリングで待機（行358-368、タイムアウト5分）
5. 再度 `resource.Builder` で新規リソースを構築（行373-380）
6. `resource.Helper.Create` で新規リソースを作成（行404-407）

### 3-Raw URI置換

1. RESTClient取得（行257-260）
2. `rawhttp.RawPut` でURIに直接PUT（行261）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 通常置換 | etcd（対象リソース） | UPDATE（PUT） | リソース全体を新しい定義で置換 |
| 強制置換（削除） | etcd（対象リソース） | DELETE | 既存リソースを削除 |
| 強制置換（作成） | etcd（対象リソース） | INSERT（CREATE） | 新しいリソース定義で再作成 |

### テーブル別更新項目詳細

#### etcd（対象Kubernetesリソース）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | リソース全体 | マニフェストファイルの内容 | PUT操作のため全フィールドが上書き |
| UPDATE | metadata.annotations | --save-config指定時にlast-applied-configuration追加 | オプション |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|--------------|----------|
| MSG-R01 | 成功 | `{type}/{name} replaced` | リソースが正常に置換された場合 |
| MSG-R02 | エラー | `--grace-period must have --force specified` | --grace-periodを--forceなしで指定 |
| MSG-R03 | エラー | `--timeout must have --force specified` | --timeoutを--forceなしで指定 |
| MSG-R04 | エラー | `--dry-run can not be used when --force is set` | --dry-runと--forceの同時指定 |
| MSG-R05 | エラー | `must specify --filename to replace` | ファイル未指定 |
| MSG-R06 | エラー | `--raw can only use a single local file or stdin` | --rawで複数ファイル指定 |
| MSG-R07 | エラー | `--raw cannot read from a url` | --rawでURLファイル指定 |
| MSG-R08 | エラー | `--raw and --recursive are mutually exclusive` | --rawと--recursiveの同時指定 |
| MSG-R09 | エラー | `--raw and --output are mutually exclusive` | --rawと--outputの同時指定 |
| MSG-R10 | エラー | `--raw must be a valid URL path: {error}` | 無効なRaw URI |
| MSG-R11 | エラー | `no objects passed to replace` | 置換対象リソースが0件 |

## 例外処理

| 例外 | 発生条件 | 処理内容 |
|------|----------|----------|
| 権限不足（Forbidden） | RBACでupdate/delete/create権限がない | API Serverからのエラーメッセージを表示 |
| リソース未発見（NotFound） | 通常置換で対象リソースが存在しない | API Serverからの404エラーを表示 |
| コンフリクト（Conflict） | resourceVersionが不一致 | 競合エラーメッセージを表示 |
| バリデーションエラー | マニフェストがスキーマに違反 | バリデーションエラーを表示 |
| 強制削除タイムアウト | --force時に削除完了を5分以内に確認できない | タイムアウトエラーを表示 |

## 備考

- `kubectl replace` は命令的なリソース管理手法であり、宣言的管理には `kubectl apply` が推奨される。
- `--force` フラグは実質的に「削除+作成」であり、一時的にリソースが存在しない期間が発生する点に注意。
- `--grace-period=0` が指定された場合、後方互換性のため内部的に `--grace-period=1` に変換され、削除完了を待機する（行185-190）。
- `--raw` フラグは高度な用途向けで、API Serverの任意のエンドポイントに対してPUTリクエストを送信できる。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | replace.go | `staging/src/k8s.io/kubectl/pkg/cmd/replace/replace.go` | ReplaceOptions構造体（行71-100）のフィールド構成を理解 |

**読解のコツ**: `DeleteFlags` / `DeleteOptions` がforce replace時に使用される。通常replaceとforce replaceで異なるフローを取る点に注目。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | replace.go | `staging/src/k8s.io/kubectl/pkg/cmd/replace/replace.go` | NewCmdReplace関数（行111-140）のコマンド定義とフラグ登録 |

**主要処理フロー**:
1. **行111**: `NewCmdReplace` - cobraコマンド生成
2. **行120-124**: Run関数 - Complete -> Validate -> Runの順
3. **行127-137**: フラグ登録

#### Step 3: Run - メイン処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | replace.go | `staging/src/k8s.io/kubectl/pkg/cmd/replace/replace.go` | Run関数（行253-313）- Raw/Force/通常の3パターン分岐 |
| 3-2 | replace.go | `staging/src/k8s.io/kubectl/pkg/cmd/replace/replace.go` | forceReplace関数（行315-423）- 削除+待機+再作成フロー |

**主要処理フロー**:
- **行256-261**: Raw URI処理
- **行264-265**: force replace分岐
- **行268-312**: 通常replace（Builder -> Visit -> Helper.Replace）
- **行350**: force時の既存リソース削除
- **行362-367**: 削除完了ポーリング（1秒間隔、5分タイムアウト）
- **行404-407**: 新規リソース作成

### プログラム呼び出し階層図

```
NewCmdReplace (行111)
    │
    ├─ Complete (行142)
    │      ├─ RecordFlags.Complete
    │      ├─ DeleteFlags.ToOptions
    │      └─ f.Validator (スキーマバリデータ取得)
    │
    ├─ Validate (行215)
    │      └─ パラメータ整合性チェック
    │
    └─ Run (行253)
           ├─ [Raw] rawhttp.RawPut (行261)
           │
           ├─ [Force] forceReplace (行265)
           │      ├─ DeleteOptions.DeleteResult (行350)
           │      ├─ wait.PollUntilContextTimeout (行362)
           │      └─ Helper.Create (行407)
           │
           └─ [通常] builder.Do() (行268-276)
                  └─ r.Visit()
                         ├─ CreateOrUpdateAnnotation (行286)
                         ├─ Recorder.Record (行290)
                         └─ Helper.Replace (行305)
```

### データフロー図

```
[入力]                          [処理]                              [出力]

マニフェストファイル        ┌──────────────────┐
(-f FILENAME) ────────────▶│ resource.Builder  │
                          │ + Schema Validate │
                          └────────┬─────────┘
                                   │
                          ┌────────▼─────────┐
                          │  実行モード判定    │
                          │ Raw/Force/通常    │
                          └────────┬─────────┘
                    ┌──────────────┼──────────────┐
                    │              │              │
           ┌───────▼───────┐ ┌───▼──────┐ ┌────▼──────┐
           │ rawhttp.RawPut│ │forceRepl.│ │Helper.    │
           │               │ │Delete→   │ │Replace    │
           │               │ │Wait→     │ │(PUT)      │
           │               │ │Create    │ │           │
           └───────┬───────┘ └───┬──────┘ └────┬──────┘
                   └──────────────┼──────────────┘
                                  │
                         ┌────────▼────────┐
                         │ PrintObj        │──────▶ 標準出力
                         └─────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| replace.go | `staging/src/k8s.io/kubectl/pkg/cmd/replace/replace.go` | ソース | replaceコマンドのメイン実装（424行） |
| delete.go | `staging/src/k8s.io/kubectl/pkg/cmd/delete/delete.go` | ソース | force replace時のDeleteOptionsの参照元 |
| rawhttp.go | `staging/src/k8s.io/kubectl/pkg/rawhttp/rawhttp.go` | ソース | Raw HTTP PUT処理 |
| helper.go | `staging/src/k8s.io/cli-runtime/pkg/resource/helper.go` | ソース | Replace/Create APIヘルパー |
| validation.go | `staging/src/k8s.io/kubectl/pkg/validation/validation.go` | ソース | スキーマバリデーション |
| util.go | `staging/src/k8s.io/kubectl/pkg/util/util.go` | ソース | CreateOrUpdateAnnotationユーティリティ |
