# 画面設計書 34-kubectl kustomize

## 概要

本ドキュメントは、Kubernetes CLIツール `kubectl` の `kustomize` コマンドに関する画面設計書である。`kubectl kustomize` は、Kustomizeディレクトリからリソース定義をビルドして標準出力に出力するコマンドであり、`kustomize build` コマンドのkubectl統合版である。

### 本画面の処理概要

**業務上の目的・背景**：Kustomizeは、Kubernetesマニフェストのカスタマイズを宣言的に管理するためのツールである。baseとなるマニフェストに対してoverlayを適用することで、環境ごとの差分（dev/staging/production等）をコード管理できる。`kubectl kustomize` はKustomizeのビルド機能をkubectlに統合し、追加ツールのインストールなしにKustomizeを利用可能にする。

**画面へのアクセス方法**：ターミナルから `kubectl kustomize [DIR]` コマンドを実行する。引数にKustomizeディレクトリ（kustomization.yamlが存在するディレクトリ）またはURLを指定する。

**主要な操作・処理内容**：
1. Kustomizeディレクトリの読み込み（kustomization.yamlのパース）
2. baseリソースの読み込みと解析
3. overlayの適用（パッチ、名前変更、ラベル付与等）
4. ビルド結果のYAML出力

**画面遷移**：kubectl kustomizeは単独で完結するコマンドである。`kubectl apply -k DIR` の内部処理でKustomizeビルドが利用される。典型的なワークフローとして `kubectl kustomize DIR | kubectl apply -f -` のパイプライン利用がある。

**権限による表示制御**：ローカルファイルシステムの読み取りのみ行い、API Serverへの接続は不要。権限制御はファイルシステムレベル。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 82 | 宣言的適用（apply） | 補助機能 | Kustomizeビルド結果をapplyコマンドと連携して適用可能 |

## 画面種別

CLI コマンド（マニフェスト生成・ビルド操作）

## URL/ルーティング

```
kubectl kustomize DIR [flags]
```

コマンドエントリーポイント: `staging/src/k8s.io/kubectl/pkg/cmd/kustomize/kustomize.go` の `NewCmdKustomize` 関数（行30）

## 入出力項目

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|------|-------------|------|
| DIR | string（位置引数） | No | カレントディレクトリ | Kustomizeディレクトリのパスまたは URL |

Kustomize buildコマンドに委譲されるため、追加フラグはsigs.k8s.io/kustomize/kustomize/v5/commands/buildが定義する。

## 表示項目

### 成功時の出力

| 項目 | 形式 | 説明 |
|------|------|------|
| ビルド結果 | YAML | Kustomizeでビルドされたリソース定義のYAML出力 |

## イベント仕様

### 1-Kustomizeビルド実行

1. `build.MakeHelp("kubectl", "kustomize")` でヘルプ情報を生成（行31）
2. `build.NewCmdBuild` でKustomize buildコマンドを生成（行32-40）
3. `filesys.MakeFsOnDisk()` でディスクベースのファイルシステムを使用（行33）
4. 指定ディレクトリのkustomization.yamlを読み込み
5. base/overlayの解決とリソースビルド
6. ビルド結果をstreams.Outに出力（行40）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ビルド実行 | - | - | データベースへの影響なし（ローカルファイル処理のみ） |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|--------------|----------|
| MSG-K01 | エラー | Kustomize固有エラー | kustomization.yaml不正、リソース参照エラー等 |
| MSG-K02 | エラー | ファイル読み取りエラー | 指定ディレクトリ/ファイルが読み取れない |

## 例外処理

| 例外 | 発生条件 | 処理内容 |
|------|----------|----------|
| kustomization.yaml不在 | 指定ディレクトリにkustomization.yamlがない | Kustomizeエラーメッセージを表示 |
| リソース参照エラー | base/overlayのリソースファイルが見つからない | Kustomizeエラーメッセージを表示 |
| パッチ適用エラー | overlay内のパッチが不正 | Kustomizeエラーメッセージを表示 |

## 備考

- `kubectl kustomize` はKustomize v5のbuildコマンドをラップした薄いアダプターである。ほとんどのロジックは `sigs.k8s.io/kustomize/kustomize/v5/commands/build` パッケージに委譲される。
- ファイルシステム操作のみでAPI Server接続は不要なため、kubeconfig設定なしでも動作する。
- `kubectl apply -k DIR` は内部的にKustomize buildを実行してからapplyするため、`kubectl kustomize DIR | kubectl apply -f -` と同等の動作を行う。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | kustomize.go | `staging/src/k8s.io/kubectl/pkg/cmd/kustomize/kustomize.go` | kubectl側のアダプター関数（42行のみの薄いラッパー） |

**読解のコツ**: このファイルは非常に短く、実質的な処理は外部パッケージに委譲している。Kustomize本体のコードリーディングが必要な場合は `vendor/sigs.k8s.io/kustomize/` を参照する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | kustomize.go | `staging/src/k8s.io/kubectl/pkg/cmd/kustomize/kustomize.go` | NewCmdKustomize関数（行30-41）- build.MakeHelpとbuild.NewCmdBuildの呼び出し |

**主要処理フロー**:
1. **行31**: `build.MakeHelp("kubectl", "kustomize")` - ヘルプ情報をkubectl用に生成
2. **行32-40**: `build.NewCmdBuild` - Kustomize buildコマンドの生成
3. **行33**: `filesys.MakeFsOnDisk()` - ディスクファイルシステムの作成
4. **行40**: `streams.Out` - 出力先の設定

#### Step 3: Kustomize buildの内部処理（外部パッケージ）

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | build.go | `vendor/sigs.k8s.io/kustomize/kustomize/v5/commands/build/` | Kustomize buildコマンドの実体（外部依存） |

### プログラム呼び出し階層図

```
NewCmdKustomize (行30)
    │
    ├─ build.MakeHelp("kubectl", "kustomize") (行31)
    │
    └─ build.NewCmdBuild (行32)
           ├─ filesys.MakeFsOnDisk() (行33)
           ├─ Help構造体 (行34-39)
           │      ├─ i18n.T(h.Short)
           │      ├─ templates.LongDesc(i18n.T(h.Long))
           │      └─ templates.Examples(i18n.T(h.Example))
           └─ streams.Out (行40)
                  └─ [Kustomize内部処理]
                         ├─ kustomization.yaml読み込み
                         ├─ base/overlay解決
                         └─ YAML出力
```

### データフロー図

```
[入力]                          [処理]                              [出力]

Kustomizeディレクトリ      ┌──────────────────┐
(kustomization.yaml) ────▶│ filesys.          │
                          │ MakeFsOnDisk      │
                          └────────┬─────────┘
                                   │
                          ┌────────▼─────────┐
                          │ Kustomize Build   │
                          │ (外部パッケージ)    │
                          │ - base読み込み     │
                          │ - overlay適用      │
                          │ - パッチマージ     │
                          └────────┬─────────┘
                                   │
                          ┌────────▼─────────┐
                          │ YAML出力          │──────▶ 標準出力
                          │ (streams.Out)     │
                          └──────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| kustomize.go | `staging/src/k8s.io/kubectl/pkg/cmd/kustomize/kustomize.go` | ソース | kustomizeコマンドのkubectlアダプター（42行） |
| build/ | `vendor/sigs.k8s.io/kustomize/kustomize/v5/commands/build/` | ベンダー | Kustomize buildコマンドの実体 |
| filesys/ | `vendor/sigs.k8s.io/kustomize/kyaml/filesys/` | ベンダー | ファイルシステム抽象化 |
