# 画面設計書 37-kubectl completion

## 概要

本ドキュメントは、Kubernetes CLIツール `kubectl` の `completion` コマンドに関する画面設計書である。`kubectl completion` は、指定されたシェル（bash / zsh / fish / powershell）向けの補完スクリプトを標準出力に出力するコマンドである。

### 本画面の処理概要

**業務上の目的・背景**：CLIツールにおけるシェル補完は、コマンド入力の効率化とエラー削減に重要な役割を果たす。`kubectl completion` は、kubectlのサブコマンド、フラグ、リソースタイプ、リソース名の自動補完スクリプトを生成し、ユーザーのシェル環境に組み込むことで操作性を大幅に向上させる。

**画面へのアクセス方法**：ターミナルから `kubectl completion SHELL` コマンドを実行する。SHELLには bash / zsh / fish / powershell のいずれかを指定する。

**主要な操作・処理内容**：
1. 指定シェルタイプの判定
2. シェル固有の補完スクリプト生成
3. ボイラープレート（ライセンスヘッダー）の出力
4. cobraライブラリの補完生成メソッド呼び出し

**画面遷移**：kubectl completionは単独で完結するコマンドである。出力結果をシェルのprofileファイルに保存するか、`source` コマンドで現在のセッションに読み込むことで補完が有効になる。

**権限による表示制御**：ローカル処理のみでAPI Server接続不要。権限制御はない。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 117 | Config管理 | 補助機能 | kubectlのシェル補完に必要なコマンド構造情報を提供する |

## 画面種別

CLI コマンド（ユーティリティ・シェル補完生成）

## URL/ルーティング

```
kubectl completion SHELL
```

コマンドエントリーポイント: `staging/src/k8s.io/kubectl/pkg/cmd/completion/completion.go` の `NewCmdCompletion` 関数（行125）

## 入出力項目

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 |
|-------------|-----|------|------|
| SHELL | string（位置引数） | Yes | シェルタイプ（bash / zsh / fish / powershell） |

### 有効なシェルタイプ

| シェル | 生成関数 | 説明 |
|--------|----------|------|
| bash | `runCompletionBash` (行162) | Bash補完スクリプト（BashCompletionV2） |
| zsh | `runCompletionZsh` (行173) | Zsh補完スクリプト（compdef対応） |
| fish | `runCompletionFish` (行187) | Fish補完スクリプト |
| powershell | `runCompletionPwsh` (行198) | PowerShell補完スクリプト |

## 表示項目

### 成功時の出力

| 項目 | 形式 | 説明 |
|------|------|------|
| ボイラープレート | コメント | Apache License 2.0ライセンスヘッダー |
| 補完スクリプト | シェルスクリプト | 指定シェル向けの補完コード |

## イベント仕様

### 1-補完スクリプト生成

1. 引数からシェルタイプを取得（行148-153）
2. `completionShells` マップからシェル対応の生成関数を検索（行154-157）
3. ボイラープレート（ライセンスヘッダー）を出力（行163-168, 行177-181, 行191-194, 行200-204）
4. cobra の補完生成メソッドを呼び出し（行170, 行184, 行195, 行207）
5. 生成されたスクリプトを標準出力に出力

### シェル別の補完生成

| シェル | cobra メソッド | 追加処理 |
|--------|---------------|----------|
| bash | `GenBashCompletionV2(out, true)` | なし |
| zsh | `GenZshCompletion(out)` | `#compdef kubectl` ヘッダー追加（行174） |
| fish | `GenFishCompletion(out, true)` | なし |
| powershell | `GenPowerShellCompletionWithDesc(out)` | なし |

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 補完生成 | - | - | データベースへの影響なし（ローカル処理のみ） |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|--------------|----------|
| MSG-C01 | エラー | `Shell not specified.` | シェルタイプ引数未指定 |
| MSG-C02 | エラー | `Too many arguments. Expected only the shell type.` | 引数が2つ以上 |
| MSG-C03 | エラー | `Unsupported shell type "{shell}".` | サポートされないシェル指定 |

## 例外処理

| 例外 | 発生条件 | 処理内容 |
|------|----------|----------|
| 引数未指定 | SHELL引数がない | 使用方法エラーを表示 |
| 引数過多 | 引数が2つ以上 | 使用方法エラーを表示 |
| 未サポートシェル | bash/zsh/fish/powershell以外 | 使用方法エラーを表示 |
| 書き込みエラー | 標準出力への書き込み失敗 | エラーを返す |

## 備考

- zsh補完はバージョン5.2以降でのみサポートされる（行64）。
- ボイラープレートが空の場合、デフォルトのApache License 2.0ヘッダーが使用される（行30-44）。
- 生成される補完スクリプトは `cmd.Parent()`（kubectlルートコマンド）に対して生成される（行159）。
- 補完スクリプトはkubectlのバージョンに依存するため、kubectlのアップグレード後は再生成が推奨される。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | completion.go | `staging/src/k8s.io/kubectl/pkg/cmd/completion/completion.go` | `completionShells` マップ（行116-121）でシェル名と生成関数の対応を確認 |
| 1-2 | completion.go | `staging/src/k8s.io/kubectl/pkg/cmd/completion/completion.go` | `defaultBoilerPlate` 定数（行30-44）のライセンスヘッダー |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | completion.go | `staging/src/k8s.io/kubectl/pkg/cmd/completion/completion.go` | NewCmdCompletion関数（行125-144）のコマンド定義 |
| 2-2 | completion.go | `staging/src/k8s.io/kubectl/pkg/cmd/completion/completion.go` | RunCompletion関数（行147-160）の引数バリデーションとディスパッチ |

**主要処理フロー**:
1. **行125**: `NewCmdCompletion` - cobraコマンド生成
2. **行138**: Run関数 - RunCompletion呼び出し
3. **行148-157**: 引数チェックとシェル関数の検索
4. **行159**: `run(out, boilerPlate, cmd.Parent())` - 親コマンド（kubectl）に対して補完生成

#### Step 3: シェル別生成関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | completion.go | `staging/src/k8s.io/kubectl/pkg/cmd/completion/completion.go` | runCompletionBash（行162-171）- Bash V2補完 |
| 3-2 | completion.go | `staging/src/k8s.io/kubectl/pkg/cmd/completion/completion.go` | runCompletionZsh（行173-185）- Zsh補完（compdefヘッダー付き） |
| 3-3 | completion.go | `staging/src/k8s.io/kubectl/pkg/cmd/completion/completion.go` | runCompletionFish（行187-196）- Fish補完 |
| 3-4 | completion.go | `staging/src/k8s.io/kubectl/pkg/cmd/completion/completion.go` | runCompletionPwsh（行198-208）- PowerShell補完 |

### プログラム呼び出し階層図

```
NewCmdCompletion (行125)
    │
    └─ RunCompletion (行147)
           ├─ 引数バリデーション (行148-157)
           │
           └─ run(out, boilerPlate, cmd.Parent()) (行159)
                  ├─ [bash] runCompletionBash (行162)
                  │      ├─ out.Write(boilerPlate) (行166)
                  │      └─ kubectl.GenBashCompletionV2 (行170)
                  │
                  ├─ [zsh] runCompletionZsh (行173)
                  │      ├─ out.Write(zshHead) (行175)
                  │      ├─ out.Write(boilerPlate) (行180)
                  │      └─ kubectl.GenZshCompletion (行184)
                  │
                  ├─ [fish] runCompletionFish (行187)
                  │      ├─ out.Write(boilerPlate) (行193)
                  │      └─ kubectl.GenFishCompletion (行195)
                  │
                  └─ [powershell] runCompletionPwsh (行198)
                         ├─ out.Write(boilerPlate) (行203)
                         └─ kubectl.GenPowerShellCompletionWithDesc (行207)
```

### データフロー図

```
[入力]                          [処理]                              [出力]

SHELL引数              ┌──────────────────┐
(bash/zsh/...) ───────▶│ completionShells │
                      │ マップ検索        │
                      └────────┬─────────┘
                               │
                      ┌────────▼─────────┐
                      │ ボイラープレート   │──────▶ 標準出力
                      │ 出力              │        (ライセンスヘッダー)
                      └────────┬─────────┘
                               │
                      ┌────────▼─────────┐
                      │ cobra Gen*       │──────▶ 標準出力
                      │ Completion       │        (補完スクリプト)
                      └──────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| completion.go | `staging/src/k8s.io/kubectl/pkg/cmd/completion/completion.go` | ソース | completionコマンドのメイン実装（209行） |
| cobra | `vendor/github.com/spf13/cobra/` | ベンダー | 各シェル向けの補完生成メソッドを提供 |
