# 画面設計書 38-kubectl config

## 概要

本ドキュメントは、Kubernetes CLIツール `kubectl` の `config` コマンドに関する画面設計書である。`kubectl config` は、kubeconfigファイルの管理を行うコマンドグループであり、クラスター、コンテキスト、ユーザー設定の表示・作成・変更・削除を15のサブコマンドで提供する。

### 本画面の処理概要

**業務上の目的・背景**：kubeconfigファイルはkubectlがKubernetes API Serverに接続するための設定情報（クラスターURL、認証情報、コンテキスト）を管理する。複数クラスターの運用時にコンテキストを切り替えたり、新しいクラスターやユーザー設定を追加したりする操作が頻繁に発生する。`kubectl config` はこれらの操作をCLIから安全に実行するための機能を提供する。

**画面へのアクセス方法**：ターミナルから `kubectl config SUBCOMMAND` コマンドを実行する。各サブコマンドに応じたパラメータを指定する。

**主要な操作・処理内容**：
1. kubeconfigの表示（`view`）
2. コンテキストの管理（`current-context` / `use-context` / `set-context` / `get-contexts` / `delete-context` / `rename-context`）
3. クラスターの管理（`set-cluster` / `get-clusters` / `delete-cluster`）
4. ユーザー認証情報の管理（`set-credentials` / `get-users` / `delete-user`）
5. 設定値の操作（`set` / `unset`）

**画面遷移**：kubectl configの各サブコマンドは独立して動作する。コンテキスト変更（`use-context`）後は全てのkubectlコマンドが新しいコンテキストで実行される。

**権限による表示制御**：ローカルのkubeconfigファイルへの読み書き操作のみ。ファイルシステム権限による制御。API Server接続は不要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 117 | Config管理 | 主機能 | kubeconfigファイルのコンテキスト、クラスター、ユーザー設定を管理する主処理 |

## 画面種別

CLI コマンドグループ（設定管理）

## URL/ルーティング

```
kubectl config SUBCOMMAND
```

コマンドエントリーポイント: `staging/src/k8s.io/kubectl/pkg/cmd/config/config.go` の `NewCmdConfig` 関数（行35）

## 入出力項目

### サブコマンド一覧

| サブコマンド | 登録行 | 説明 |
|-------------|--------|------|
| view | 行59 | kubeconfigの内容を表示 |
| set-cluster | 行60 | クラスター設定を追加/更新 |
| set-credentials | 行61 | ユーザー認証情報を追加/更新 |
| set-context | 行62 | コンテキスト設定を追加/更新 |
| set | 行63 | 任意の設定値を設定 |
| unset | 行64 | 任意の設定値を削除 |
| current-context | 行65 | 現在のコンテキスト名を表示 |
| use-context | 行66 | 使用するコンテキストを切り替え |
| get-contexts | 行67 | コンテキスト一覧を表示 |
| get-clusters | 行68 | クラスター一覧を表示 |
| get-users | 行69 | ユーザー一覧を表示 |
| delete-cluster | 行70 | クラスター設定を削除 |
| delete-context | 行71 | コンテキスト設定を削除 |
| delete-user | 行72 | ユーザー設定を削除 |
| rename-context | 行73 | コンテキスト名を変更 |

### 共通パラメータ（PersistentFlags）

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|------|-------------|------|
| --kubeconfig | string | No | $KUBECONFIG or ~/.kube/config | 使用するkubeconfigファイルパス |

## 表示項目

### view サブコマンド

| 項目 | 形式 | 説明 |
|------|------|------|
| kubeconfig内容 | YAML | kubeconfigファイルの内容（シークレットはマスク） |

### current-context サブコマンド

| 項目 | 形式 | 説明 |
|------|------|------|
| コンテキスト名 | テキスト | 現在アクティブなコンテキスト名 |

### get-contexts サブコマンド

| 項目 | 形式 | 説明 |
|------|------|------|
| CURRENT | テキスト | 現在のコンテキストに * マーク |
| NAME | テキスト | コンテキスト名 |
| CLUSTER | テキスト | クラスター名 |
| AUTHINFO | テキスト | ユーザー名 |
| NAMESPACE | テキスト | デフォルトNamespace |

## イベント仕様

### 1-kubeconfigファイルのロード

kubeconfigのロード順序は以下の通り（行44-51のLongDesc参照）：
1. `--kubeconfig` フラグが設定されている場合、そのファイルのみ使用（マージなし）
2. `$KUBECONFIG` 環境変数が設定されている場合、パスリスト内の全ファイルをマージ
3. いずれも未設定の場合、`$HOME/.kube/config` を使用

### 2-サブコマンド実行

各サブコマンドはそれぞれ独立した実装ファイルを持ち、`cmd.AddCommand` で登録される（行59-73）。親コマンド自体は `cmdutil.DefaultSubCommandRun` をRunに設定し、サブコマンド未指定時にヘルプを表示する（行52）。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| view / get-* / current-context | kubeconfigファイル | READ | 設定の読み取りのみ |
| set-* / use-context / rename-context | kubeconfigファイル | WRITE | 設定の追加/更新 |
| delete-* / unset | kubeconfigファイル | WRITE | 設定の削除 |

### テーブル別更新項目詳細

#### kubeconfigファイル（~/.kube/config 等）

| 操作 | 項目 | 更新値・取得条件 | 備考 |
|-----|------|-----------------|------|
| set-cluster | clusters[].cluster | サーバーURL、CA証明書等 | |
| set-credentials | users[].user | クライアント証明書、トークン等 | |
| set-context | contexts[].context | クラスター名、ユーザー名、Namespace | |
| use-context | current-context | コンテキスト名 | |
| delete-cluster | clusters[] | 指定クラスターのエントリ削除 | |
| delete-context | contexts[] | 指定コンテキストのエントリ削除 | |
| delete-user | users[] | 指定ユーザーのエントリ削除 | |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|--------------|----------|
| MSG-CF01 | エラー | サブコマンド未指定時のヘルプ表示 | kubectl configのみ実行 |
| MSG-CF02 | 成功 | `Switched to context "{name}".` | use-contextでコンテキスト切り替え成功 |
| MSG-CF03 | エラー | コンテキスト不在 | 存在しないコンテキストを指定 |

## 例外処理

| 例外 | 発生条件 | 処理内容 |
|------|----------|----------|
| kubeconfigファイル不在 | 指定パスにファイルが存在しない | エラーメッセージを表示（set系は新規作成） |
| ファイル書き込み権限なし | kubeconfigファイルへの書き込み権限がない | パーミッションエラーを表示 |
| 存在しないエントリの削除 | 未登録のクラスター/コンテキスト/ユーザーの削除 | エラーメッセージを表示 |

## 備考

- kubeconfigのロード順序には厳密な優先順位があり、`--kubeconfig` > `$KUBECONFIG` > デフォルトパスの順で適用される。
- `$KUBECONFIG` 環境変数にはOSのパスデリミタで区切って複数ファイルを指定でき、それらはマージされる。
- 変更操作時に値が作成される場合、`$KUBECONFIG` のチェーンで最初に存在するファイルに書き込まれる。チェーン内にファイルが存在しない場合は最後のファイルが新規作成される。
- `PersistentFlags` で `--kubeconfig` フラグが全サブコマンドに共通で利用可能（行56）。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | config.go | `staging/src/k8s.io/kubectl/pkg/cmd/config/config.go` | NewCmdConfig関数（行35-76）の全体構造 |
| 1-2 | clientcmd | `staging/src/k8s.io/client-go/tools/clientcmd/` | PathOptions、kubeconfigのロードルール |

**読解のコツ**: config.goは親コマンド定義のみ（96行）。各サブコマンドは同ディレクトリ内の別ファイルに実装されている。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | config.go | `staging/src/k8s.io/kubectl/pkg/cmd/config/config.go` | NewCmdConfig関数（行35-76）のサブコマンド登録 |

**主要処理フロー**:
1. **行36-38**: `pathOptions.ExplicitFileFlag` のデフォルト設定
2. **行40-53**: 親コマンド定義（Long Descにロード順序記載）
3. **行56**: `--kubeconfig` PersistentFlagの登録
4. **行59-73**: 15のサブコマンド登録

#### Step 3: 代表的なサブコマンドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | view.go | `staging/src/k8s.io/kubectl/pkg/cmd/config/view.go` | config viewの実装（推定パス） |
| 3-2 | use_context.go | `staging/src/k8s.io/kubectl/pkg/cmd/config/use_context.go` | config use-contextの実装（推定パス） |
| 3-3 | current_context.go | `staging/src/k8s.io/kubectl/pkg/cmd/config/current_context.go` | config current-contextの実装（推定パス） |

### プログラム呼び出し階層図

```
NewCmdConfig (行35)
    │
    ├─ PersistentFlags (行56)
    │      └─ --kubeconfig フラグ登録
    │
    ├─ NewCmdConfigView (行59)
    ├─ NewCmdConfigSetCluster (行60)
    ├─ NewCmdConfigSetCredentials (行61)
    ├─ NewCmdConfigSetContext (行62)
    ├─ NewCmdConfigSet (行63)
    ├─ NewCmdConfigUnset (行64)
    ├─ NewCmdConfigCurrentContext (行65)
    ├─ NewCmdConfigUseContext (行66)
    ├─ NewCmdConfigGetContexts (行67)
    ├─ NewCmdConfigGetClusters (行68)
    ├─ NewCmdConfigGetUsers (行69)
    ├─ NewCmdConfigDeleteCluster (行70)
    ├─ NewCmdConfigDeleteContext (行71)
    ├─ NewCmdConfigDeleteUser (行72)
    └─ NewCmdConfigRenameContext (行73)
```

### データフロー図

```
[入力]                          [処理]                              [出力]

サブコマンド              ┌──────────────────┐
+ パラメータ ────────────▶│ PathOptions      │
                        │ (kubeconfigパス   │
                        │  解決)            │
                        └────────┬─────────┘
                                 │
                        ┌────────▼─────────┐
                        │ clientcmd        │
                        │ kubeconfigファイル │
--kubeconfig ──────────▶│ ロード/マージ      │
$KUBECONFIG ───────────▶│                  │
~/.kube/config ────────▶│                  │
                        └────────┬─────────┘
                                 │
                        ┌────────▼─────────┐
                        │ サブコマンド処理   │
                        │ (Read/Write)     │
                        └────────┬─────────┘
                                 │
                    ┌────────────┴────────────┐
                    ▼                          ▼
              標準出力                   kubeconfigファイル
              (view/get/current)         (set/delete/use)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| config.go | `staging/src/k8s.io/kubectl/pkg/cmd/config/config.go` | ソース | configコマンドの親定義（96行） |
| view.go | `staging/src/k8s.io/kubectl/pkg/cmd/config/view.go` | ソース | config viewサブコマンド |
| use_context.go | `staging/src/k8s.io/kubectl/pkg/cmd/config/use_context.go` | ソース | use-contextサブコマンド |
| current_context.go | `staging/src/k8s.io/kubectl/pkg/cmd/config/current_context.go` | ソース | current-contextサブコマンド |
| set.go | `staging/src/k8s.io/kubectl/pkg/cmd/config/set.go` | ソース | setサブコマンド |
| unset.go | `staging/src/k8s.io/kubectl/pkg/cmd/config/unset.go` | ソース | unsetサブコマンド |
| get_contexts.go | `staging/src/k8s.io/kubectl/pkg/cmd/config/get_contexts.go` | ソース | get-contextsサブコマンド |
| clientcmd/ | `staging/src/k8s.io/client-go/tools/clientcmd/` | ソース | kubeconfigのロード・パース処理 |
