# 画面設計書 39-kubectl plugin

## 概要

本ドキュメントは、Kubernetes CLIツール `kubectl` の `plugin` コマンドに関する画面設計書である。`kubectl plugin` は、kubectlプラグインの検出・一覧表示を行うコマンドであり、PATH上の `kubectl-` プレフィックスを持つ実行可能ファイルをプラグインとして認識する。

### 本画面の処理概要

**業務上の目的・背景**：kubectlはプラグインメカニズムにより拡張可能であり、`kubectl-` プレフィックスを持つ実行可能ファイルをPATH上に配置することで、`kubectl PLUGIN_NAME` として利用できる。`kubectl plugin` コマンドはインストール済みプラグインの発見と検証を行い、プラグインの管理を支援する。Krew（プラグインマネージャー）と併用して利用されることが多い。

**画面へのアクセス方法**：ターミナルから `kubectl plugin list` コマンドを実行する。親コマンド `kubectl plugin` 自体はサブコマンドの実行を促すヘルプを表示する。

**主要な操作・処理内容**：
1. PATH環境変数から `kubectl-` プレフィックスのファイルを検索
2. プラグインの実行可能性チェック
3. 既存kubectlコマンドとの名前衝突チェック
4. 同名プラグインの重複（シャドウイング）チェック
5. プラグイン一覧の表示（フルパスまたはバイナリ名のみ）

**画面遷移**：kubectl pluginは単独で完結するコマンドである。プラグインのインストール・アンインストールにはKrew（`kubectl krew`）の使用が推奨される。

**権限による表示制御**：ローカルファイルシステムの読み取りのみ。API Server接続不要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 111 | プラグイン管理（plugin） | 主機能 | kubectlプラグインの検出と実行を管理する主処理 |

## 画面種別

CLI コマンド（プラグイン管理・一覧表示）

## URL/ルーティング

```
kubectl plugin [flags]
kubectl plugin list [flags]
```

コマンドエントリーポイント: `staging/src/k8s.io/kubectl/pkg/cmd/plugin/plugin.go` の `NewCmdPlugin` 関数（行66）

## 入出力項目

### 入力パラメータ（plugin list）

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|------|-------------|------|
| --name-only | bool | No | false | バイナリ名のみ表示（フルパスなし） |

## 表示項目

### plugin list 成功時の出力

| 項目 | 形式 | 説明 |
|------|------|------|
| ヘッダー | テキスト | "The following compatible plugins are available:" |
| プラグインパス | テキスト | 各プラグインのフルパス（--name-only時はバイナリ名のみ） |
| 警告 | テキスト | 実行不可、シャドウイング、コマンド上書きの警告 |

## イベント仕様

### 1-プラグイン一覧表示（plugin list）

1. `Complete` でルートコマンドとPATH環境変数を取得（行112-120）
2. `Run` でプラグイン検索と検証を実行（行122-162）
3. `ListPlugins` でPATH上のプラグインファイルを列挙（行165-198）
   - 各PATHディレクトリを走査（行169）
   - `kubectl-` プレフィックスを持つ非ディレクトリファイルを収集（行185-194）
4. 各プラグインに対して `Verifier.Verify` で検証（行138）
5. 結果の出力（行133-137）

### 2-プラグイン検証（CommandOverrideVerifier.Verify）

1. バイナリ名の抽出（行221）
2. 実行可能性チェック（`isExecutable` 関数、行231-235, 行250-271）
   - Unix: ファイルの実行ビットを確認（行266）
   - Windows: .bat, .cmd, .com, .exe, .ps1の拡張子を確認（行260-263）
3. 同名プラグインの重複チェック（行237-241）
4. 既存kubectlコマンドとの名前衝突チェック（行243-245）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| プラグイン一覧 | - | - | データベースへの影響なし（ファイルシステム読み取りのみ） |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|--------------|----------|
| MSG-PL01 | 情報 | `The following compatible plugins are available:` | プラグインが1つ以上見つかった場合 |
| MSG-PL02 | エラー | `error: unable to find any kubectl plugins in your PATH` | プラグインが見つからない場合 |
| MSG-PL03 | 警告 | `warning: {path} identified as a kubectl plugin, but it is not executable` | プラグインが実行不可 |
| MSG-PL04 | 警告 | `warning: {path} is overshadowed by a similarly named plugin: {existing}` | 同名プラグインの重複 |
| MSG-PL05 | 警告 | `warning: {name} overwrites existing command: "{path}"` | 既存kubectlコマンドとの名前衝突 |
| MSG-PL06 | エラー | `error: one plugin warning was found` | 警告が1件の場合 |
| MSG-PL07 | エラー | `error: {n} plugin warnings were found` | 警告がn件（2以上）の場合 |
| MSG-PL08 | 情報 | `Unable to read directory "{dir}" from your PATH: {error}. Skipping...` | PATHディレクトリ読み取りエラー（PathError） |
| MSG-PL09 | エラー | `error: unable to read directory "{dir}" in your PATH: {error}` | PATHディレクトリ読み取りエラー（その他） |

## 例外処理

| 例外 | 発生条件 | 処理内容 |
|------|----------|----------|
| PATH読み取りエラー（PathError） | PATHのディレクトリが存在しない等 | 警告メッセージを出力してスキップ |
| PATH読み取りエラー（その他） | パーミッションエラー等 | エラーリストに追加 |
| 実行権限なし | プラグインファイルに実行ビットがない | 警告メッセージを出力 |
| プラグイン未発見 | PATH上にkubectl-*が存在しない | エラーメッセージを表示 |

## 備考

- プラグインのプレフィックスは `kubectl-` で固定されている（行63: `ValidPluginFilenamePrefixes`）。
- プラグインファイル名のハイフン（`-`）はkubectlサブコマンド名のスペースに対応する（例: `kubectl-foo-bar` は `kubectl foo bar` として実行可能）。
- PATH上の重複を検出するために `uniquePathsList` 関数（行275-286）でPATHの重複排除を行う。
- プラグインの発見とKrewによるインストールを推奨する旨がLong Descriptionに記載されている（行37-44）。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | plugin.go | `staging/src/k8s.io/kubectl/pkg/cmd/plugin/plugin.go` | PluginListOptions構造体（行82-89）のフィールド構成 |
| 1-2 | plugin.go | `staging/src/k8s.io/kubectl/pkg/cmd/plugin/plugin.go` | PathVerifierインターフェース（行201-204）とCommandOverrideVerifier構造体（行206-209） |

**読解のコツ**: `ValidPluginFilenamePrefixes`（行63）がプラグイン識別のキー。`seenPlugins` マップがシャドウイング検出に使用される。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | plugin.go | `staging/src/k8s.io/kubectl/pkg/cmd/plugin/plugin.go` | NewCmdPlugin関数（行66-80）の親コマンド定義 |
| 2-2 | plugin.go | `staging/src/k8s.io/kubectl/pkg/cmd/plugin/plugin.go` | NewCmdPluginList関数（行92-110）のlistサブコマンド定義 |

**主要処理フロー**:
1. **行66**: `NewCmdPlugin` - 親コマンド生成
2. **行78**: `NewCmdPluginList` をサブコマンドとして登録
3. **行92-110**: `NewCmdPluginList` - listサブコマンドと--name-onlyフラグ

#### Step 3: プラグイン検索ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | plugin.go | `staging/src/k8s.io/kubectl/pkg/cmd/plugin/plugin.go` | ListPlugins関数（行165-198）のPATH走査 |
| 3-2 | plugin.go | `staging/src/k8s.io/kubectl/pkg/cmd/plugin/plugin.go` | hasValidPrefix関数（行288-296）のプレフィックスチェック |

#### Step 4: プラグイン検証ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | plugin.go | `staging/src/k8s.io/kubectl/pkg/cmd/plugin/plugin.go` | Verify関数（行214-248）の3段階検証（実行可能性、シャドウイング、コマンド上書き） |
| 4-2 | plugin.go | `staging/src/k8s.io/kubectl/pkg/cmd/plugin/plugin.go` | isExecutable関数（行250-271）のOS別実行可能性判定 |

### プログラム呼び出し階層図

```
NewCmdPlugin (行66)
    │
    └─ NewCmdPluginList (行92)
           │
           ├─ Complete (行112)
           │      ├─ CommandOverrideVerifier初期化 (行113-116)
           │      └─ filepath.SplitList(os.Getenv("PATH")) (行118)
           │
           └─ Run (行122)
                  ├─ ListPlugins (行123, 行165)
                  │      ├─ uniquePathsList (行169, 行275)
                  │      ├─ os.ReadDir (行174)
                  │      └─ hasValidPrefix (行189, 行288)
                  │
                  └─ Verifier.Verify (行138, 行214)
                         ├─ isExecutable (行231, 行250)
                         │      ├─ [Windows] 拡張子チェック
                         │      └─ [Unix] 実行ビットチェック
                         ├─ シャドウイングチェック (行237)
                         └─ root.Find (行243)
```

### データフロー図

```
[入力]                          [処理]                              [出力]

$PATH環境変数             ┌──────────────────┐
  ─────────────────────▶│ uniquePathsList   │
                        │ (重複排除)         │
                        └────────┬─────────┘
                                 │
                        ┌────────▼─────────┐
                        │ ListPlugins      │
                        │ (kubectl-*検索)   │
                        └────────┬─────────┘
                                 │
                        ┌────────▼─────────┐
                        │ Verify           │
                        │ - 実行可能性     │
                        │ - シャドウイング  │
                        │ - コマンド上書き  │
                        └────────┬─────────┘
                                 │
                        ┌────────▼─────────┐
                        │ 結果出力          │
                        │ (パス/名前+警告)  │──────▶ 標準出力/エラー出力
                        └──────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| plugin.go | `staging/src/k8s.io/kubectl/pkg/cmd/plugin/plugin.go` | ソース | pluginコマンドのメイン実装（297行） |
| plugin_test.go | `staging/src/k8s.io/kubectl/pkg/cmd/plugin/plugin_test.go` | テスト | pluginコマンドのテスト |
