# 画面設計書 4-kubectl set

## 概要

本ドキュメントは、Kubernetes CLIツール `kubectl` の `set` コマンドに関する画面設計書である。`kubectl set` は既存のKubernetesリソースの特定のフィールドを直接更新するためのコマンド群を提供する。

### 本画面の処理概要

`kubectl set` は親コマンドとして6つのサブコマンドを束ね、アプリケーションリソースの各種設定を変更する機能を提供する。

**業務上の目的・背景**：Deploymentやその他のワークロードリソースの特定のフィールド（コンテナイメージ、環境変数、リソース制限、セレクタ、サービスアカウント、サブジェクト）を、マニフェストファイルを直接編集せずにコマンドラインから効率的に変更する。ローリングアップデートの契機となるイメージ変更や、リソース制限の調整等の運用タスクに利用される。

**画面へのアクセス方法**：ターミナルから `kubectl set <subcommand> [options]` の形式で実行する。

**主要な操作・処理内容**：
1. `kubectl set image` - コンテナイメージの変更
2. `kubectl set env` - 環境変数の追加・更新・削除
3. `kubectl set resources` - CPU/メモリのリソース制限・リクエストの設定
4. `kubectl set selector` - セレクタの設定
5. `kubectl set serviceaccount` - サービスアカウントの変更
6. `kubectl set subject` - RoleBinding/ClusterRoleBindingのサブジェクト変更

**画面遷移**：本コマンドはBasic Commands (Beginner)カテゴリに属する。`kubectl set image` によるイメージ変更はDeploymentのロールアウトをトリガーし、`kubectl rollout` で状態を確認できる。

**権限による表示制御**：各サブコマンドは対象リソースに対するupdate/patch権限が必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 106 | 設定セット（set） | 主機能 | リソースのimage、env、resources等のフィールドを直接更新する主処理 |
| 1 | API Serverコア | API連携 | リソースフィールド更新リクエストをAPI Serverに送信する |

## 画面種別

CLIコマンド（リソース更新）- サブコマンド群の親コマンド

## URL/ルーティング

```
kubectl set SUBCOMMAND
```

サブコマンド: `image`, `env`, `resources`, `selector`, `serviceaccount`, `subject`

## 入出力項目

### 共通オプション（各サブコマンド共通）

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| -f, --filename | string[] | No | 対象リソースのファイルパス |
| -l, --selector | string | No | ラベルセレクタ |
| --all | bool | No | 全リソースを対象にする |
| --local | bool | No | ローカルモード（API Serverに送信しない） |
| --dry-run | string | No | ドライランモード |
| -o, --output | string | No | 出力フォーマット |

### set image 固有オプション

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| CONTAINER_NAME=IMAGE | string | Yes | コンテナ名=イメージの組み合わせ |

### set env 固有オプション

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| KEY=VALUE | string[] | Yes（list以外） | 環境変数のキー=値ペア |
| --list | bool | No | 環境変数の一覧表示 |
| -e, --env | string[] | No | 環境変数（代替書式） |

### set resources 固有オプション

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| --limits | string | No | リソース制限（cpu=200m,memory=512Mi形式） |
| --requests | string | No | リソースリクエスト |
| -c, --containers | string | No | 対象コンテナ名 |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| 更新結果 | `<resource-type>/<name> image updated` 等の形式 |
| 環境変数一覧 | `--list` 時の環境変数表示 |

## イベント仕様

### 1-set image 実行

1. `SetImageOptions.Run()` で対象リソースを取得
2. `UpdatePodSpecForObject()` でPodSpecを取得
3. 指定されたコンテナ名のイメージを変更
4. パッチとしてAPI Serverに送信

### 2-set env 実行

1. `EnvOptions.Run()` で対象リソースを取得
2. 既存の環境変数と新規指定を統合
3. `--list` の場合は現在の値を表示して終了
4. それ以外はパッチとしてAPI Serverに送信

### 3-set resources 実行

1. `SetResourcesOptions.Run()` で対象リソースを取得
2. `--limits` / `--requests` の値をパース
3. ResourceRequirements を更新
4. パッチとしてAPI Serverに送信

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| set image | etcd（対象リソース） | UPDATE（PATCH） | コンテナイメージフィールドを更新 |
| set env | etcd（対象リソース） | UPDATE（PATCH） | 環境変数フィールドを更新 |
| set resources | etcd（対象リソース） | UPDATE（PATCH） | リソース制限/リクエストを更新 |
| set selector | etcd（対象リソース） | UPDATE（PATCH） | セレクタフィールドを更新 |
| set serviceaccount | etcd（対象リソース） | UPDATE（PATCH） | サービスアカウントを更新 |
| set subject | etcd（対象リソース） | UPDATE（PATCH） | サブジェクトフィールドを更新 |

## メッセージ仕様

| 種別 | メッセージ | 条件 |
|------|-----------|------|
| 成功 | `<resource-type>/<name> image updated` | イメージ更新成功 |
| 成功 | `<resource-type>/<name> env updated` | 環境変数更新成功 |
| 成功 | `<resource-type>/<name> resource requirements updated` | リソース更新成功 |
| エラー | サブコマンド未指定時のヘルプ表示 | 親コマンドのみ実行した場合 |

## 例外処理

| 例外条件 | 動作 |
|----------|------|
| 対象リソースが存在しない | NotFoundエラーを表示 |
| 権限不足 | Forbiddenエラーを表示 |
| 不正なリソース制限値 | パースエラーを表示 |
| コンテナ名が見つからない | エラーメッセージを表示 |

## 備考

- `kubectl set` 自体はサブコマンドを持つ親コマンドであり、単体では実行不可（ヘルプを表示する）。
- 対象リソース: pod, replicationcontroller, deployment, daemonset, statefulset, cronjob, replicaset
- `set image` によるイメージ変更はDeploymentのローリングアップデートをトリガーする。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | set.go | `staging/src/k8s.io/kubectl/pkg/cmd/set/set.go` | `NewCmdSet()` 関数（行37-55）: 6つのサブコマンドの登録 |
| 1-2 | set_image.go | `staging/src/k8s.io/kubectl/pkg/cmd/set/set_image.go` | `SetImageOptions` 構造体（行44-67）: ContainerImages, UpdatePodSpecForObjectなど |
| 1-3 | set_env.go | `staging/src/k8s.io/kubectl/pkg/cmd/set/set_env.go` | envLong, envExample で操作概要を確認 |
| 1-4 | set_resources.go | `staging/src/k8s.io/kubectl/pkg/cmd/set/set_resources.go` | `SetResourcesOptions` 構造体（行66-80）: limits/requests設定 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | set.go | `staging/src/k8s.io/kubectl/pkg/cmd/set/set.go` | `NewCmdSet()`: 6サブコマンド（image, resources, selector, subject, serviceaccount, env）の登録（行47-52） |

**主要処理フロー**:
1. **行38-44**: cobra.Command定義、`DefaultSubCommandRun` でサブコマンド未指定時はヘルプ表示
2. **行47-52**: 6つのサブコマンドを `cmd.AddCommand()` で登録

#### Step 3: 各サブコマンドの処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | set_image.go | `staging/src/k8s.io/kubectl/pkg/cmd/set/set_image.go` | `NewCmdImage()`, `SetImageOptions.Run()` |
| 3-2 | set_env.go | `staging/src/k8s.io/kubectl/pkg/cmd/set/set_env.go` | `NewCmdEnv()`, `EnvOptions.RunEnv()` |
| 3-3 | set_resources.go | `staging/src/k8s.io/kubectl/pkg/cmd/set/set_resources.go` | `NewCmdResources()`, `SetResourcesOptions.Run()` |

### プログラム呼び出し階層図

```
NewCmdSet()
    |
    +-- NewCmdImage()
    |       +-- SetImageOptions.Complete()
    |       +-- SetImageOptions.Validate()
    |       +-- SetImageOptions.Run()
    |               +-- UpdatePodSpecForObject()
    |               +-- resource.NewHelper().Patch()
    |
    +-- NewCmdEnv()
    |       +-- EnvOptions.Complete()
    |       +-- EnvOptions.Validate()
    |       +-- EnvOptions.RunEnv()
    |
    +-- NewCmdResources()
    |       +-- SetResourcesOptions.Complete()
    |       +-- SetResourcesOptions.Validate()
    |       +-- SetResourcesOptions.Run()
    |
    +-- NewCmdSelector()
    +-- NewCmdSubject()
    +-- NewCmdServiceAccount()
```

### データフロー図

```
[入力]                          [処理]                              [出力]

コンテナ名=イメージ  ───▶  resource.Builder        ───▶  resource.Info
  or KEY=VALUE                 |
  or --limits/--requests       v
                         UpdatePodSpecForObject()  ───▶  更新されたPodSpec
                               |
                               v
                         resource.NewHelper().Patch() ───▶  API Server (etcd)
                               |
                               v
                         PrintObj()                ───▶  stdout (更新結果)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| set.go | `staging/src/k8s.io/kubectl/pkg/cmd/set/set.go` | ソース | 親コマンド（サブコマンド登録） |
| set_image.go | `staging/src/k8s.io/kubectl/pkg/cmd/set/set_image.go` | ソース | set imageサブコマンド |
| set_env.go | `staging/src/k8s.io/kubectl/pkg/cmd/set/set_env.go` | ソース | set envサブコマンド |
| set_resources.go | `staging/src/k8s.io/kubectl/pkg/cmd/set/set_resources.go` | ソース | set resourcesサブコマンド |
| set_selector.go | `staging/src/k8s.io/kubectl/pkg/cmd/set/set_selector.go` | ソース | set selectorサブコマンド |
| set_serviceaccount.go | `staging/src/k8s.io/kubectl/pkg/cmd/set/set_serviceaccount.go` | ソース | set serviceaccountサブコマンド |
| set_subject.go | `staging/src/k8s.io/kubectl/pkg/cmd/set/set_subject.go` | ソース | set subjectサブコマンド |
| polymorphichelpers | `staging/src/k8s.io/kubectl/pkg/polymorphichelpers/` | ソース | UpdatePodSpecForObject等のヘルパー関数 |
