# 画面設計書 40-kubectl version

## 概要

本ドキュメントは、Kubernetes CLIツール `kubectl` の `version` コマンドに関する画面設計書である。`kubectl version` は、kubectlクライアントとKubernetes API Serverのバージョン情報を表示するコマンドであり、クラスターの互換性確認やトラブルシューティングに使用される。

### 本画面の処理概要

**業務上の目的・背景**：Kubernetesの運用においてクライアント（kubectl）とサーバー（API Server）のバージョン互換性は重要な要件である。Kubernetesはクライアントとサーバーのバージョン差（skew）に対してサポートポリシーを定めており、`kubectl version` はこの互換性を確認するための基本コマンドである。バージョン不一致の警告も表示される。

**画面へのアクセス方法**：ターミナルから `kubectl version` コマンドを実行する。デフォルトではクライアントとサーバー両方のバージョンを表示する。

**主要な操作・処理内容**：
1. クライアント（kubectl）バージョン情報の取得
2. Kustomizeバージョン情報の取得
3. サーバー（API Server）バージョン情報の取得（DiscoveryClient経由）
4. バージョン情報の出力（テキスト / JSON / YAML）
5. クライアント-サーバー間のバージョンスキュー警告

**画面遷移**：kubectl versionは単独で完結するコマンドである。トラブルシューティングの初期段階で `kubectl version` と `kubectl cluster-info` を組み合わせて確認することが多い。

**権限による表示制御**：サーバーバージョン取得には API Serverへの接続が必要。`--client` フラグでクライアントのみ表示する場合は接続不要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | API Serverコア | API連携 | サーバーバージョン取得のためAPI Serverにリクエストを送信する |

## 画面種別

CLI コマンド（情報表示）

## URL/ルーティング

```
kubectl version
```

コマンドエントリーポイント: `staging/src/k8s.io/kubectl/pkg/cmd/version/version.go` の `NewCmdVersion` 関数（行76）

## 入出力項目

### 入力パラメータ（フラグ）

| パラメータ名 | 短縮形 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|--------|-----|------|-------------|------|
| --client | - | bool | No | false | クライアントバージョンのみ表示（サーバー接続不要） |
| -o / --output | -o | string | No | "" | 出力形式（yaml / json） |
| --warnings-as-errors | - | bool | No | false | 警告をエラーとして扱う（共通フラグ） |

## 表示項目

### デフォルト出力（テキスト形式）

| 項目 | 形式 | 説明 |
|------|------|------|
| Client Version | テキスト | kubectlのGitVersion（例: `Client Version: v1.30.0`） |
| Kustomize Version | テキスト | 組み込みKustomizeのバージョン（例: `Kustomize Version: v5.7.1`） |
| Server Version | テキスト | API ServerのGitVersion（例: `Server Version: v1.30.0`） |

### JSON/YAML出力

| 項目 | フィールド | 型 | 説明 |
|------|-----------|-----|------|
| clientVersion | clientVersion | Info | クライアントバージョン情報（major, minor, gitVersion, gitCommit等） |
| kustomizeVersion | kustomizeVersion | string | Kustomizeバージョン文字列 |
| serverVersion | serverVersion | Info | サーバーバージョン情報 |

### Version構造体（行42-46）

| フィールド | 型 | JSON/YAMLキー | 説明 |
|-----------|-----|--------------|------|
| ClientVersion | *apimachineryversion.Info | clientVersion | クライアントバージョン |
| KustomizeVersion | string | kustomizeVersion | Kustomizeバージョン |
| ServerVersion | *apimachineryversion.Info | serverVersion | サーバーバージョン |

## イベント仕様

### 1-バージョン情報の取得と表示

1. `Complete` でDiscoveryClientの初期化（行95-112）
   - `--client` フラグ時はDiscoveryClient不要（行100-102）
   - kubeconfig未設定時はnilのまま（行106-107）
2. `Validate` で引数と出力形式のチェック（行115-125）
3. `Run` でバージョン情報を取得して出力（行128-181）

### 2-クライアントバージョン取得

1. `version.Get()` でビルド時に埋め込まれたバージョン情報を取得（行134）
2. `getKustomizeVersion()` でKustomizeバージョンを取得（行135, 行183-188）
   - `debug.ReadBuildInfo()` からモジュールバージョンを取得（行190-201）
   - 取得できない場合はハードコード値 `v5.7.1` を使用（行39, 行187）

### 3-サーバーバージョン取得

1. `discoveryClient.Invalidate()` でキャッシュを無効化（行139）
2. `discoveryClient.ServerVersion()` でAPI Serverのバージョンを取得（行140）
3. サーバーバージョン取得エラーは最後に返される（行180）

### 4-バージョンスキュー警告

1. `getVersionSkewWarning` でクライアントとサーバーのバージョン差を検証（行169）
2. 警告がある場合、stderrに出力（行177）
3. `--warnings-as-errors` フラグ時はエラーとして返す（行174-175）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| バージョン取得 | - | SELECT | API Serverのバージョンエンドポイント（/version）への読み取りのみ |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 発生条件 |
|-------------|------|--------------|----------|
| MSG-V01 | 情報 | `Client Version: {version}` | クライアントバージョン表示 |
| MSG-V02 | 情報 | `Kustomize Version: {version}` | Kustomizeバージョン表示 |
| MSG-V03 | 情報 | `Server Version: {version}` | サーバーバージョン表示 |
| MSG-V04 | エラー | `extra arguments: {args}` | 不要な位置引数が指定された場合 |
| MSG-V05 | エラー | `--output must be 'yaml' or 'json'` | 無効な出力形式指定 |
| MSG-V06 | 警告 | `Warning: {skew warning}` | バージョンスキューが検出された場合 |

## 例外処理

| 例外 | 発生条件 | 処理内容 |
|------|----------|----------|
| API Server接続エラー | クラスターに接続できない | サーバーバージョンはnilで表示、エラーを返す |
| kubeconfig未設定 | kubeconfigが存在しない | クライアントバージョンのみ表示 |
| バージョンスキュー | クライアントとサーバーのメジャー/マイナーバージョン差が大きい | 警告メッセージを表示 |

## 備考

- Kustomizeバージョンは `debug.ReadBuildInfo()` で動的に取得を試み、取得できない場合はハードコード値 `v5.7.1` を使用する（行39）。
- `--client` フラグを指定するとAPI Serverへの接続を完全にスキップし、クライアント情報のみ表示される。
- バージョンスキュー警告の詳細ロジックは `skew_warning.go` に実装されている。
- DiscoveryClientは `Invalidate()` を呼び出してキャッシュを無効化し、常に最新のサーバーバージョンを取得する。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | version.go | `staging/src/k8s.io/kubectl/pkg/cmd/version/version.go` | Version構造体（行42-46）の3フィールド構成 |
| 1-2 | version.go | `staging/src/k8s.io/kubectl/pkg/cmd/version/version.go` | Options構造体（行55-65）のフラグ対応 |

**読解のコツ**: `apimachineryversion.Info` は標準的なKubernetesバージョン情報構造体で、GitVersion, GitCommit, Major, Minor等を含む。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | version.go | `staging/src/k8s.io/kubectl/pkg/cmd/version/version.go` | NewCmdVersion関数（行76-92）のコマンド定義とフラグ登録 |

**主要処理フロー**:
1. **行76**: `NewCmdVersion` - cobraコマンド生成
2. **行83-87**: Run関数 - Complete -> Validate -> Run
3. **行89-91**: フラグ登録（--client, --output）

#### Step 3: Run - メイン処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | version.go | `staging/src/k8s.io/kubectl/pkg/cmd/version/version.go` | Run関数（行128-181）のバージョン取得と出力ロジック |
| 3-2 | version.go | `staging/src/k8s.io/kubectl/pkg/cmd/version/version.go` | getKustomizeVersion関数（行183-188）とGetKustomizeModVersion関数（行190-201） |

**主要処理フロー**:
- **行134**: クライアントバージョン取得（`version.Get()`）
- **行135**: Kustomizeバージョン取得
- **行137-141**: サーバーバージョン取得（--clientでない場合）
- **行143-166**: 出力形式による分岐（テキスト/yaml/json）
- **行168-179**: バージョンスキュー警告の処理

#### Step 4: バージョンスキュー警告を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | skew_warning.go | `staging/src/k8s.io/kubectl/pkg/cmd/version/skew_warning.go` | getVersionSkewWarning関数のスキュー検出ロジック |

### プログラム呼び出し階層図

```
NewCmdVersion (行76)
    │
    ├─ Complete (行95)
    │      ├─ warnings-as-errorsフラグ確認 (行98)
    │      └─ f.ToDiscoveryClient() (行103)
    │
    ├─ Validate (行115)
    │      ├─ 余分な引数チェック (行116-118)
    │      └─ --output値チェック (行120-122)
    │
    └─ Run (行128)
           ├─ version.Get() (行134)
           │      └─ クライアントバージョン情報
           │
           ├─ getKustomizeVersion() (行135, 行183)
           │      └─ GetKustomizeModVersion() (行190)
           │             └─ debug.ReadBuildInfo() (行191)
           │
           ├─ discoveryClient.ServerVersion() (行140)
           │      └─ API Server /version エンドポイント
           │
           ├─ 出力 (行143-166)
           │      ├─ [テキスト] Fprintf
           │      ├─ [yaml] yaml.Marshal
           │      └─ [json] json.MarshalIndent
           │
           └─ getVersionSkewWarning (行169)
                  └─ スキュー検出 → 警告/エラー
```

### データフロー図

```
[入力]                          [処理]                              [出力]

ビルド情報               ┌──────────────────┐
(コンパイル時埋込) ──────▶│ version.Get()    │──────▶ Client Version
                        └──────────────────┘

モジュール情報           ┌──────────────────┐
(debug.ReadBuildInfo) ──▶│ getKustomize     │──────▶ Kustomize Version
                        │ Version()        │
                        └──────────────────┘

API Server              ┌──────────────────┐
/version endpoint ──────▶│ discoveryClient  │──────▶ Server Version
                        │ .ServerVersion() │
                        └────────┬─────────┘
                                 │
                        ┌────────▼─────────┐
                        │ getVersionSkew   │──────▶ Warning (stderr)
                        │ Warning          │
                        └──────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| version.go | `staging/src/k8s.io/kubectl/pkg/cmd/version/version.go` | ソース | versionコマンドのメイン実装（202行） |
| skew_warning.go | `staging/src/k8s.io/kubectl/pkg/cmd/version/skew_warning.go` | ソース | バージョンスキュー警告ロジック |
| version.go | `staging/src/k8s.io/component-base/version/version.go` | ソース | ビルド時バージョン情報の取得 |
| types.go | `staging/src/k8s.io/apimachinery/pkg/version/types.go` | ソース | バージョン情報のInfo構造体定義 |
| discovery_client.go | `staging/src/k8s.io/client-go/discovery/discovery_client.go` | ソース | DiscoveryClient（サーバーバージョン取得） |
