# 画面設計書 5-kubectl explain

## 概要

本ドキュメントは、Kubernetes CLIツール `kubectl` の `explain` コマンドに関する画面設計書である。`kubectl explain` はKubernetes APIリソースのフィールド構造とドキュメントを表示するコマンドである。

### 本画面の処理概要

`kubectl explain` コマンドは、OpenAPI仕様（v2/v3）を元に、指定されたリソースタイプの各フィールドの説明、型、制約を表示する。

**業務上の目的・背景**：マニフェストファイルを作成する際に、各リソースタイプが持つフィールドの名前・型・説明を確認するために使用する。APIリファレンスドキュメントをブラウザで参照する代わりに、ターミナル上で即座にフィールド情報を確認できる。特にカスタムリソース（CRD）のフィールド確認にも対応している。

**画面へのアクセス方法**：ターミナルから `kubectl explain <resource>[.<field>...]` の形式で実行する。

**主要な操作・処理内容**：
1. リソースタイプのトップレベルフィールド一覧の表示（`kubectl explain pods`）
2. 特定フィールドの詳細表示（`kubectl explain pods.spec.containers`）
3. 全フィールドの再帰的な表示（`--recursive`）
4. 特定のAPIバージョンを指定した表示（`--api-version`）
5. 出力フォーマットの選択（plaintext / plaintext-openapiv2）

**画面遷移**：本コマンドはBasic Commands (Intermediate)カテゴリに属する。`kubectl get` で取得したリソースの構造を理解するため、また `kubectl create` や `kubectl apply` でマニフェストを作成する前にフィールド情報を確認するために使用される。

**権限による表示制御**：OpenAPI仕様の取得にはAPI Serverへの接続が必要。特別なRBAC権限は通常不要だが、API Serverへのアクセス自体には認証が必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 110 | explain | 主機能 | APIリソースのフィールドドキュメントを表示する主処理 |
| 6 | OpenAPI仕様公開 | API連携 | OpenAPI v2/v3仕様を取得してリソースフィールドの説明を表示する |

## 画面種別

CLIコマンド（参照・情報表示）

## URL/ルーティング

```
kubectl explain TYPE [--recursive=FALSE|TRUE] [--api-version=api-version-group] [-o|--output=plaintext|plaintext-openapiv2]
```

## 入出力項目

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| TYPE | string | Yes | リソースタイプ（ドット区切りでフィールドパスを指定可能） |
| -R, --recursive | bool | No | フィールドを再帰的に表示（デフォルト: false） |
| --api-version | string | No | APIバージョンの指定（例: apps/v1） |
| -o, --output | string | No | 出力フォーマット（plaintext / plaintext-openapiv2。デフォルト: plaintext） |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| KIND | リソースの種別名 |
| VERSION | APIバージョン |
| DESCRIPTION | リソース/フィールドの説明文 |
| FIELDS | フィールド一覧（名前、型、説明） |

## イベント仕様

### 1-コマンド実行（OpenAPI v3）

1. ユーザーが `kubectl explain <type>` を実行
2. `ExplainFlags.ToOptions()` でオプション変換（行96-125）:
   a. `f.ToRESTMapper()` でRESTMapperを取得
   b. `f.OpenAPIV3Client()` でOpenAPI v3クライアントを取得
3. `ExplainOptions.Validate()` でバリデーション（行168-177）:
   a. 引数が1つであることを確認
4. `ExplainOptions.Run()` で以下を実行（行180-230）:
   a. `explain.SplitAndParseResourceRequest()` でリソースタイプとフィールドパスを分離
   b. OpenAPI v3クライアントでPathsを取得可能か確認（行205）
   c. `openapiv3explain.PrintModelDescription()` でフィールド情報を出力（行221-228）

### 2-コマンド実行（OpenAPI v2フォールバック）

1. `--output=plaintext-openapiv2` 指定時、または v3 が利用不可の場合
2. `renderOpenAPIV2()` メソッドが呼ばれる（行232-264）:
   a. `Mapper.KindFor()` でGVKを取得
   b. `openAPIGetter.OpenAPISchema()` でv2スキーマを取得
   c. `resources.LookupResource()` でリソースのスキーマを取得
   d. `explain.PrintModelDescription()` でフィールド情報を出力

## データベース更新仕様

### 操作別データベース影響一覧

本コマンドは参照専用であり、データベースへの更新は発生しない。

## メッセージ仕様

| 種別 | メッセージ | 条件 |
|------|-----------|------|
| エラー | `You must specify the type of resource to explain.` | リソースタイプ未指定 |
| エラー | `We accept only this format: explain RESOURCE` | 引数が2つ以上 |
| エラー | `couldn't find resource for "<gvk>"` | リソースが見つからない場合（v2時） |

## 例外処理

| 例外条件 | 動作 |
|----------|------|
| API Server接続不可 | 接続エラーを表示して終了 |
| リソースタイプが不明 | エラーメッセージを表示して終了 |
| OpenAPI仕様の取得失敗 | エラーメッセージを表示して終了 |
| フィールドパスが不正 | フィールドが見つからないエラーを表示 |

## 備考

- OpenAPI v3 がデフォルトで使用される。v3が利用不可の場合はv2にフォールバックする。
- `--output=plaintext-openapiv2` で明示的にv2レンダラーを指定可能。
- ドット区切りでネストしたフィールドを指定可能（例: `pods.spec.containers.image`）。
- CRDのフィールドもOpenAPI仕様に含まれていれば表示可能。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | explain.go | `staging/src/k8s.io/kubectl/pkg/cmd/explain/explain.go` | `ExplainFlags` 構造体（行72-78）: APIVersion, OutputFormat, Recursive |
| 1-2 | explain.go | `staging/src/k8s.io/kubectl/pkg/cmd/explain/explain.go` | `ExplainOptions` 構造体（行150-166）: Mapper, openAPIGetter, OpenAPIV3Client |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | explain.go | `staging/src/k8s.io/kubectl/pkg/cmd/explain/explain.go` | `NewCmdExplain()` 関数（行128-148）: Flagsパターンの適用 |

**主要処理フロー**:
1. **行129**: `NewExplainFlags()` でフラグ初期化
2. **行137-142**: Run関数: ToOptions → Validate → Run

#### Step 3: メイン処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | explain.go | `staging/src/k8s.io/kubectl/pkg/cmd/explain/explain.go` | `Run()` メソッド（行180-230）: v3/v2の分岐、リソース解析 |
| 3-2 | explain.go | `staging/src/k8s.io/kubectl/pkg/cmd/explain/explain.go` | `renderOpenAPIV2()` メソッド（行232-264）: v2レンダリング |

### プログラム呼び出し階層図

```
NewCmdExplain()
    |
    +-- ExplainFlags.ToOptions()
    |       +-- f.ToRESTMapper()
    |       +-- f.OpenAPIV3Client()
    |
    +-- ExplainOptions.Validate()
    |
    +-- ExplainOptions.Run()
            |
            +-- explain.SplitAndParseResourceRequest()
            |
            +-- [plaintext-openapiv2] renderOpenAPIV2()
            |       +-- Mapper.KindFor()
            |       +-- openAPIGetter.OpenAPISchema()
            |       +-- resources.LookupResource()
            |       +-- explain.PrintModelDescription()
            |
            +-- [plaintext] OpenAPIV3Client.Paths()
                    +-- [v3利用可] openapiv3explain.PrintModelDescription()
                    +-- [v3利用不可] renderOpenAPIV2() (フォールバック)
```

### データフロー図

```
[入力]                          [処理]                              [出力]

リソースタイプ    ───────▶  SplitAndParseResourceRequest() ───▶  GVR + fieldsPath
                               |
                               v
                         OpenAPI仕様取得
                         (v3 or v2)               ───▶  Schema
                               |
                               v
                         PrintModelDescription()   ───▶  stdout (フィールド情報)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| explain.go | `staging/src/k8s.io/kubectl/pkg/cmd/explain/explain.go` | ソース | explainコマンドの主処理 |
| explain/ | `staging/src/k8s.io/kubectl/pkg/explain/` | ソース | v2レンダラー（SplitAndParseResourceRequest, PrintModelDescription） |
| explain/v2/ | `staging/src/k8s.io/kubectl/pkg/explain/v2/` | ソース | v3テンプレートレンダラー（PrintModelDescription） |
| openapi/ | `staging/src/k8s.io/kubectl/pkg/util/openapi/` | ソース | OpenAPIスキーマユーティリティ |
| openapiclient | `staging/src/k8s.io/client-go/openapi/` | ソース | OpenAPI v3クライアント |
