# 画面設計書 6-kubectl get

## 概要

本ドキュメントは、Kubernetes CLIツール `kubectl` の `get` コマンドに関する画面設計書である。`kubectl get` はKubernetesクラスタからリソースの一覧や詳細を取得・表示するコマンドであり、最も頻繁に使用されるコマンドの一つである。

### 本画面の処理概要

`kubectl get` コマンドは、API Serverからリソース情報を取得し、テーブル形式やJSON/YAML形式で表示する。ウォッチモードによるリアルタイム監視、ラベル/フィールドセレクタによるフィルタリング、ソート、チャンクサイズによるページネーション等を提供する。

**業務上の目的・背景**：Kubernetesクラスタ上のリソースの状態を確認するための基本コマンドである。Pod、Service、Deployment等あらゆるリソースの一覧取得に使用し、運用監視・デバッグ・確認作業の起点となる。

**画面へのアクセス方法**：ターミナルから `kubectl get <resource-type> [name] [options]` の形式で実行する。

**主要な操作・処理内容**：
1. リソース一覧の取得（`kubectl get pods`）
2. 特定リソースの詳細取得（`kubectl get pod <name>`）
3. 複数リソースタイプの同時取得（`kubectl get pods,services`）
4. ラベルセレクタによるフィルタリング（`-l key=value`）
5. フィールドセレクタによるフィルタリング（`--field-selector`）
6. 全名前空間からの取得（`-A` / `--all-namespaces`）
7. ウォッチモードによるリアルタイム監視（`-w` / `--watch`）
8. 各種出力フォーマット（json/yaml/wide/name/custom-columns/go-template/jsonpath）
9. ソート（`--sort-by`）
10. サブリソースの取得（`--subresource`）

**画面遷移**：本コマンドはBasic Commands (Intermediate)カテゴリに属する。`kubectl create` / `kubectl apply` でリソースを作成した後の確認、`kubectl describe` での詳細確認の前段階として使用される。`kubectl explain` で確認したフィールド情報を元にカスタムカラムを指定することも可能。

**権限による表示制御**：対象リソースに対するget/list/watch権限（RBAC）が必要。`--all-namespaces` では全名前空間に対する権限が必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 80 | リソース取得（get） | 主機能 | Kubernetesリソースの一覧取得と詳細表示を行う主処理 |
| 1 | API Serverコア | API連携 | リソース取得リクエストをAPI Serverに送信しレスポンスを受信する |
| 117 | Config管理 | 補助機能 | kubeconfigに基づくクラスター接続情報の取得 |

## 画面種別

CLIコマンド（参照・一覧表示）

## URL/ルーティング

```
kubectl get [(-o|--output=)FORMAT] (TYPE[.VERSION][.GROUP] [NAME | -l label] | TYPE[.VERSION][.GROUP]/NAME ...) [flags]
```

## 入出力項目

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| TYPE [NAME] | string[] | Yes（--rawまたは-f未指定時） | リソースタイプと名前 |
| -o, --output | string | No | 出力フォーマット（json/yaml/wide/name/custom-columns/go-template/jsonpath等） |
| -w, --watch | bool | No | 変更をリアルタイム監視 |
| --watch-only | bool | No | 初期一覧なしで変更のみ監視 |
| --output-watch-events | bool | No | ウォッチイベントをオブジェクトとして出力 |
| -l, --selector | string | No | ラベルセレクタ |
| --field-selector | string | No | フィールドセレクタ |
| -A, --all-namespaces | bool | No | 全名前空間を対象 |
| --sort-by | string | No | ソートフィールド（JSONPathExpression） |
| --no-headers | bool | No | ヘッダー行を非表示 |
| --show-labels | bool | No | ラベルカラムを表示 |
| --chunk-size | int | No | チャンクサイズ（デフォルト: 500） |
| --ignore-not-found | bool | No | NotFoundエラーを無視 |
| --subresource | string | No | サブリソース名（status等） |
| --raw | string | No | Raw URI |
| -f, --filename | string[] | No | リソース定義ファイル |
| -k, --kustomize | string | No | Kustomizeディレクトリ |
| --server-print | bool | No | サーバーサイドのテーブルカラムを使用（デフォルト: true） |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| テーブル形式出力 | NAME, READY, STATUS, RESTARTS, AGE等（リソースタイプにより異なる） |
| wide出力 | テーブル形式 + NODE, IP等の追加情報 |
| JSON/YAML出力 | リソースの完全な定義 |
| カスタムカラム | ユーザー指定のフィールドをカラムとして表示 |

## イベント仕様

### 1-通常取得

1. ユーザーが `kubectl get <type>` を実行
2. `GetOptions.Complete()` でオプション完了（行197-295）:
   a. 名前空間の取得
   b. 出力フォーマットの判定（ServerPrint, IsHumanReadablePrinter）
   c. ToPrinter関数の構築（ソート、テーブル変換等のプリンターチェーン）
3. `GetOptions.Validate()` でバリデーション（行298-320）
4. `GetOptions.Run()` で以下を実行（行443-575）:
   a. `--raw` の場合は `rawhttp.RawGet()` で直接取得（行444-449）
   b. `--watch` の場合は `watch()` メソッドへ分岐（行451-453）
   c. resource.Builderでリソースを取得（行462-475）
   d. ソート処理（`RuntimeSorter`）
   e. プリンターによる出力

### 2-ウォッチモード

1. ユーザーが `kubectl get <type> -w` を実行
2. `watch()` メソッドが呼ばれる（行608-712）:
   a. resource.Builderで初期リソースを取得
   b. 初期オブジェクトを出力
   c. `r.Watch()` でWatch APIを開始
   d. `watchtools.UntilWithoutRetry()` でイベントを継続的に受信・出力

### 3-Raw URIモード

1. ユーザーが `kubectl get --raw <uri>` を実行
2. `rawhttp.RawGet()` でAPI Serverに直接GETリクエスト（行444-449）

## データベース更新仕様

### 操作別データベース影響一覧

本コマンドは参照専用であり、データベースへの更新は発生しない。

## メッセージ仕様

| 種別 | メッセージ | 条件 |
|------|-----------|------|
| 情報 | `No resources found in <namespace> namespace.` | リソースが見つからない場合（名前空間あり） |
| 情報 | `No resources found` | リソースが見つからない場合（クラスタスコープ） |
| エラー | `You must specify the type of resource to get.` | リソースタイプ未指定 |
| エラー | `arguments may not be passed when --raw is specified` | --rawと引数の同時指定 |
| エラー | `--raw and --output are mutually exclusive` | --rawと--outputの同時指定 |
| エラー | `--raw may not be specified with other flags that filter the server request` | --rawとフィルタフラグの同時指定 |
| エラー | `--show-labels option cannot be used with <printer>` | 不正な出力フォーマットとの組み合わせ |
| エラー | `--output-watch-events option can only be used with --watch or --watch-only` | ウォッチなしでのイベント出力指定 |
| 警告 | `warning: --watch requested, --sort-by will be ignored for watch events received` | ウォッチモードでのソート指定 |

## 例外処理

| 例外条件 | 動作 |
|----------|------|
| API Server接続不可 | 接続エラーを表示して終了 |
| リソースタイプが不明 | エラーメッセージとリソース候補を表示 |
| 権限不足 | Forbiddenエラーを表示 |
| NotFound（--ignore-not-found） | エラーを無視して空出力 |

## 備考

- `--server-print` はデフォルトtrueで、サーバーサイドでTable形式に変換された結果を表示する。CRDのカスタムカラムもサポート。
- `--chunk-size` によりList APIをページネーションして大量リソースの取得を効率化する。ソート指定時はチャンクサイズが0（全件取得）に自動変更される。
- ウォッチモードでは `resourceVersion "0"` から監視を開始し、初期イベントを含む。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | get.go | `staging/src/k8s.io/kubectl/pkg/cmd/get/get.go` | `GetOptions` 構造体（行55-85）: PrintFlags, Watch, WatchOnly, ChunkSize, SortBy, ServerPrint等 |

**読解のコツ**: `ToPrinter` フィールド（行57）は関数型で、mapping情報に基づいてプリンターを動的に生成する。プリンターチェーン（ソート → スキップ → テーブル変換）の構築が `Complete()` 内で行われる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | get.go | `staging/src/k8s.io/kubectl/pkg/cmd/get/get.go` | `NewCmdGet()` 関数（行161-194）: 多数のフラグ登録 |

#### Step 3: メイン処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | get.go | `staging/src/k8s.io/kubectl/pkg/cmd/get/get.go` | `Run()` メソッド（行443-575）: raw/watch/通常の3パス |
| 3-2 | get.go | `staging/src/k8s.io/kubectl/pkg/cmd/get/get.go` | `watch()` メソッド（行608-712）: ウォッチモード |
| 3-3 | get.go | `staging/src/k8s.io/kubectl/pkg/cmd/get/get.go` | `printGeneric()` メソッド（行714-805）: 非テーブル形式の出力 |

### プログラム呼び出し階層図

```
NewCmdGet()
    |
    +-- GetOptions.Complete()
    |       +-- f.ToRawKubeConfigLoader().Namespace()
    |       +-- ToPrinter (プリンターチェーン構築)
    |               +-- SortingPrinter
    |               +-- skipPrinter
    |               +-- TablePrinter
    |
    +-- GetOptions.Validate()
    |
    +-- GetOptions.Run()
            |
            +-- [--raw] rawhttp.RawGet()
            |
            +-- [--watch] watch()
            |       +-- resource.Builder.Do()
            |       +-- r.Watch()
            |       +-- watchtools.UntilWithoutRetry()
            |
            +-- [通常] resource.Builder.Do()
                    +-- RuntimeSorter.Sort()
                    +-- printer.PrintObj() (各行出力)
```

### データフロー図

```
[入力]                          [処理]                              [出力]

リソースタイプ/名前  ───▶  resource.Builder       ───▶  resource.Info[]
                               |
                               v
                         transformRequests()
                         (Accept: Table形式)        ───▶  API Server
                               |
                               v
                         RuntimeSorter.Sort()      ───▶  ソート済みリスト
                               |
                               v
                         PrintObj()                ───▶  stdout (テーブル/JSON/YAML)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| get.go | `staging/src/k8s.io/kubectl/pkg/cmd/get/get.go` | ソース | getコマンドの主処理 |
| get_flags.go | `staging/src/k8s.io/kubectl/pkg/cmd/get/get_flags.go` | ソース | PrintFlags定義 |
| sorter.go | `staging/src/k8s.io/kubectl/pkg/cmd/get/sorter.go` | ソース | テーブルソートロジック |
| table_printer.go | `staging/src/k8s.io/kubectl/pkg/cmd/get/table_printer.go` | ソース | テーブル形式プリンター |
| humanreadable.go | `staging/src/k8s.io/kubectl/pkg/cmd/get/humanreadable.go` | ソース | 人間可読形式プリンター |
| rawhttp.go | `staging/src/k8s.io/kubectl/pkg/rawhttp/rawhttp.go` | ソース | Raw HTTPリクエスト |
