# 画面設計書 7-kubectl edit

## 概要

本ドキュメントは、Kubernetes CLIツール `kubectl` の `edit` コマンドに関する画面設計書である。`kubectl edit` はサーバー上のKubernetesリソースをエディタで対話的に編集するコマンドである。

### 本画面の処理概要

`kubectl edit` コマンドは、API Serverからリソースの現在の状態を取得し、テキストエディタで表示する。ユーザーが編集を完了してエディタを閉じると、変更分をAPI Serverに送信してリソースを更新する。

**業務上の目的・背景**：運用中のKubernetesリソースを即座に修正するためのコマンドである。マニフェストファイルを修正してapplyする手順を省略し、エディタで直接リソース定義を編集できる。環境変数の変更、ラベルの追加、コンテナ設定の微調整等の日常的な運用タスクに利用される。

**画面へのアクセス方法**：ターミナルから `kubectl edit <resource-type>/<name>` の形式で実行する。

**主要な操作・処理内容**：
1. リソースのYAML/JSON表示とエディタでの編集（`kubectl edit deployment/nginx`）
2. 出力フォーマットの指定（デフォルト: YAML、`-o json` でJSON）
3. 編集後の自動的なAPI Server更新
4. 変更差分の出力（`--output-patch`）
5. サブリソースの編集（`--subresource`）
6. バリデーション方式の指定（strict/warn/ignore）

**画面遷移**：本コマンドはBasic Commands (Intermediate)カテゴリに属する。`kubectl get` でリソースを確認した後、修正が必要な場合に使用される。編集後は `kubectl get` や `kubectl describe` で変更結果を確認できる。

**権限による表示制御**：対象リソースに対するget権限（読み取り）とupdate権限（更新）が必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 84 | リソース編集（edit） | 主機能 | エディタを使ってリソースを対話的に編集する主処理 |
| 80 | リソース取得（get） | 補助機能 | 編集対象リソースの現在の状態をAPI Serverから取得する |
| 1 | API Serverコア | API連携 | 編集済みリソースの更新リクエストをAPI Serverに送信する |

## 画面種別

CLIコマンド（リソース編集）

## URL/ルーティング

```
kubectl edit (RESOURCE/NAME | -f FILENAME)
```

## 入出力項目

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| RESOURCE/NAME / -f FILENAME | string | Yes | 編集対象のリソース指定 |
| -o, --output | string | No | 編集時のフォーマット（デフォルト: yaml、json指定可） |
| --output-patch | bool | No | 編集結果のパッチを出力（デフォルト: false） |
| --windows-line-endings | bool | No | Windows改行コードを使用 |
| --validate | string | No | バリデーション方式（strict/warn/ignore） |
| --field-manager | string | No | フィールドマネージャ名（デフォルト: kubectl-edit） |
| --subresource | string | No | サブリソース名 |
| --save-config | bool | No | 現在の設定をアノテーションに保存 |
| -f, --filename | string[] | No | リソース定義ファイル |
| -k, --kustomize | string | No | Kustomizeディレクトリ |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| エディタ画面 | リソースのYAML/JSON定義がエディタで表示される |
| 更新結果 | `<resource-type>/<name> edited` の形式 |
| パッチ出力 | `--output-patch` 時の変更差分 |

## イベント仕様

### 1-コマンド実行

1. ユーザーが `kubectl edit <type>/<name>` を実行
2. `editor.EditOptions.Complete()` でオプション完了
3. `editor.EditOptions.Validate()` でバリデーション
4. `editor.EditOptions.Run()` で以下を実行:
   a. API Serverからリソースの現在の状態を取得
   b. YAML/JSON形式に変換
   c. 一時ファイルに書き出し
   d. 環境変数 `KUBE_EDITOR` → `EDITOR` → デフォルト（vi/notepad）の優先順でエディタを決定
   e. エディタを起動し、ユーザーの編集を待機
   f. エディタ終了後、変更をパース
   g. 変更がある場合はAPI Serverに更新リクエストを送信
   h. コンフリクト発生時は最新バージョンで再度エディタを開く

### 2-編集競合処理

1. 編集中に他のユーザーがリソースを更新した場合
2. API Serverから conflict エラーが返却される
3. 一時ファイルに未適用の変更が保存される
4. エラーメッセージとともにユーザーに再編集を促す

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| リソース編集 | etcd（対象リソース） | UPDATE | エディタで変更された内容でリソースを更新 |

### テーブル別更新項目詳細

#### etcd（対象リソース）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | ユーザーが編集した全フィールド | エディタでの編集内容 | resourceVersionによる楽観的ロック |

## メッセージ仕様

| 種別 | メッセージ | 条件 |
|------|-----------|------|
| 成功 | `<resource-type>/<name> edited` | リソースが正常に更新された場合 |
| 情報 | `Edit cancelled, no changes made.` | 変更なしでエディタを閉じた場合 |
| エラー | 編集競合エラー | 他のユーザーが先にリソースを更新した場合 |
| エラー | バリデーションエラー | 編集内容が不正な場合 |

## 例外処理

| 例外条件 | 動作 |
|----------|------|
| エディタが見つからない | エディタ未設定エラーを表示 |
| 編集内容が不正なYAML/JSON | パースエラーを表示し再編集を促す |
| 編集競合（resourceVersion不一致） | 一時ファイルに変更を保存し、新バージョンで再編集 |
| API Server接続不可 | 接続エラーを表示して終了 |
| 権限不足 | Forbiddenエラーを表示 |

## 備考

- エディタの決定順序: KUBE_EDITOR環境変数 → EDITOR環境変数 → vi（Linux）/ notepad（Windows）
- シェルの決定順序: SHELL環境変数 → /bin/bash（Linux）/ cmd（Windows）
- 複数オブジェクトの同時編集が可能だが、変更は1つずつ適用される。
- 編集APIバージョンはリソース取得時のバージョンが使用される。
- `--windows-line-endings` フラグで改行コードを制御可能。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | edit.go | `staging/src/k8s.io/kubectl/pkg/cmd/edit/edit.go` | コマンド定義とフラグ登録。`editor.NewEditOptions(editor.NormalEditMode)` で初期化（行79） |
| 1-2 | editoptions.go | `staging/src/k8s.io/kubectl/pkg/cmd/util/editor/editoptions.go` | `EditOptions` 構造体の定義（主要なオプション群） |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | edit.go | `staging/src/k8s.io/kubectl/pkg/cmd/edit/edit.go` | `NewCmdEdit()` 関数（行78-108）: フラグ登録（RecordFlags, PrintFlags, FilenameOptions, validate, output-patch, windows-line-endings, field-manager, save-config, subresource） |

**主要処理フロー**:
1. **行79**: `editor.NewEditOptions(editor.NormalEditMode)` でオプション初期化
2. **行87-91**: Run関数: Complete → Validate → Run

#### Step 3: 編集処理の詳細を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | editoptions.go | `staging/src/k8s.io/kubectl/pkg/cmd/util/editor/editoptions.go` | `EditOptions.Run()` メソッド: リソース取得 → エディタ起動 → 変更適用の全フロー |

### プログラム呼び出し階層図

```
NewCmdEdit()
    |
    +-- editor.NewEditOptions(NormalEditMode)
    |
    +-- EditOptions.Complete()
    |       +-- f.NewBuilder()
    |       +-- f.ToRawKubeConfigLoader().Namespace()
    |
    +-- EditOptions.Validate()
    |
    +-- EditOptions.Run()
            +-- resource.Builder.Do() (リソース取得)
            +-- エンコード(YAML/JSON)
            +-- 一時ファイル作成
            +-- エディタ起動 (KUBE_EDITOR/EDITOR/vi)
            +-- 編集結果パース
            +-- 変更検出
            +-- [変更あり] resource.NewHelper().Patch/Replace()
            +-- [競合] 再編集ループ
```

### データフロー図

```
[入力]                          [処理]                              [出力]

リソース指定  ──────────▶  API Server GET         ───▶  リソース定義(YAML/JSON)
                               |
                               v
                         エディタ起動               ───▶  一時ファイル
                               |
                               v
                         ユーザー編集               ───▶  編集済みファイル
                               |
                               v
                         変更差分検出               ───▶  パッチ
                               |
                               v
                         API Server UPDATE/PATCH    ───▶  更新結果
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| edit.go | `staging/src/k8s.io/kubectl/pkg/cmd/edit/edit.go` | ソース | editコマンドのエントリーポイント |
| editoptions.go | `staging/src/k8s.io/kubectl/pkg/cmd/util/editor/editoptions.go` | ソース | 編集オプションと主処理 |
| editor.go | `staging/src/k8s.io/kubectl/pkg/cmd/util/editor/editor.go` | ソース | エディタ起動ロジック |
| resource.Builder | `staging/src/k8s.io/cli-runtime/pkg/resource/builder.go` | ソース | リソース取得 |
| resource.Helper | `staging/src/k8s.io/cli-runtime/pkg/resource/helper.go` | ソース | API Server通信 |
