# 画面設計書 8-kubectl delete

## 概要

本ドキュメントは、Kubernetes CLIツール `kubectl` の `delete` コマンドに関する画面設計書である。`kubectl delete` はKubernetesクラスタからリソースを削除するコマンドである。

### 本画面の処理概要

`kubectl delete` コマンドは、ファイル名、stdin、リソースタイプと名前、またはラベルセレクタを指定してリソースを削除する。グレースフルな削除、強制削除、カスケード削除をサポートする。

**業務上の目的・背景**：不要になったKubernetesリソースをクラスタから削除する。テスト環境のクリーンアップ、障害対応時のPod削除、リソースの再作成のための既存リソース削除等に使用される。グレースフル削除により、アプリケーションの正常終了を待機する猶予期間を設定できる。

**画面へのアクセス方法**：ターミナルから `kubectl delete <resource-type> <name>` または `kubectl delete -f <file>` の形式で実行する。

**主要な操作・処理内容**：
1. 名前指定による削除（`kubectl delete pod nginx`）
2. ファイル指定による削除（`kubectl delete -f pod.yaml`）
3. ラベルセレクタによる削除（`kubectl delete pods -l name=myLabel`）
4. 全リソースの削除（`kubectl delete pods --all`）
5. グレースフル削除の制御（`--grace-period`, `--now`, `--force`）
6. カスケード削除の制御（`--cascade=background/orphan/foreground`）
7. 対話的確認付き削除（`--interactive`）
8. Raw URI指定による削除（`--raw`）
9. 削除待機（`--wait`）

**画面遷移**：本コマンドはBasic Commands (Intermediate)カテゴリに属する。`kubectl get` でリソースを確認した後、不要なリソースを削除するために使用される。Deployment削除時はOwnerReferenceに基づきReplicaSetやPodもカスケード削除される。

**権限による表示制御**：対象リソースに対するdelete権限（RBAC）が必要。クラスタスコープリソースの削除では追加の警告が表示される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 83 | リソース削除（delete） | 主機能 | Kubernetesリソースを削除する主処理 |
| 1 | API Serverコア | API連携 | リソース削除リクエストをAPI Serverに送信する |
| 21 | Garbage Collectorコントローラー | API連携 | 削除時にOwnerReferenceに基づくカスケード削除が発動する |

## 画面種別

CLIコマンド（リソース削除）

## URL/ルーティング

```
kubectl delete ([-f FILENAME] | [-k DIRECTORY] | TYPE [(NAME | -l label | --all)])
```

## 入出力項目

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| TYPE NAME / -f FILENAME / -l label | string | Yes | 削除対象の指定方法 |
| -f, --filename | string[] | No | リソース定義ファイル |
| -k, --kustomize | string | No | Kustomizeディレクトリ |
| -l, --selector | string | No | ラベルセレクタ |
| --field-selector | string | No | フィールドセレクタ |
| --all | bool | No | 指定タイプの全リソースを削除 |
| -A, --all-namespaces | bool | No | 全名前空間で削除 |
| --cascade | string | No | カスケード戦略（background/orphan/foreground。デフォルト: background） |
| --grace-period | int | No | グレース期間（秒）。-1でデフォルト |
| --now | bool | No | グレース期間を1秒に設定 |
| --force | bool | No | 強制削除（グレース期間0） |
| --wait | bool | No | 削除完了まで待機（デフォルト: true） |
| --timeout | duration | No | 待機タイムアウト |
| --ignore-not-found | bool | No | NotFoundエラーを無視 |
| --interactive | bool | No | 削除前に確認を求める |
| --raw | string | No | Raw URI |
| --dry-run | string | No | ドライランモード |
| -o, --output | string | No | 出力モード（nameのみサポート） |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| 削除結果 | `<resource-type> "<name>" deleted` / `force deleted` の形式 |
| 対話的確認 | `--interactive` 時の確認プロンプトとリソース一覧 |
| 名前空間情報 | `deleted from <namespace> namespace` |
| 警告 | クラスタスコープリソース削除時の警告 |

## イベント仕様

### 1-通常削除

1. ユーザーが `kubectl delete <type> <name>` を実行
2. `DeleteOptions.Complete()` でオプション完了（行171-267）:
   a. 名前空間の取得
   b. `--now` / `--grace-period` / `--force` の整合性チェック（行185-198）
   c. resource.Builderでリソースを検索（行214-226）
   d. `--interactive` の場合はプレビュー用の結果も構築（行232-254）
3. `DeleteOptions.Validate()` でバリデーション（行269-317）
4. `DeleteOptions.RunDelete()` で以下を実行（行319-364）:
   a. `--raw` の場合は `rawhttp.RawDelete()` で直接削除（行320-329）
   b. `--interactive` の場合は確認プロンプト表示（行331-361）
   c. `DeleteResult()` で実際の削除を実行

### 2-DeleteResult処理

`DeleteResult()` メソッド（行366-477）:
1. 各リソースに対してVisitパターンで削除を実行
2. `deleteResource()` でAPI Serverに削除リクエスト送信（行479-492）
3. `--wait` が有効な場合は `cmdwait.WaitOptions.RunWait()` で削除完了を待機

### 3-対話的削除

1. `--interactive` フラグ指定時
2. `confirmation()` メソッドで削除予定リソースの一覧を表示（行529-548）
3. ユーザーに "y/N" の入力を求める
4. "y" の場合のみ削除を実行

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| リソース削除 | etcd（対象リソース） | DELETE | 指定されたリソースをetcdから削除 |
| カスケード削除 | etcd（子リソース） | DELETE | OwnerReferenceに基づく子リソースの自動削除（GC担当） |

## メッセージ仕様

| 種別 | メッセージ | 条件 |
|------|-----------|------|
| 成功 | `<type> "<name>" deleted` | 通常削除成功 |
| 成功 | `<type> "<name>" force deleted` | 強制削除成功 |
| 成功 | `<type> "<name>" deleted from <ns> namespace` | 名前空間付き |
| 成功 | `<type> "<name>" deleted (dry run)` / `(server dry run)` | ドライラン時 |
| 情報 | `No resources found` | 削除対象が見つからない場合 |
| 情報 | `You are about to delete the following N resource(s):` | --interactive時 |
| 情報 | `deletion is cancelled` | --interactive時にキャンセル |
| 警告 | `Immediate deletion does not wait for confirmation...` | --force --grace-period=0時 |
| 警告 | `deleting cluster-scoped resources, not scoped to the provided namespace` | クラスタスコープリソース削除時 |
| エラー | `--now and --grace-period cannot be specified together` | --nowと--grace-periodの同時指定 |
| エラー | `--force and --grace-period greater than 0 cannot be specified together` | --forceとgrace-period>0の同時指定 |
| エラー | `cannot set --all and --selector at the same time` | --allと-lの同時指定 |
| エラー | `cannot set --all and --field-selector at the same time` | --allと--field-selectorの同時指定 |
| エラー | `unexpected -o output mode` | name以外の出力モード指定 |
| エラー | `--interactive can not be used with --raw` | --interactiveと--rawの同時指定 |

## 例外処理

| 例外条件 | 動作 |
|----------|------|
| リソースが存在しない | `--ignore-not-found` 時はエラーを無視、それ以外はNotFoundエラー |
| 権限不足 | Forbiddenエラーを表示 |
| API Server接続不可 | 接続エラーを表示 |
| 削除待機タイムアウト | タイムアウトエラーを表示 |
| ウォッチ権限不足 | 待機をスキップして正常終了 |

## 備考

- `--grace-period=0` 単独指定はデータ安全のため内部的に `grace-period=1` に変換される。`--force` と組み合わせた場合のみ真の即時削除となる。
- `--cascade=orphan` で子リソースを残したまま親リソースのみ削除可能。
- CRD削除後のディスカバリーキャッシュ無効化には最大6時間かかる場合がある。
- `-o name` 形式の出力では `<type>/<name>` のみが出力される。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | delete.go | `staging/src/k8s.io/kubectl/pkg/cmd/delete/delete.go` | `DeleteOptions` 構造体（行111-143）: CascadingStrategy, GracePeriod, ForceDeletion, WaitForDeletion, Interactive等 |

**読解のコツ**: `CascadingStrategy` は `metav1.DeletionPropagation` 型で、Background/Foreground/Orphanの3値を取る。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | delete.go | `staging/src/k8s.io/kubectl/pkg/cmd/delete/delete.go` | `NewCmdDelete()` 関数（行145-169）: DeleteCommandFlagsパターン |

#### Step 3: メイン処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | delete.go | `staging/src/k8s.io/kubectl/pkg/cmd/delete/delete.go` | `Complete()` メソッド（行171-267）: grace-period整合性、resource.Builder構築 |
| 3-2 | delete.go | `staging/src/k8s.io/kubectl/pkg/cmd/delete/delete.go` | `Validate()` メソッド（行269-317）: フラグ排他制約、--raw制約 |
| 3-3 | delete.go | `staging/src/k8s.io/kubectl/pkg/cmd/delete/delete.go` | `RunDelete()` メソッド（行319-364）: interactive確認、削除実行 |
| 3-4 | delete.go | `staging/src/k8s.io/kubectl/pkg/cmd/delete/delete.go` | `DeleteResult()` メソッド（行366-477）: リソース個別削除、待機処理 |
| 3-5 | delete.go | `staging/src/k8s.io/kubectl/pkg/cmd/delete/delete.go` | `deleteResource()` メソッド（行479-492）: API Server削除リクエスト |

### プログラム呼び出し階層図

```
NewCmdDelete()
    |
    +-- DeleteCommandFlags.ToOptions()
    |
    +-- DeleteOptions.Complete()
    |       +-- f.ToRawKubeConfigLoader().Namespace()
    |       +-- resource.Builder.Do()
    |       +-- [--interactive] プレビュー用Builder構築
    |
    +-- DeleteOptions.Validate()
    |
    +-- DeleteOptions.RunDelete()
            |
            +-- [--raw] rawhttp.RawDelete()
            |
            +-- [--interactive] confirmation()
            |
            +-- DeleteResult()
                    +-- r.Visit()
                    |       +-- deleteResource()
                    |               +-- resource.NewHelper().DeleteWithOptions()
                    |
                    +-- [--wait] cmdwait.WaitOptions.RunWait()
```

### データフロー図

```
[入力]                          [処理]                              [出力]

リソース指定  ──────────▶  resource.Builder       ───▶  resource.Info[]
                               |
                               v
                         [--interactive] confirmation() ───▶  確認プロンプト
                               |
                               v
                         resource.NewHelper()
                         .DeleteWithOptions()       ───▶  API Server (etcd)
                               |
                               v
                         [--wait] WaitOptions.RunWait() ───▶  削除完了待機
                               |
                               v
                         PrintObj()                ───▶  stdout (削除結果)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| delete.go | `staging/src/k8s.io/kubectl/pkg/cmd/delete/delete.go` | ソース | deleteコマンドの主処理 |
| delete_flags.go | `staging/src/k8s.io/kubectl/pkg/cmd/delete/delete_flags.go` | ソース | DeleteCommandFlagsの定義 |
| wait.go | `staging/src/k8s.io/kubectl/pkg/cmd/wait/wait.go` | ソース | 削除完了待機ロジック |
| rawhttp.go | `staging/src/k8s.io/kubectl/pkg/rawhttp/rawhttp.go` | ソース | Raw HTTPリクエスト |
