# 画面設計書 9-kubectl rollout

## 概要

本ドキュメントは、Kubernetes CLIツール `kubectl` の `rollout` コマンドに関する画面設計書である。`kubectl rollout` はDeployment、DaemonSet、StatefulSetのロールアウト（デプロイ操作）を管理するコマンド群を提供する。

### 本画面の処理概要

`kubectl rollout` は親コマンドとして6つのサブコマンドを束ね、ワークロードリソースのロールアウト状態の確認、一時停止、再開、再起動、ロールバック、履歴確認を提供する。

**業務上の目的・背景**：Kubernetesにおけるアプリケーションのデプロイメントライフサイクルを管理する。新バージョンのデプロイ状況の監視、問題発生時のロールバック、メンテナンスのためのロールアウト一時停止・再開、ローリングリスタート等の運用タスクに使用される。

**画面へのアクセス方法**：ターミナルから `kubectl rollout <subcommand> <resource>` の形式で実行する。

**主要な操作・処理内容**：
1. `kubectl rollout status` - ロールアウトの進行状況を監視
2. `kubectl rollout history` - ロールアウト履歴の表示
3. `kubectl rollout undo` - 前のリビジョンへのロールバック
4. `kubectl rollout pause` - ロールアウトの一時停止
5. `kubectl rollout resume` - 一時停止したロールアウトの再開
6. `kubectl rollout restart` - ローリングリスタートのトリガー

**画面遷移**：本コマンドはDeploy Commandsカテゴリに属する。`kubectl set image` やその他の更新操作がロールアウトをトリガーし、`kubectl rollout status` で状態を監視する。問題があれば `kubectl rollout undo` でロールバックする。メンテナンスフロー（`kubectl apply` → `kubectl rollout status`）の一部。

**権限による表示制御**：対象リソース（Deployment/DaemonSet/StatefulSet）に対するget/update/patch権限が必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 90 | ロールアウト管理（rollout） | 主機能 | Deploymentのロールアウト状態確認、一時停止、再開、ロールバックを行う主処理 |
| 7 | Deploymentコントローラー | API連携 | ロールアウト操作の結果としてDeploymentコントローラーがローリングアップデートを制御する |
| 8 | ReplicaSetコントローラー | API連携 | ロールアウト時にReplicaSetの作成・スケーリングが行われる |

## 画面種別

CLIコマンド（デプロイ管理）- サブコマンド群の親コマンド

## URL/ルーティング

```
kubectl rollout SUBCOMMAND
```

サブコマンド: `history`, `pause`, `restart`, `resume`, `status`, `undo`

対象リソース: deployments, daemonsets, statefulsets

## 入出力項目

### rollout status 固有オプション

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| RESOURCE | string | Yes | 対象リソース（deployment/name等） |
| --watch | bool | No | ロールアウト完了まで監視（デフォルト: true） |
| --timeout | duration | No | 監視タイムアウト |
| --revision | int | No | 特定リビジョンの状態を表示 |

### rollout history 固有オプション

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| RESOURCE | string | Yes | 対象リソース |
| --revision | int | No | 特定リビジョンの詳細を表示 |

### rollout undo 固有オプション

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| RESOURCE | string | Yes | 対象リソース |
| --to-revision | int | No | ロールバック先のリビジョン番号（デフォルト: 前回リビジョン） |
| --dry-run | string | No | ドライランモード |

### rollout restart 固有オプション

| 項目名 | 型 | 必須 | 説明 |
|--------|-----|------|------|
| RESOURCE | string | Yes | 対象リソース |
| -l, --selector | string | No | ラベルセレクタで対象を絞り込み |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| ロールアウト状態 | `Waiting for deployment "nginx" rollout to finish...` 等の進行状況 |
| ロールアウト履歴 | リビジョン番号と変更理由のテーブル |
| ロールバック結果 | `deployment.apps/nginx rolled back` |
| 一時停止/再開結果 | `deployment.apps/nginx paused` / `resumed` |
| リスタート結果 | `deployment.apps/nginx restarted` |

## イベント仕様

### 1-rollout status 実行

1. ユーザーが `kubectl rollout status deployment/nginx` を実行
2. 対象リソースの現在の状態をAPI Serverから取得
3. `StatusViewer` インターフェースでロールアウト状態を判定
4. `--watch` が有効な場合、完了までWatch APIで監視
5. 完了または失敗を検出して結果を出力

### 2-rollout undo 実行

1. ユーザーが `kubectl rollout undo deployment/nginx` を実行
2. 対象リソースのリビジョン履歴を取得
3. `--to-revision` 指定時はそのリビジョン、未指定時は前回リビジョンを特定
4. リビジョンのPodTemplateSpecを現在のDeploymentに適用
5. API Serverにパッチを送信

### 3-rollout restart 実行

1. ユーザーが `kubectl rollout restart deployment/nginx` を実行
2. PodTemplateSpecのアノテーション `kubectl.kubernetes.io/restartedAt` に現在時刻を設定
3. API Serverにパッチを送信
4. Deploymentコントローラーがローリングリスタートを開始

### 4-rollout pause/resume 実行

1. ユーザーが `kubectl rollout pause deployment/nginx` を実行
2. Deploymentの `.spec.paused` フィールドをtrue/falseに設定
3. API Serverにパッチを送信

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| rollout status | なし | SELECT | 参照のみ |
| rollout history | なし | SELECT | 参照のみ |
| rollout undo | etcd（Deployment/DaemonSet/StatefulSet） | UPDATE（PATCH） | PodTemplateSpecの更新 |
| rollout pause | etcd（Deployment） | UPDATE（PATCH） | spec.pausedフィールドの更新 |
| rollout resume | etcd（Deployment） | UPDATE（PATCH） | spec.pausedフィールドの更新 |
| rollout restart | etcd（Deployment/DaemonSet/StatefulSet） | UPDATE（PATCH） | restartedAtアノテーションの更新 |

## メッセージ仕様

| 種別 | メッセージ | 条件 |
|------|-----------|------|
| 成功 | `deployment.apps/<name> successfully rolled out` | ロールアウト完了 |
| 成功 | `deployment.apps/<name> rolled back` | ロールバック完了 |
| 成功 | `deployment.apps/<name> paused` | 一時停止完了 |
| 成功 | `deployment.apps/<name> resumed` | 再開完了 |
| 成功 | `deployment.apps/<name> restarted` | リスタート完了 |
| 情報 | `Waiting for deployment "<name>" rollout to finish: X out of Y new replicas have been updated...` | ロールアウト進行中 |
| エラー | サブコマンド未指定時のヘルプ表示 | 親コマンドのみ実行時 |

## 例外処理

| 例外条件 | 動作 |
|----------|------|
| 対象リソースが存在しない | NotFoundエラーを表示 |
| 指定リビジョンが存在しない | エラーメッセージを表示 |
| ロールアウトタイムアウト | タイムアウトエラーを表示 |
| 権限不足 | Forbiddenエラーを表示 |
| 非対応リソースタイプ | エラーメッセージを表示 |

## 備考

- 対象リソースはdeployments、daemonsets、statefulsetsの3種類のみ。
- `rollout restart` はPodTemplateSpecのアノテーションを更新することでローリングリスタートをトリガーする仕組みであり、リソースの実際のspecは変更しない。
- `rollout pause` はDeploymentのみ有効で、DaemonSetやStatefulSetには適用されない。
- ロールバック時のリビジョン情報はReplicaSetのアノテーション `deployment.kubernetes.io/revision` に格納されている。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | rollout.go | `staging/src/k8s.io/kubectl/pkg/cmd/rollout/rollout.go` | `NewCmdRollout()` 関数（行57-75）: 6サブコマンドの登録 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | rollout.go | `staging/src/k8s.io/kubectl/pkg/cmd/rollout/rollout.go` | 親コマンド定義。対象リソースとして deployments, daemonsets, statefulsets を明記（行47-53） |

**主要処理フロー**:
1. **行58-65**: cobra.Command定義、`DefaultSubCommandRun`
2. **行67-73**: 6サブコマンド（history, pause, resume, undo, status, restart）の登録

#### Step 3: 各サブコマンドの処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | rollout_status.go | `staging/src/k8s.io/kubectl/pkg/cmd/rollout/rollout_status.go` | ロールアウト状態監視 |
| 3-2 | rollout_undo.go | `staging/src/k8s.io/kubectl/pkg/cmd/rollout/rollout_undo.go` | ロールバック処理 |
| 3-3 | rollout_restart.go | `staging/src/k8s.io/kubectl/pkg/cmd/rollout/rollout_restart.go` | ローリングリスタート |
| 3-4 | rollout_pause.go | `staging/src/k8s.io/kubectl/pkg/cmd/rollout/rollout_pause.go` | 一時停止 |
| 3-5 | rollout_resume.go | `staging/src/k8s.io/kubectl/pkg/cmd/rollout/rollout_resume.go` | 再開 |
| 3-6 | rollout_history.go | `staging/src/k8s.io/kubectl/pkg/cmd/rollout/rollout_history.go` | 履歴表示 |

### プログラム呼び出し階層図

```
NewCmdRollout()
    |
    +-- NewCmdRolloutStatus()
    |       +-- StatusViewerFor()
    |       +-- Watch API による状態監視
    |
    +-- NewCmdRolloutHistory()
    |       +-- HistoryViewerFor()
    |       +-- ReplicaSet リビジョン一覧取得
    |
    +-- NewCmdRolloutUndo()
    |       +-- RollbackerFor()
    |       +-- リビジョンのPodTemplateSpec適用
    |
    +-- NewCmdRolloutPause()
    |       +-- spec.paused = true パッチ
    |
    +-- NewCmdRolloutResume()
    |       +-- spec.paused = false パッチ
    |
    +-- NewCmdRolloutRestart()
            +-- restartedAt アノテーション パッチ
```

### データフロー図

```
[入力]                          [処理]                              [出力]

サブコマンド + リソース  ───▶  API Server GET         ───▶  リソース状態取得
                               |
                               v
                         [status] Watch API         ───▶  進行状況表示
                         [undo] Rollbacker          ───▶  PodTemplateSpec更新
                         [restart] Patch            ───▶  restartedAtアノテーション
                         [pause/resume] Patch       ───▶  spec.paused更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| rollout.go | `staging/src/k8s.io/kubectl/pkg/cmd/rollout/rollout.go` | ソース | 親コマンド |
| rollout_status.go | `staging/src/k8s.io/kubectl/pkg/cmd/rollout/rollout_status.go` | ソース | statusサブコマンド |
| rollout_history.go | `staging/src/k8s.io/kubectl/pkg/cmd/rollout/rollout_history.go` | ソース | historyサブコマンド |
| rollout_undo.go | `staging/src/k8s.io/kubectl/pkg/cmd/rollout/rollout_undo.go` | ソース | undoサブコマンド |
| rollout_pause.go | `staging/src/k8s.io/kubectl/pkg/cmd/rollout/rollout_pause.go` | ソース | pauseサブコマンド |
| rollout_resume.go | `staging/src/k8s.io/kubectl/pkg/cmd/rollout/rollout_resume.go` | ソース | resumeサブコマンド |
| rollout_restart.go | `staging/src/k8s.io/kubectl/pkg/cmd/rollout/rollout_restart.go` | ソース | restartサブコマンド |
| polymorphichelpers | `staging/src/k8s.io/kubectl/pkg/polymorphichelpers/` | ソース | StatusViewer, HistoryViewer, Rollbacker等 |
