---
generated_at: 2026-02-02 10:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：1-kubectl_create 画面設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **Admission Webhook連携の詳細動作**：根拠不足（API Server側の動作のため）
  2. **etcd永続化の詳細**：根拠不足（kubectl側のコードからは間接的にのみ確認可能）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `staging/src/k8s.io/kubectl/pkg/cmd/create/create.go` - CreateOptions構造体、NewCmdCreate、Validate、RunCreate
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面No.1の定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング（No.1行）
- E-04: `docs/code-to-docs/画面一覧/画面遷移図.md` - kubectl createのコマンド階層

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | createコマンドはJSON/YAML形式のマニフェストからリソースを作成する | E-01 (行73-76: createLong) | ○ |
| C-02 | 17種のサブコマンドが存在する | E-01 (行136-153: AddCommand呼び出し) | ○ |
| C-03 | --editオプションで作成前に編集可能 | E-01 (行124, 236-238) | ○ |
| C-04 | --rawオプションで直接API ServerにPOST可能 | E-01 (行130, 228-234) | ○ |
| C-05 | --rawと--editは排他的 | E-01 (行163-165: Validate) | ○ |
| C-06 | --rawは単一ファイルのみ対応 | E-01 (行166-168: Validate) | ○ |
| C-07 | --rawはURLからの読み込み不可 | E-01 (行169-171: Validate) | ○ |
| C-08 | --rawと--recursiveは排他的 | E-01 (行172-174: Validate) | ○ |
| C-09 | --rawと--selectorは排他的 | E-01 (行175-177: Validate) | ○ |
| C-10 | --rawと--outputは排他的 | E-01 (行178-180: Validate) | ○ |
| C-11 | 不正な引数がある場合エラーを返す | E-01 (行191-193: Complete) | ○ |
| C-12 | DryRunStrategyの取得とフラグ連携 | E-01 (行201-205: Complete) | ○ |
| C-13 | field-managerのデフォルト値は"kubectl-create" | E-01 (行131) | ○ |
| C-14 | resource.Builderによるリソース構築 | E-01 (行250-258: RunCreate) | ○ |
| C-15 | resource.NewHelper().Create()によるAPI Server送信 | E-01 (行278-283: RunCreate) | ○ |
| C-16 | 作成オブジェクト数が0の場合エラー | E-01 (行297-299: RunCreate) | ○ |
| C-17 | RunEditOnCreateでeditor.NewEditOptionsを使用 | E-01 (行304-324) | ○ |
| C-18 | CreateSubcommandOptions.RunでStructuredGeneratorを使用 | E-01 (行420-421) | ○ |
| C-19 | サブコマンドではDynamicClientでリソース作成 | E-01 (行456) | ○ |
| C-20 | BasicCommands(Beginner)カテゴリに属する | E-02 (行2) | ○ |
| C-21 | 主機能はリソース作成（create）、機能No.81 | E-03 (行2) | ○ |
| C-22 | API Serverコア（機能No.1）とAPI連携 | E-03 (行3) | ○ |
| C-23 | アドミッション制御（機能No.4）による検証 | E-03 (行4) | ○ |
| C-24 | Admission Webhookの詳細動作（Mutating/Validating） | **根拠なし** | △ |
| C-25 | etcdへの永続化の詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Admission Webhookの詳細動作はAPI Server側の実装に依存するため、kubectlのソースコードからは間接的にのみ確認可能
  - 候補：`staging/src/k8s.io/apiserver/` / Admission Webhookドキュメント / Kubernetes公式ドキュメント
- etcdへの永続化はAPI Serverの内部処理であり、kubectlクライアントからは確認不可
  - 候補：`pkg/registry/` / etcdストレージ実装 / API Serverソースコード

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コマンドの入出力項目、フラグ定義、バリデーションルールはソースコードから直接確認済み
- 0: 低リスク - サブコマンド一覧はNewCmdCreate内のAddCommand呼び出しから網羅的に確認済み
- 1: 中リスク - Admission WebhookやetcdへのデータフローはAPI Server側の動作に依存

## 6) レビュアーチェックリスト（最小）
- [ ] 17種のサブコマンドが最新のソースコードと一致しているか確認
- [ ] フラグのデフォルト値が最新のソースコードと一致しているか確認
- [ ] エラーメッセージの網羅性を確認（ソースコード中の他のエラーパスが漏れていないか）
- [ ] Admission Webhook連携の記述が実際の動作と一致しているか確認
