---
generated_at: 2026-02-02 10:45:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：10-kubectl_scale 画面設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **Deployment/ReplicaSetコントローラーの詳細動作**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `staging/src/k8s.io/kubectl/pkg/cmd/scale/scale.go` - 主要ソースコード
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面No.10の定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Deployment, ReplicaSet, RC, StatefulSetのレプリカ数を変更 | E-01 (行41-48: scaleLong) | ○ |
| C-02 | --replicasは必須フラグ | E-01 (行132) | ○ |
| C-03 | validArgsに4つのリソースタイプ | E-01 (行109) | ○ |
| C-04 | --current-replicasのデフォルトは-1 | E-01 (行99) | ○ |
| C-05 | Validate()でreplicas >= 0を確認 | E-01 (行181-183) | ○ |
| C-06 | Validate()でcurrent-replicas >= -1を確認 | E-01 (行185-187) | ○ |
| C-07 | resource-versionで複数リソースは不可 | E-01 (行214-216) | ○ |
| C-08 | ScalePreconditionの構築条件 | E-01 (行220-223) | ○ |
| C-09 | RetryParamsは1秒間隔、最大5分 | E-01 (行224) | ○ |
| C-10 | Timeout!=0かつDryRunNoneでwaitForReplicas構築 | E-01 (行227-229) | ○ |
| C-11 | scaler.Scale()でスケーリング実行 | E-01 (行247) | ○ |
| C-12 | DryRunClient時はPrintObjのみ | E-01 (行240-244) | ○ |
| C-13 | Recorder.MakeRecordMergePatch()でパッチ記録 | E-01 (行252) | ○ |
| C-14 | resource.NewHelper().Patch()でパッチ適用 | E-01 (行260) | ○ |
| C-15 | scaler()関数でcmdutil.ScaleClientFn使用 | E-01 (行274-275) | ○ |
| C-16 | scale.NewScaler()でScaler初期化 | E-01 (行280) | ○ |
| C-17 | PrintObj()で結果出力 | E-01 (行265-268) | ○ |
| C-18 | 主機能はスケーリング（scale）、機能No.91 | E-03 | ○ |
| C-19 | Deploymentコントローラー（機能No.7）との連携 | E-03 | ○ |
| C-20 | Deployment/ReplicaSetコントローラーの詳細動作 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Deployment/ReplicaSetコントローラーがどのようにスケーリングを実行するかはkube-controller-manager側の実装
  - 候補：`pkg/controller/deployment/` / `pkg/controller/replicaset/`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コマンドフラグ、バリデーション、スケーリング処理はソースコードから直接確認済み
- 0: 低リスク - ScalePrecondition、RetryParamsの設定値はソースコードから確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] --replicasのバリデーション条件が正確か確認
- [ ] ScalePreconditionの構築条件が正確か確認
- [ ] RetryParamsの設定値（1秒、5分）が最新か確認
- [ ] Scale サブリソースAPIの呼び出し方法が正確か確認
