---
generated_at: 2026-02-02 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：11-kubectl autoscale 画面設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **RBAC権限要件**：権限不足時の具体的な挙動はソースコード内に明示的な記載がなく、Kubernetes共通仕様からの推測
  2. **HPAコントローラーとの連携**：作成後のHPAコントローラーの動作はautoscaleコマンドのスコープ外
  3. **Metrics Server連携**：HPAコントローラー側の処理であり、autoscaleコマンド自体には含まれない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `staging/src/k8s.io/kubectl/pkg/cmd/autoscale/autoscale.go` L73-102（AutoscaleOptions構造体）
- E-02: `staging/src/k8s.io/kubectl/pkg/cmd/autoscale/autoscale.go` L117-153（NewCmdAutoscale関数）
- E-03: `staging/src/k8s.io/kubectl/pkg/cmd/autoscale/autoscale.go` L156-197（Completeメソッド）
- E-04: `staging/src/k8s.io/kubectl/pkg/cmd/autoscale/autoscale.go` L200-224（Validateメソッド）
- E-05: `staging/src/k8s.io/kubectl/pkg/cmd/autoscale/autoscale.go` L226-280（Runメソッド）
- E-06: `staging/src/k8s.io/kubectl/pkg/cmd/autoscale/autoscale.go` L282-292（canCreateHPAV1メソッド）
- E-07: `staging/src/k8s.io/kubectl/pkg/cmd/autoscale/autoscale.go` L295-339（handleHPAメソッド）
- E-08: `staging/src/k8s.io/kubectl/pkg/cmd/autoscale/autoscale.go` L341-446（createHorizontalPodAutoscalerV2メソッド）
- E-09: `staging/src/k8s.io/kubectl/pkg/cmd/autoscale/autoscale.go` L448-482（createHorizontalPodAutoscalerV1メソッド）
- E-10: `staging/src/k8s.io/kubectl/pkg/cmd/autoscale/autoscale.go` L491-528（parseResourceInput関数）
- E-11: `staging/src/k8s.io/kubectl/pkg/cmd/autoscale/autoscale.go` L530-539（getDefaultUnitForResource関数）
- E-12: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 画面No.11行
- E-13: `docs/code-to-docs/画面一覧/画面一覧.csv` No.11行

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | autoscaleコマンドはDeployment/ReplicaSet/StatefulSet/ReplicationControllerを対象とする | E-02 L120 validArgs定義 | ○ |
| C-02 | --maxフラグは必須で1以上の値が必要 | E-02 L141, E-04 L201-203 | ○ |
| C-03 | --maxが--min未満の場合エラー | E-04 L204-206 | ○ |
| C-04 | --cpu-percentと--cpuは排他的 | E-04 L208-209 | ○ |
| C-05 | autoscaling/v2を優先しv1にフォールバックする | E-05 L254-269 | ○ |
| C-06 | v1フォールバックはCPUPercent使用時かつメモリ未指定時のみ可能 | E-06 L282-292 | ○ |
| C-07 | HPAClientV2/V1のCreate呼び出しでAPI Serverにリクエスト送信 | E-07 L322-327 | ○ |
| C-08 | dry-run=clientの場合はAPI Serverに送信せず結果を表示 | E-07 L300-306 | ○ |
| C-09 | CPU値が百分率の場合はUtilizationMetricType | E-10 L498-503 | ○ |
| C-10 | CPU値が数量の場合はAverageValueMetricType | E-10 L507-519 | ○ |
| C-11 | 単位なし数値はCPUでmilliCPU、メモリでMebibyte | E-11 L530-539 | ○ |
| C-12 | --nameフラグ未指定時は対象リソース名をHPA名に使用 | E-08 L342-345 | ○ |
| C-13 | --cpu-percentフラグは非推奨 | E-02 L146-147 MarkDeprecated | ○ |
| C-14 | フィールドマネージャのデフォルトは"kubectl-autoscale" | E-02 L151 | ○ |
| C-15 | 対象リソースが0件の場合「no objects passed to autoscale」エラー | E-05 L276-278 | ○ |
| C-16 | スケール非対応リソースで「cannot autoscale a <Kind>」エラー | E-05 L248 | ○ |
| C-17 | HPAリソースの作成にautoscaling APIグループのcreate権限が必要 | E-12（画面機能マッピング）推測 | △ |
| C-18 | 関連機能はオートスケール設定(92)、HPAコントローラー(23)、メトリクスサーバー連携(151) | E-12 | ○ |

## 4) 不足情報（Unknown / Missing）
- C-17のRBAC権限要件は、Kubernetesの共通RBAC仕組みからの推測であり、autoscale.goに明示的なRBACチェックコードはない（API Serverが行う）。
  - 候補：Kubernetes RBAC公式ドキュメント / API Serverの認可処理コード / E2Eテスト

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コマンドオプションの仕様はソースコードから直接確認可能
- 0: 低リスク - v2/v1フォールバックロジックはソースコードに明確に実装
- 1: 中リスク - RBAC権限要件は推測に基づく記載

## 6) レビュアーチェックリスト（最小）
- [ ] v2/v1フォールバック条件がcanCreateHPAV1の実装と一致するか確認
- [ ] CPU/メモリ値のパース仕様がparseResourceInput実装と一致するか確認
- [ ] RBAC権限要件が実際のクラスター動作と一致するか確認
- [ ] エラーメッセージがソースコードの文字列リテラルと一致するか確認
