---
generated_at: 2026-02-02 10:05:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：12-kubectl certificate 画面設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  1. 特になし - 全ての主張にソースコードの根拠あり
  2. セキュリティ警告の記載内容は英語原文からの翻訳正確性を確認すること
  3. コンフリクトリトライ回数の妥当性は運用観点で確認

## 2) 参照した情報（Evidence一覧）

- E-01: `staging/src/k8s.io/kubectl/pkg/cmd/certificates/certificates.go` L44-59（NewCmdCertificate）
- E-02: `staging/src/k8s.io/kubectl/pkg/cmd/certificates/certificates.go` L62-75（CertificateOptions）
- E-03: `staging/src/k8s.io/kubectl/pkg/cmd/certificates/certificates.go` L86-112（Complete）
- E-04: `staging/src/k8s.io/kubectl/pkg/cmd/certificates/certificates.go` L115-120（Validate）
- E-05: `staging/src/k8s.io/kubectl/pkg/cmd/certificates/certificates.go` L123-159（NewCmdCertificateApprove）
- E-06: `staging/src/k8s.io/kubectl/pkg/cmd/certificates/certificates.go` L162-168（RunCertificateApprove）
- E-07: `staging/src/k8s.io/kubectl/pkg/cmd/certificates/certificates.go` L171-202（NewCmdCertificateDeny）
- E-08: `staging/src/k8s.io/kubectl/pkg/cmd/certificates/certificates.go` L205-211（RunCertificateDeny）
- E-09: `staging/src/k8s.io/kubectl/pkg/cmd/certificates/certificates.go` L213-277（modifyCertificateCondition）
- E-10: `staging/src/k8s.io/kubectl/pkg/cmd/certificates/certificates.go` L279-306（addConditionIfNeeded）
- E-11: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 画面No.12行
- E-12: `docs/code-to-docs/画面一覧/画面一覧.csv` No.12行

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | certificateコマンドはapproveとdenyの2つのサブコマンドを持つ | E-01 L55-56 | ○ |
| C-02 | approve時の条件タイプはApproved、理由はKubectlApprove | E-06 L166 | ○ |
| C-03 | deny時の条件タイプはDenied、理由はKubectlDeny | E-08 L209 | ○ |
| C-04 | approve時に既にDenied済みの場合エラー | E-10 L284-286 | ○ |
| C-05 | deny時に既にApproved済みの場合エラー | E-10 L284-286（逆パターン） | ○ |
| C-06 | --forceフラグで既存状態を上書き可能 | E-09 L250 | ○ |
| C-07 | CSR名が1つ以上必要 | E-04 L116-118 | ○ |
| C-08 | UpdateApproval APIを使用してCSRを更新 | E-09 L252 | ○ |
| C-09 | コンフリクト時は最大10回リトライ | E-09 L257 | ○ |
| C-10 | 承認メッセージは「This CSR was approved by kubectl certificate approve.」 | E-06 L166-167 | ○ |
| C-11 | 拒否メッセージは「This CSR was denied by kubectl certificate deny.」 | E-08 L209 | ○ |
| C-12 | certificates/v1 APIのみサポート | E-03 L106 v1.NewForConfig | ○ |
| C-13 | 対象が0件の場合「No resources found」を表示 | E-09 L273-275 | ○ |
| C-14 | CSRのLastUpdateTimeに現在時刻を設定 | E-10 L299 metav1.Now() | ○ |
| C-15 | 関連機能は証明書管理(105)、Certificate署名コントローラー(26) | E-11 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全ての主張に対してソースコードからの直接的な根拠が存在する。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - CSR操作のフローはソースコードから直接確認可能
- 0: 低リスク - エラーメッセージはソースコードのリテラル文字列と一致

## 6) レビュアーチェックリスト（最小）
- [ ] approve/denyの条件タイプ・理由・メッセージがソースコードと一致するか確認
- [ ] コンフリクトリトライの動作仕様が正確か確認
- [ ] --forceフラグの挙動が既存条件がある場合とない場合で正しく記載されているか確認
