---
generated_at: 2026-02-02 10:10:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：13-kubectl cluster-info 画面設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  1. 特になし - 全主張にソースコードの根拠あり
  2. プロキシURLの構築ロジック（GroupVersionの分岐）は複雑なため実動作確認推奨
  3. dumpサブコマンドの詳細は別ファイルのため本設計書ではカバー外

## 2) 参照した情報（Evidence一覧）

- E-01: `staging/src/k8s.io/kubectl/pkg/cmd/clusterinfo/clusterinfo.go` L49-56（ClusterInfoOptions）
- E-02: `staging/src/k8s.io/kubectl/pkg/cmd/clusterinfo/clusterinfo.go` L58-75（NewCmdClusterInfo）
- E-03: `staging/src/k8s.io/kubectl/pkg/cmd/clusterinfo/clusterinfo.go` L77-92（Complete）
- E-04: `staging/src/k8s.io/kubectl/pkg/cmd/clusterinfo/clusterinfo.go` L94-155（Run）
- E-05: `staging/src/k8s.io/kubectl/pkg/cmd/clusterinfo/clusterinfo.go` L157-162（printService）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 画面No.13行
- E-07: `docs/code-to-docs/画面一覧/画面一覧.csv` No.13行

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デフォルト名前空間はkube-system | E-03 L85-88 | ○ |
| C-02 | ラベルセレクタはkubernetes.io/cluster-service=true | E-04 L99 | ○ |
| C-03 | コントロールプレーンアドレスはClient.Hostから取得 | E-04 L106 | ○ |
| C-04 | LoadBalancer Ingressがある場合はそのIP/Hostnameを使用 | E-04 L111-119 | ○ |
| C-05 | ポート名がhttpsまたは番号443の場合にHTTPSスキーム使用 | E-04 L128-129 | ○ |
| C-06 | Service名にkubernetes.io/nameラベル値を優先使用 | E-04 L143-146 | ○ |
| C-07 | プロキシURL構築にGroupVersionの分岐がある | E-04 L136-141 | ○ |
| C-08 | 最後にデバッグガイダンスメッセージを出力 | E-04 L151 | ○ |
| C-09 | dumpサブコマンドが登録されている | E-02 L73 | ○ |
| C-10 | 読み取り専用コマンドでデータ変更なし | E-04（全体フロー確認） | ○ |
| C-11 | 表示形式は「<name> is running at <link>」 | E-05 L158-161 | ○ |
| C-12 | 関連機能はクラスター情報(108)、API Serverコア(1) | E-06 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 読み取り専用コマンドでデータ変更を伴わない
- 0: 低リスク - 表示ロジックはソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] プロキシURLのGroupVersion分岐が正確に記載されているか確認
- [ ] LoadBalancer Ingressのアドレス取得ロジックが正しいか確認
- [ ] dumpサブコマンドの詳細が必要な場合は別途設計書を参照すること
