---
generated_at: 2026-02-02 10:15:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：14-kubectl top 画面設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **表示カラム名の正確性**：テーブルヘッダの正確な文字列はmetricsutil内の実装で定義されており、本分析ではそこまで追跡していない
  2. **Swap表示の詳細仕様**：Swap表示機能は比較的新しい機能であり、ノードのSwap情報の取得方法に注意
  3. **metricsCreationDelayの値**：2分という値はtop_pod.goのconst定義から取得

## 2) 参照した情報（Evidence一覧）

- E-01: `staging/src/k8s.io/kubectl/pkg/cmd/top/top.go` L30-98（定数定義、NewCmdTop、APIバージョン確認）
- E-02: `staging/src/k8s.io/kubectl/pkg/cmd/top/top_node.go` L41-56（TopNodeOptions）
- E-03: `staging/src/k8s.io/kubectl/pkg/cmd/top/top_node.go` L72-102（NewCmdTopNode）
- E-04: `staging/src/k8s.io/kubectl/pkg/cmd/top/top_node.go` L148-213（RunTopNode）
- E-05: `staging/src/k8s.io/kubectl/pkg/cmd/top/top_node.go` L216-239（getNodeMetricsFromMetricsAPI）
- E-06: `staging/src/k8s.io/kubectl/pkg/cmd/top/top_pod.go` L45-64（TopPodOptions）
- E-07: `staging/src/k8s.io/kubectl/pkg/cmd/top/top_pod.go` L91-123（NewCmdTopPod）
- E-08: `staging/src/k8s.io/kubectl/pkg/cmd/top/top_pod.go` L173-223（RunTopPod）
- E-09: `staging/src/k8s.io/kubectl/pkg/cmd/top/top_pod.go` L252-279（verifyEmptyMetrics）
- E-10: `staging/src/k8s.io/kubectl/pkg/cmd/top/top_pod.go` L281-290（checkPodAge）
- E-11: `staging/src/k8s.io/kubectl/pkg/cmd/top/top_pod.go` L66（metricsCreationDelay定数）
- E-12: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 画面No.14行

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | topコマンドはnode/podの2サブコマンドを持つ | E-01 L78-79 | ○ |
| C-02 | Metrics APIバージョンはv1beta1のみサポート | E-01 L36-38 | ○ |
| C-03 | sort-byはcpuまたはmemoryのみ受け付ける | E-02 top_node.go L137-139, E-06 top_pod.go L162-164 | ○ |
| C-04 | Protocol Buffersはデフォルトtrue | E-03 L74-77, E-07 L93-96 | ○ |
| C-05 | ノードのAllocatableまたはCapacityを基準に使用率計算 | E-04 L196-201 | ○ |
| C-06 | Swap情報はNodeInfo.Swap.Capacityから取得 | E-04 L204-209 | ○ |
| C-07 | Pod作成後2分はメトリクス利用不可 | E-11 L66, E-10 L282-283 | ○ |
| C-08 | メトリクスが空でPod作成後2分超の場合エラー | E-10 L284-285 | ○ |
| C-09 | NAMEとselectorは同時指定不可 | E-02 L142-144, E-06 L167-169 | ○ |
| C-10 | Metrics API未対応時「Metrics API not available」エラー | E-04 L165-167, E-08 L197-199 | ○ |
| C-11 | top podで--containersフラグでコンテナ別表示 | E-07 L116 | ○ |
| C-12 | top podで--all-namespacesで全名前空間対応 | E-07 L117 | ○ |
| C-13 | top podで--sumフラグで合計表示 | E-07 L120 | ○ |
| C-14 | 表示テーブルのカラム名（NAME, CPU, MEMORY等） | metricsutil（未確認） | △ |
| C-15 | 関連機能はトップ(103)、メトリクスサーバー連携(151) | E-12 | ○ |

## 4) 不足情報（Unknown / Missing）
- C-14の表示テーブルカラム名の正確な文字列は`staging/src/k8s.io/kubectl/pkg/metricsutil/`内のPrinter実装に定義されている。本分析ではこのファイルまでは追跡していない。
  - 候補：`staging/src/k8s.io/kubectl/pkg/metricsutil/metrics_printer.go`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 読み取り専用コマンド
- 1: 中リスク - 表示カラムの正確な名称はmetricsutil内の実装確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 表示テーブルのカラム名がmetricsutil実装と一致するか確認
- [ ] Swap表示機能が正しく動作するか実機確認
- [ ] metricsCreationDelay（2分）の値が最新コードと一致するか確認
- [ ] Protocol Buffersデフォルト有効の影響を確認
