---
generated_at: 2026-02-02 10:20:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：15-kubectl cordon 画面設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  1. 特になし - 全主張にソースコードの根拠あり
  2. CordonHelperの内部実装（PatchOrReplace）は別パッケージのため、詳細動作は追加確認推奨
  3. dry-runの挙動は共通ユーティリティに依存

## 2) 参照した情報（Evidence一覧）

- E-01: `staging/src/k8s.io/kubectl/pkg/cmd/drain/drain.go` L44-55（DrainCmdOptions）
- E-02: `staging/src/k8s.io/kubectl/pkg/cmd/drain/drain.go` L57-64（cordonLong/cordonExample）
- E-03: `staging/src/k8s.io/kubectl/pkg/cmd/drain/drain.go` L66-84（NewCmdCordon）
- E-04: `staging/src/k8s.io/kubectl/pkg/cmd/drain/drain.go` L243-322（Complete）
- E-05: `staging/src/k8s.io/kubectl/pkg/cmd/drain/drain.go` L402-458（RunCordonOrUncordon）
- E-06: `staging/src/k8s.io/kubectl/pkg/cmd/drain/drain.go` L462-474（already/changed関数）
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 画面No.15行

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | cordonはspec.unschedulableをtrueに設定する | E-05 L402（desired=true） | ○ |
| C-02 | ノード名とセレクタは排他的 | E-04 L249-251 | ○ |
| C-03 | 既にcordon済みなら「already cordoned」を表示 | E-05 L422-428, E-06 L463-465 | ○ |
| C-04 | cordon成功時は「cordoned」を表示 | E-05 L440-445, E-06 L469-471 | ○ |
| C-05 | PatchOrReplaceでノードを更新 | E-05 L431 | ○ |
| C-06 | dry-run=clientの場合はAPI Server呼び出しなし | E-05 L430 | ○ |
| C-07 | --selectorと--dry-runフラグが利用可能 | E-03 L81-82 | ○ |
| C-08 | 引数未指定時にUSAGEエラー | E-04 L246-248 | ○ |
| C-09 | cordonとuncordonは同一関数で実装 | E-05 L402-406 | ○ |
| C-10 | パッチ失敗時はエラーメッセージを表示して次のノードに続行 | E-05 L432-438 | ○ |
| C-11 | Node種別でない場合は「skipped」を表示 | E-05 L447-453 | ○ |
| C-12 | 関連機能はドレイン(93)、Node Lifecycleコントローラー(18) | E-07 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - シンプルなフィールド更新操作

## 6) レビュアーチェックリスト（最小）
- [ ] CordonHelperのPatchOrReplace実装が正しくspec.unschedulableを更新するか確認
- [ ] dry-run=serverの動作がAPI Server側で正しく処理されるか確認
